/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.ReflectionTextComponentUpdater;
import org.netbeans.modules.maven.api.customizer.support.TextComponentUpdater;
import org.netbeans.modules.maven.customizer.Bundle;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class BasicInfoPanel
extends JPanel
implements DocumentListener {
    private final ModelHandle2 handle;
    private List<TextComponentUpdater> listeners;
    private final ProjectCustomizer.Category category;
    private JScrollPane jScrollPane1;
    private JLabel lblArtifactId;
    private JLabel lblDescription;
    private JLabel lblGroupId;
    private JLabel lblName;
    private JLabel lblPackaging;
    private JLabel lblVersion;
    private JTextArea taDescription;
    private JTextField txtArtifactId;
    private JTextField txtGroupId;
    private JTextField txtName;
    private JTextField txtPackaging;
    private JTextField txtVersion;

    public BasicInfoPanel(ModelHandle2 handle, ProjectCustomizer.Category category) {
        this.initComponents();
        this.handle = handle;
        this.category = category;
        this.initValues();
    }

    private void initValues() {
        MavenProject project;
        Project mdl = this.handle.getPOMModel().getProject();
        try {
            project = this.handle.getProject().getParent();
        }
        catch (IllegalStateException x) {
            project = null;
        }
        this.listeners = new ArrayList<TextComponentUpdater>();
        try {
            this.listeners.add(new ReflectionTextComponentUpdater("getGroupId", mdl, (Object)project, this.txtGroupId, this.lblGroupId, this.handle, new ReflectionTextComponentUpdater.Operation(){

                public void performOperation(POMModel model) {
                    model.getProject().setGroupId(this.getNewValue());
                }
            }));
            this.listeners.add(new ReflectionTextComponentUpdater("getArtifactId", mdl, (Object)project, this.txtArtifactId, this.lblArtifactId, this.handle, new ReflectionTextComponentUpdater.Operation(){

                public void performOperation(POMModel model) {
                    model.getProject().setArtifactId(this.getNewValue());
                }
            }));
            this.listeners.add(new ReflectionTextComponentUpdater("getVersion", mdl, (Object)project, this.txtVersion, this.lblVersion, this.handle, new ReflectionTextComponentUpdater.Operation(){

                public void performOperation(POMModel model) {
                    model.getProject().setVersion(this.getNewValue());
                }
            }));
            this.listeners.add(new ReflectionTextComponentUpdater("getName", mdl, (Object)project, this.txtName, this.lblName, this.handle, new ReflectionTextComponentUpdater.Operation(){

                public void performOperation(POMModel model) {
                    model.getProject().setName(this.getNewValue());
                }
            }));
            this.listeners.add(new ReflectionTextComponentUpdater("getPackaging", mdl, (Object)project, this.txtPackaging, this.lblPackaging, this.handle, new ReflectionTextComponentUpdater.Operation(){

                public void performOperation(POMModel model) {
                    model.getProject().setPackaging(this.getNewValue());
                }
            }));
            this.listeners.add(new ReflectionTextComponentUpdater("getDescription", mdl, (Object)project, this.taDescription, this.lblDescription, this.handle, new ReflectionTextComponentUpdater.Operation(){

                public void performOperation(POMModel model) {
                    model.getProject().setDescription(this.getNewValue());
                }
            }));
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        this.txtGroupId.getDocument().addDocumentListener(this);
        this.txtArtifactId.getDocument().addDocumentListener(this);
    }

    private void initComponents() {
        this.lblGroupId = new JLabel();
        this.txtGroupId = new JTextField();
        this.lblArtifactId = new JLabel();
        this.txtArtifactId = new JTextField();
        this.lblVersion = new JLabel();
        this.txtVersion = new JTextField();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.lblPackaging = new JLabel();
        this.txtPackaging = new JTextField();
        this.lblDescription = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.lblGroupId.setLabelFor(this.txtGroupId);
        Mnemonics.setLocalizedText((JLabel)this.lblGroupId, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_GroupId"));
        this.lblArtifactId.setLabelFor(this.txtArtifactId);
        Mnemonics.setLocalizedText((JLabel)this.lblArtifactId, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_ArtifactId"));
        this.lblVersion.setLabelFor(this.txtVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblVersion, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Version"));
        this.lblName.setLabelFor(this.txtName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Name"));
        this.lblPackaging.setLabelFor(this.txtPackaging);
        Mnemonics.setLocalizedText((JLabel)this.lblPackaging, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Packaging"));
        this.lblDescription.setLabelFor(this.taDescription);
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(BasicInfoPanel.class, (String)"LBL_Description"));
        this.taDescription.setColumns(20);
        this.taDescription.setRows(5);
        this.jScrollPane1.setViewportView(this.taDescription);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGroupId).addComponent(this.lblArtifactId).addComponent(this.lblVersion).addComponent(this.lblPackaging).addComponent(this.lblName).addComponent(this.lblDescription)).addGap(40, 40, 40).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 302, Short.MAX_VALUE).addComponent(this.txtVersion, GroupLayout.Alignment.LEADING, -1, 302, Short.MAX_VALUE).addComponent(this.txtArtifactId, GroupLayout.Alignment.LEADING, -1, 302, Short.MAX_VALUE).addComponent(this.txtGroupId, GroupLayout.Alignment.LEADING, -1, 302, Short.MAX_VALUE).addComponent(this.txtName, GroupLayout.Alignment.LEADING, -1, 302, Short.MAX_VALUE).addComponent(this.txtPackaging, GroupLayout.Alignment.LEADING, -1, 302, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtGroupId, -2, -1, -2).addComponent(this.lblGroupId, -2, 15, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtArtifactId, -2, -1, -2).addComponent(this.lblArtifactId)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtVersion, -2, -1, -2).addComponent(this.lblVersion)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPackaging, -2, -1, -2).addComponent(this.lblPackaging)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtName, -2, -1, -2).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addComponent(this.lblDescription)).addContainerGap()));
    }

    @Override
    public void insertUpdate(DocumentEvent arg0) {
        this.checkCoords();
    }

    @Override
    public void removeUpdate(DocumentEvent arg0) {
        this.checkCoords();
    }

    @Override
    public void changedUpdate(DocumentEvent arg0) {
        this.checkCoords();
    }

    private void checkCoords() {
        boolean isValid = this.checkCoord(this.txtGroupId);
        if (isValid) {
            isValid = this.checkCoord(this.txtArtifactId);
        }
        this.category.setValid(isValid);
    }

    private boolean checkCoord(JTextField field) {
        String coord = field.getText();
        boolean result = false;
        try {
            String escaped = XMLUtil.toAttributeValue((String)coord);
            result = escaped.length() == coord.length() && coord.indexOf(">") == -1 && coord.indexOf(" ") == -1;
        }
        catch (CharConversionException ex) {
            // empty catch block
        }
        if (result) {
            result = !this.containsMultiByte(coord);
        } else {
            this.category.setErrorMessage(Bundle.ERR_Coord_breaks_pom());
        }
        if (result) {
            this.category.setErrorMessage(null);
        }
        return result;
    }

    boolean containsMultiByte(String text) {
        char[] textChars = text.toCharArray();
        for (int i = 0; i < textChars.length; ++i) {
            if (textChars[i] <= '\u00ff') continue;
            this.category.setErrorMessage(Bundle.ERR_multibyte());
            return true;
        }
        return false;
    }
}

