/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.cos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.DirectoryScanner;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.cos.CosChecker;
import org.netbeans.modules.maven.spi.cos.AdditionalDestination;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CopyResourcesOnSave
extends FileChangeAdapter {
    private static final RequestProcessor RP = new RequestProcessor(CopyResourcesOnSave.class);
    private static final Logger LOG = Logger.getLogger(CopyResourcesOnSave.class.getName());
    private final NbMavenProject nbproject;
    private final Set<File> resourceUris = new HashSet<File>();
    private final Project project;
    private PropertyChangeListener pchl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if ("MavenProject".equals(pce.getPropertyName())) {
                CopyResourcesOnSave.this.refresh();
            }
        }
    };

    public CopyResourcesOnSave(NbMavenProject nbprj, Project prj) {
        this.nbproject = nbprj;
        this.project = prj;
    }

    public final void opened() {
        this.refresh();
        this.nbproject.addPropertyChangeListener(this.pchl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closed() {
        this.nbproject.removePropertyChangeListener(this.pchl);
        Set<File> set = this.resourceUris;
        synchronized (set) {
            for (File fl : this.resourceUris) {
                FileUtil.removeRecursiveListener((FileChangeListener)this, (File)fl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void refresh() {
        Set<File> set = this.resourceUris;
        synchronized (set) {
            ArrayList resources = new ArrayList();
            resources.addAll(this.nbproject.getMavenProject().getResources());
            resources.addAll(this.nbproject.getMavenProject().getTestResources());
            HashSet<File> old = new HashSet<File>(this.resourceUris);
            HashSet<File> added = new HashSet<File>();
            if (resources != null) {
                for (Resource res : resources) {
                    String dir = res.getDirectory();
                    if (dir == null) continue;
                    URI uri = FileUtilities.getDirURI(this.project.getProjectDirectory(), dir);
                    File file = Utilities.toFile((URI)uri);
                    if (!old.contains(file) && !added.contains(file)) {
                        FileUtil.addRecursiveListener((FileChangeListener)this, (File)file);
                    }
                    added.add(file);
                }
            }
            old.removeAll(added);
            for (File oldFile : old) {
                FileUtil.removeRecursiveListener((FileChangeListener)this, (File)oldFile);
            }
            this.resourceUris.removeAll(old);
            this.resourceUris.addAll(added);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySrcToDest(FileObject srcFile, FileObject destFile) throws IOException {
        if (destFile != null && !srcFile.isFolder()) {
            InputStream is = null;
            OutputStream os = null;
            FileLock fl = null;
            try {
                is = srcFile.getInputStream();
                fl = destFile.lock();
                os = destFile.getOutputStream(fl);
                FileUtil.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (fl != null) {
                    fl.releaseLock();
                }
            }
        }
    }

    private Project getOwningMavenProject(FileObject file) {
        Project prj = FileOwnerQuery.getOwner((FileObject)file);
        if (prj == null || !prj.equals(this.project)) {
            return null;
        }
        if (!prj.getProjectDirectory().isValid()) {
            return null;
        }
        NbMavenProject mvn = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        if (mvn == null) {
            return null;
        }
        if (RunUtils.hasTestCompileOnSaveEnabled(prj) || RunUtils.hasApplicationCompileOnSaveEnabled(prj)) {
            return prj;
        }
        return null;
    }

    public void fileChanged(final FileEvent fe) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                CopyResourcesOnSave.this.fileChangedImpl(fe);
            }
        });
    }

    private void fileChangedImpl(FileEvent fe) {
        Project owning = this.getOwningMavenProject(fe.getFile());
        if (owning == null) {
            return;
        }
        try {
            this.handleCopyFileToDestDir(fe.getFile(), owning);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    public void fileDataCreated(final FileEvent fe) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                CopyResourcesOnSave.this.fileDataCreatedImpl(fe);
            }
        });
    }

    private void fileDataCreatedImpl(FileEvent fe) {
        Project owning = this.getOwningMavenProject(fe.getFile());
        if (owning == null) {
            return;
        }
        try {
            this.handleCopyFileToDestDir(fe.getFile(), owning);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    public void fileRenamed(final FileRenameEvent fe) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                CopyResourcesOnSave.this.fileRenamedImpl(fe);
            }
        });
    }

    private void fileRenamedImpl(FileRenameEvent fe) {
        try {
            FileObject fo = fe.getFile();
            Project owning = this.getOwningMavenProject(fo);
            if (owning == null) {
                return;
            }
            Tuple base = this.findAppropriateResourceRoots(fo, owning);
            if (base != null) {
                this.handleCopyFileToDestDir(base, fo, owning);
                FileObject parent = fo.getParent();
                String path = FileUtil.isParentOf((FileObject)base.root, (FileObject)parent) ? FileUtil.getRelativePath((FileObject)base.root, (FileObject)fo.getParent()) + "/" + fe.getName() + "." + fe.getExt() : fe.getName() + "." + fe.getExt();
                this.handleDeleteFileInDestDir(fo, path, base, owning);
            }
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
    }

    public void fileDeleted(final FileEvent fe) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                CopyResourcesOnSave.this.fileDeletedImpl(fe);
            }
        });
    }

    private void fileDeletedImpl(FileEvent fe) {
        Project owning = this.getOwningMavenProject(fe.getFile());
        if (owning == null) {
            return;
        }
        try {
            this.handleDeleteFileInDestDir(fe.getFile(), null, owning);
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    private void handleDeleteFileInDestDir(FileObject fo, String path, Project project) throws IOException {
        Tuple tuple = this.findAppropriateResourceRoots(fo, project);
        this.handleDeleteFileInDestDir(fo, path, tuple, project);
    }

    private void handleDeleteFileInDestDir(FileObject fo, String path, Tuple tuple, Project project) throws IOException {
        if (tuple != null) {
            AdditionalDestination add;
            path = path != null ? path : FileUtil.getRelativePath((FileObject)tuple.root, (FileObject)fo);
            FileObject toDelete = tuple.destinationRoot.getFileObject(path = this.addTargetPath(path, tuple.resource));
            if (toDelete != null) {
                toDelete.delete();
            }
            if ((add = (AdditionalDestination)project.getLookup().lookup(AdditionalDestination.class)) != null) {
                add.delete(fo, path);
            }
        }
    }

    private void handleCopyFileToDestDir(FileObject fo, Project prj) throws IOException {
        Tuple tuple = this.findAppropriateResourceRoots(fo, prj);
        this.handleCopyFileToDestDir(tuple, fo, prj);
    }

    private void handleCopyFileToDestDir(Tuple tuple, FileObject fo, Project project) throws IOException {
        if (tuple != null && !tuple.resource.isFiltering()) {
            String path = FileUtil.getRelativePath((FileObject)tuple.root, (FileObject)fo);
            path = this.addTargetPath(path, tuple.resource);
            CopyResourcesOnSave.createAndCopy(fo, tuple.destinationRoot, path);
            AdditionalDestination add = (AdditionalDestination)project.getLookup().lookup(AdditionalDestination.class);
            if (add != null) {
                add.copy(fo, path);
            }
        }
    }

    private static synchronized void createAndCopy(FileObject fo, FileObject root, String path) throws IOException {
        CopyResourcesOnSave.copySrcToDest(fo, CopyResourcesOnSave.ensureDestinationFileExists(root, path, fo.isFolder()));
    }

    private String addTargetPath(String path, Resource resource) {
        String target = resource.getTargetPath();
        if (target != null) {
            target = (target = target.replace("\\", "/")).endsWith("/") ? target : target + "/";
            path = target + path;
        }
        return path;
    }

    private Tuple findAppropriateResourceRoots(FileObject child, Project prj) {
        Tuple tup;
        Tuple tup2;
        NbMavenProject nbproj = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        assert (nbproj != null);
        boolean test = RunUtils.hasTestCompileOnSaveEnabled(prj);
        if (test && (tup2 = this.findResource(nbproj.getMavenProject().getTestResources(), prj, nbproj, child, true)) != null) {
            return tup2;
        }
        boolean main = RunUtils.hasApplicationCompileOnSaveEnabled(prj);
        if ((test || main) && (tup = this.findResource(nbproj.getMavenProject().getResources(), prj, nbproj, child, false)) != null) {
            return tup;
        }
        return null;
    }

    private Tuple findResource(List<Resource> resources, Project prj, NbMavenProject nbproj, FileObject child, boolean test) {
        if (resources == null) {
            return null;
        }
        File fil = nbproj.getOutputDirectory(test);
        File stamp = new File(fil, ".netbeans_automatic_build");
        if (!stamp.exists()) {
            return null;
        }
        FileObject target = FileUtil.toFileObject((File)fil);
        block0: for (Resource res : resources) {
            URI uri;
            FileObject fo;
            String dir = res.getDirectory();
            if (dir == null || (fo = FileUtil.toFileObject((File)Utilities.toFile((URI)(uri = FileUtilities.getDirURI(prj.getProjectDirectory(), dir))))) == null || !FileUtil.isParentOf((FileObject)fo, (FileObject)child)) continue;
            String path = FileUtil.getRelativePath((FileObject)fo, (FileObject)child);
            List<String> incls = res.getIncludes();
            if (incls.isEmpty()) {
                incls = Arrays.asList(CosChecker.DEFAULT_INCLUDES);
            }
            boolean included = false;
            for (String incl : incls) {
                if (!DirectoryScanner.match((String)incl, (String)path)) continue;
                included = true;
                break;
            }
            if (!included) break;
            ArrayList<String> excls = new ArrayList<String>(res.getExcludes());
            excls.addAll(Arrays.asList(DirectoryScanner.DEFAULTEXCLUDES));
            for (String excl : excls) {
                if (!DirectoryScanner.match((String)excl, (String)path)) continue;
                continue block0;
            }
            return new Tuple(res, fo, target);
        }
        return null;
    }

    private static FileObject ensureDestinationFileExists(FileObject root, String path, boolean isFolder) throws IOException {
        if (isFolder) {
            return FileUtil.createFolder((FileObject)root, (String)path);
        }
        return FileUtil.createData((FileObject)root, (String)path);
    }

    private class Tuple {
        Resource resource;
        FileObject root;
        FileObject destinationRoot;

        private Tuple(Resource res, FileObject fo, FileObject destFolder) {
            this.resource = res;
            this.root = fo;
            this.destinationRoot = destFolder;
        }
    }
}

