/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.classpath;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.classpath.CompileClassPathImpl;
import org.netbeans.modules.maven.classpath.EndorsedClassPathImpl;
import org.netbeans.modules.maven.classpath.PackagedClassPathImpl;
import org.netbeans.modules.maven.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.SourceClassPathImpl;
import org.netbeans.modules.maven.classpath.TestCompileClassPathImpl;
import org.netbeans.modules.maven.classpath.TestRuntimeClassPathImpl;
import org.netbeans.modules.maven.classpath.TestSourceClassPathImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class ClassPathProviderImpl
implements ClassPathProvider,
ActiveJ2SEPlatformProvider,
ProjectSourcesClassPathProvider {
    private static final int TYPE_SRC = 0;
    private static final int TYPE_TESTSRC = 1;
    private static final int TYPE_WEB = 5;
    private static final int TYPE_UNKNOWN = -1;
    @NonNull
    private final Project proj;
    private ClassPath[] cache = new ClassPath[9];
    private BootClassPathImpl bcpImpl;
    private EndorsedClassPathImpl ecpImpl;

    public ClassPathProviderImpl(@NonNull Project proj) {
        this.proj = proj;
    }

    @Override
    public ClassPath[] getProjectClassPaths(String type) {
        if ("classpath/boot".equals(type)) {
            return new ClassPath[]{this.getBootClassPath()};
        }
        if ("classpath/endorsed".equals(type)) {
            return new ClassPath[]{this.getEndorsedClassPath()};
        }
        if ("classpath/compile".equals(type)) {
            ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
            l.add(this.getCompileTimeClasspath(0));
            l.add(this.getCompileTimeClasspath(1));
            return l.toArray(new ClassPath[l.size()]);
        }
        if ("classpath/execute".equals(type)) {
            ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
            l.add(this.getRuntimeClasspath(0));
            l.add(this.getRuntimeClasspath(1));
            return l.toArray(new ClassPath[l.size()]);
        }
        if ("classpath/source".equals(type)) {
            ArrayList<ClassPath> l = new ArrayList<ClassPath>(2);
            l.add(this.getSourcepath(0));
            l.add(this.getSourcepath(1));
            return l.toArray(new ClassPath[l.size()]);
        }
        return new ClassPath[0];
    }

    @Override
    public ClassPath getProjectSourcesClassPath(String type) {
        if ("classpath/boot".equals(type)) {
            return this.getBootClassPath();
        }
        if ("classpath/endorsed".equals(type)) {
            return this.getEndorsedClassPath();
        }
        if ("classpath/compile".equals(type)) {
            return this.getCompileTimeClasspath(0);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(0);
        }
        if ("classpath/execute".equals(type)) {
            return this.getRuntimeClasspath(0);
        }
        assert (false);
        return null;
    }

    public ClassPath findClassPath(FileObject file, String type) {
        int fileType = this.getType(file);
        if (fileType != 0 && fileType != 1 && fileType != 5) {
            Logger.getLogger(ClassPathProviderImpl.class.getName()).log(Level.FINEST, " bad type={0} for {1}", new Object[]{type, file});
            return null;
        }
        if (type.equals("classpath/compile")) {
            return this.getCompileTimeClasspath(fileType);
        }
        if (type.equals("classpath/execute")) {
            return this.getRuntimeClasspath(fileType);
        }
        if ("classpath/source".equals(type)) {
            return this.getSourcepath(fileType);
        }
        if (type.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (type.equals("classpath/endorsed")) {
            return this.getEndorsedClassPath();
        }
        if (type.equals("classpath/packaged")) {
            return this.getProvidedClassPath();
        }
        if (type.equals("classpath/processor")) {
            return this.getCompileTimeClasspath(fileType);
        }
        return null;
    }

    private synchronized ClassPath getProvidedClassPath() {
        ClassPath cp = this.cache[7];
        if (cp == null) {
            this.cache[7] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)new PackagedClassPathImpl((NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class)));
        }
        return cp;
    }

    private boolean isChildOf(FileObject child, URI[] uris) {
        for (int i = 0; i < uris.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(uris[i]);
            if (fo == null || !fo.isFolder() || !fo.equals(child) && !FileUtil.isParentOf((FileObject)fo, (FileObject)child)) continue;
            return true;
        }
        return false;
    }

    public static FileObject[] convertStringsToFileObjects(List<String> strings) {
        FileObject[] fos = new FileObject[strings.size()];
        int index = 0;
        for (String str : strings) {
            File fil = new File(str);
            fil = FileUtil.normalizeFile((File)fil);
            fos[index] = FileUtil.toFileObject((File)fil);
            ++index;
        }
        return fos;
    }

    private int getType(FileObject file) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
        if (this.isChildOf(file, project.getSourceRoots(false)) || this.isChildOf(file, project.getGeneratedSourceRoots(false))) {
            return 0;
        }
        if (this.isChildOf(file, project.getSourceRoots(true)) || this.isChildOf(file, project.getGeneratedSourceRoots(true))) {
            return 1;
        }
        URI web = project.getWebAppDirectory();
        FileObject fo = FileUtil.toFileObject((File)Utilities.toFile((URI)web));
        if (fo != null && (fo.equals(file) || FileUtil.isParentOf((FileObject)fo, (FileObject)file))) {
            return 5;
        }
        if (this.isChildOf(file, project.getResources(false))) {
            return 0;
        }
        if (this.isChildOf(file, project.getResources(true))) {
            return 1;
        }
        return -1;
    }

    private synchronized ClassPath getSourcepath(int type) {
        ClassPath cp;
        if (type == 5) {
            type = 0;
        }
        if ((cp = this.cache[type]) == null) {
            NbMavenProjectImpl project = (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new SourceClassPathImpl(project)) : ClassPathFactory.createClassPath((ClassPathImplementation)new TestSourceClassPathImpl(project));
            this.cache[type] = cp;
        }
        return cp;
    }

    private synchronized ClassPath getCompileTimeClasspath(int type) {
        ClassPath cp;
        if (type == 5) {
            type = 0;
        }
        if ((cp = this.cache[2 + type]) == null) {
            NbMavenProjectImpl project = (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new CompileClassPathImpl(project)) : ClassPathFactory.createClassPath((ClassPathImplementation)new TestCompileClassPathImpl(project));
            this.cache[2 + type] = cp;
        }
        return cp;
    }

    private synchronized ClassPath getRuntimeClasspath(int type) {
        ClassPath cp;
        if (type == 5) {
            type = 0;
        }
        if ((cp = this.cache[4 + type]) == null) {
            NbMavenProjectImpl project = (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
            cp = type == 0 ? ClassPathFactory.createClassPath((ClassPathImplementation)new RuntimeClassPathImpl(project)) : ClassPathFactory.createClassPath((ClassPathImplementation)new TestRuntimeClassPathImpl(project));
            this.cache[4 + type] = cp;
        }
        return cp;
    }

    private synchronized ClassPath getBootClassPath() {
        ClassPath cp = this.cache[6];
        if (cp == null) {
            this.cache[6] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)this.getBootClassPathImpl());
        }
        return cp;
    }

    private synchronized BootClassPathImpl getBootClassPathImpl() {
        if (this.bcpImpl == null) {
            this.bcpImpl = new BootClassPathImpl((NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class), this.getEndorsedClassPathImpl());
        }
        return this.bcpImpl;
    }

    @Override
    @NonNull
    public JavaPlatform getJavaPlatform() {
        return this.getBootClassPathImpl().findActivePlatform();
    }

    private synchronized EndorsedClassPathImpl getEndorsedClassPathImpl() {
        if (this.ecpImpl == null) {
            this.ecpImpl = new EndorsedClassPathImpl((NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class));
        }
        return this.ecpImpl;
    }

    private ClassPath getEndorsedClassPath() {
        ClassPath cp = this.cache[8];
        if (cp == null) {
            this.getBootClassPathImpl();
            this.cache[8] = cp = ClassPathFactory.createClassPath((ClassPathImplementation)this.getEndorsedClassPathImpl());
        }
        return cp;
    }
}

