/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.MavenProjectPropsImpl;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.project.ProjectConfiguration;

public final class ModelHandle {
    public static final String PANEL_RUN = "RUN";
    public static final String PANEL_BASIC = "BASIC";
    public static final String PANEL_CONFIGURATION = "CONFIGURATION";
    public static final String PANEL_MAPPING = "MAPPING";
    public static final String PANEL_LIBRARIES = "LIBRARIES";
    public static final String PANEL_SOURCES = "SOURCES";
    public static final String PANEL_COMPILE = "COMPILE";
    private final MavenProjectPropsImpl auxiliaryProps;
    private final POMModel model;
    private final MavenProject project;
    private final Map<String, ActionToGoalMapping> mappings;
    private final Map<ActionToGoalMapping, Boolean> modMappings;
    private List<Configuration> configurations;
    private boolean modModel = false;
    private boolean modConfig = false;
    private Configuration active;

    private ModelHandle(POMModel mdl, MavenProject proj, Map<String, ActionToGoalMapping> mappings, List<Configuration> configs, Configuration active, MavenProjectPropsImpl auxProps) {
        this.model = mdl;
        this.project = proj;
        this.mappings = mappings;
        this.modMappings = new HashMap<ActionToGoalMapping, Boolean>();
        for (ActionToGoalMapping map : mappings.values()) {
            this.modMappings.put(map, Boolean.FALSE);
        }
        this.configurations = configs;
        this.active = active;
        this.auxiliaryProps = auxProps;
    }

    public POMModel getPOMModel() {
        return this.model;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public String getRawAuxiliaryProperty(String propertyName, boolean shared) {
        return this.auxiliaryProps.get(propertyName, shared, false);
    }

    public void setRawAuxiliaryProperty(String propertyName, String value, boolean shared) {
        this.auxiliaryProps.put(propertyName, value, shared);
    }

    public ActionToGoalMapping getActionMappings() {
        return this.mappings.get("%%DEFAULT%%");
    }

    public ActionToGoalMapping getActionMappings(Configuration config) {
        ActionToGoalMapping mapp = this.mappings.get(config.getId());
        if (mapp == null) {
            mapp = new ActionToGoalMapping();
            this.mappings.put(config.getId(), mapp);
            this.modMappings.put(mapp, Boolean.FALSE);
        }
        return mapp;
    }

    public static void setUserActionMapping(NetbeansActionMapping action, ActionToGoalMapping mapp) {
        ModelHandle2.setUserActionMapping(action, mapp);
    }

    @CheckForNull
    public static NetbeansActionMapping getDefaultMapping(String action, Project project) {
        return ModelHandle2.getDefaultMapping(action, project);
    }

    @CheckForNull
    public static NetbeansActionMapping getMapping(String action, Project project, ProjectConfiguration config) {
        return ModelHandle2.getMapping(action, project, config);
    }

    public static void putMapping(NetbeansActionMapping mapp, Project project, ProjectConfiguration config) throws IOException {
        ModelHandle2.putMapping(mapp, project, config);
    }

    public List<Configuration> getConfigurations() {
        return this.configurations;
    }

    public void addConfiguration(Configuration config) {
        assert (config != null);
        this.configurations.add(config);
        this.modConfig = true;
    }

    public void removeConfiguration(Configuration config) {
        assert (config != null);
        this.configurations.remove(config);
        if (this.active == config) {
            this.active = this.configurations.size() > 0 ? this.configurations.get(0) : null;
        }
        this.modConfig = true;
    }

    public Configuration getActiveConfiguration() {
        return this.active;
    }

    public void setActiveConfiguration(Configuration conf) {
        assert (conf != null);
        assert (this.configurations.contains(conf));
        this.active = conf;
    }

    public boolean isModified(Object obj) {
        if (this.modMappings.containsKey(obj)) {
            return this.modMappings.get(obj);
        }
        if (obj == this.model) {
            return this.modModel;
        }
        if (obj == this.configurations || this.configurations.contains(obj)) {
            return this.modConfig;
        }
        return true;
    }

    public void markAsModified(Object obj) {
        if (this.modMappings.containsKey(obj)) {
            this.modMappings.put((ActionToGoalMapping)obj, Boolean.TRUE);
        } else if (obj == this.model) {
            this.modModel = true;
        } else if (obj == this.configurations || this.configurations.contains(obj)) {
            this.modConfig = true;
        } else assert (false) : "Unexpected parameter type " + obj.getClass().getName();
    }

    public static Configuration createProfileConfiguration(String id) {
        Configuration conf = new Configuration();
        conf.setId(id);
        conf.setProfileBased(true);
        return conf;
    }

    public static Configuration createDefaultConfiguration() {
        Configuration conf = new Configuration();
        conf.setId("%%DEFAULT%%");
        conf.setDefault(true);
        return conf;
    }

    public static Configuration createCustomConfiguration(String id) {
        Configuration conf = new Configuration();
        conf.setId(id);
        return conf;
    }

    static {
        AccessorImpl impl = new AccessorImpl();
        impl.assign();
    }

    static class AccessorImpl
    extends CustomizerProviderImpl.ModelAccessor {
        AccessorImpl() {
        }

        @Override
        public ModelHandle createHandle(POMModel model, MavenProject proj, Map<String, ActionToGoalMapping> mapp, List<Configuration> configs, Configuration active, MavenProjectPropsImpl auxProps) {
            return new ModelHandle(model, proj, mapp, configs, active, auxProps);
        }

        public void assign() {
            if (CustomizerProviderImpl.ACCESSOR == null) {
                CustomizerProviderImpl.ACCESSOR = this;
            }
        }
    }

    public static class Configuration
    extends ModelHandle2.Configuration {
    }
}

