/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions.scm;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.actions.scm.Bundle;
import org.netbeans.modules.maven.actions.scm.ui.CheckoutUI;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class CheckoutAction
extends AbstractAction
implements LookupListener {
    private Lookup lookup;
    private Lookup.Result<MavenProject> result;

    public CheckoutAction(Lookup lkp) {
        this.lookup = lkp;
        this.putValue("Name", Bundle.LBL_Checkout());
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/actions/scm/update.png", (boolean)true)));
        this.putValue("iconBase", "org/netbeans/modules/maven/actions/scm/update.png");
        this.result = this.lookup.lookupResult(MavenProject.class);
        this.setEnabled(this.getScm() != null);
        this.result.addLookupListener((LookupListener)this);
    }

    private Scm getScm() {
        Iterator prj = this.result.allInstances().iterator();
        if (!prj.hasNext()) {
            return null;
        }
        MavenProject project = (MavenProject)prj.next();
        return project.getScm();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Iterator prj = this.result.allInstances().iterator();
        if (!prj.hasNext()) {
            return;
        }
        MavenProject project = (MavenProject)prj.next();
        CheckoutUI checkoutUI = new CheckoutUI(project);
        DialogDescriptor dd = new DialogDescriptor((Object)checkoutUI, Bundle.LBL_Checkout());
        dd.setClosingOptions(new Object[]{checkoutUI.getCheckoutButton(), DialogDescriptor.CANCEL_OPTION});
        dd.setOptions(new Object[]{checkoutUI.getCheckoutButton(), DialogDescriptor.CANCEL_OPTION});
        Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (checkoutUI.getCheckoutButton() == ret) {
            RunConfig rc = checkoutUI.getRunConfig();
            if (!rc.getExecutionDirectory().exists()) {
                rc.getExecutionDirectory().mkdirs();
            }
            final File checkoutDir = checkoutUI.getCheckoutDirectory();
            ExecutorTask task = RunUtils.executeMaven(rc);
            task.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    FileObject fo = FileUtil.toFileObject((File)checkoutDir);
                    if (fo != null) {
                        try {
                            Project prj = ProjectManager.getDefault().findProject(fo);
                            if (prj != null) {
                                OpenProjects.getDefault().open(new Project[]{prj}, false);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (IllegalArgumentException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
        }
    }

    public void resultChanged(LookupEvent ev) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CheckoutAction.this.setEnabled(CheckoutAction.this.getScm() != null);
            }
        });
    }
}

