/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.actions.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class ViewJavadocAction
extends AbstractAction {
    private Artifact artifact;

    public ViewJavadocAction(Artifact artifact) {
        this.artifact = artifact;
        this.putValue("Name", Bundle.LBL_View_Javadoc());
        this.setEnabled(this.getJavadocFile().isFile());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        FileObject jarfo;
        File javadocFile = this.getJavadocFile();
        FileObject fo = FileUtil.toFileObject((File)javadocFile);
        if (fo != null && (jarfo = FileUtil.getArchiveRoot((FileObject)fo)) != null) {
            FileObject index = jarfo.getFileObject("apidocs/index.html");
            if (index == null) {
                index = jarfo.getFileObject("index.html");
            }
            if (index == null) {
                index = jarfo;
            }
            URL link = URLMapper.findURL((FileObject)index, (int)1);
            HtmlBrowser.URLDisplayer.getDefault().showURL(link);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.hasJavadocInRepository();
    }

    public boolean hasJavadocInRepository() {
        return !"system".equals(this.artifact.getScope()) && this.getJavadocFile().exists();
    }

    public File getJavadocFile() {
        return ViewJavadocAction.getJavadocFile(this.artifact.getFile());
    }

    private static File getJavadocFile(File artifact) {
        String version = artifact.getParentFile().getName();
        String artifactId = artifact.getParentFile().getParentFile().getName();
        return new File(artifact.getParentFile(), artifactId + "-" + version + "-javadoc.jar");
    }
}

