/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.options.MavenSettings;

public class TestChecker
implements PrerequisitesChecker {
    public static final String PROP_SKIP_TEST = "skipTests";

    @Override
    public boolean checkRunConfig(RunConfig config) {
        String action = config.getActionName();
        if (("test".equals(action) || "test.single".equals(action) || "debug.test.single".equals(action) || "profile-tests".equals(action)) && !RunUtils.hasTestCompileOnSaveEnabled(config)) {
            String test = config.getProperties().get("test");
            String method = config.getProperties().get("nb.single.run.methodName");
            if (test != null && method != null) {
                config.setProperty("nb.single.run.methodName", null);
                config.setProperty("test", test + '#' + method);
            }
        }
        if (MavenSettings.getDefault().isSkipTests() && !String.valueOf(config.getGoals()).contains("test") && config.getProperties().get(PROP_SKIP_TEST) == null) {
            config.setProperty(PROP_SKIP_TEST, "true");
        }
        return true;
    }
}

