/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.ModelReader;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.TransientRepositories;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.cos.CopyResourcesOnSave;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.api.RepositoryIndexer;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.problems.BatchProblemNotifier;
import org.netbeans.modules.maven.queries.MavenFileOwnerQueryImpl;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ProjectOpenedHookImpl
extends ProjectOpenedHook {
    private static final String PROP_BINARIES_CHECKED = "binariesChecked";
    private static final String PROP_JAVADOC_CHECKED = "javadocChecked";
    private static final String PROP_SOURCE_CHECKED = "sourceChecked";
    private final Project proj;
    private TransientRepositories transRepos;
    private final List<URI> uriReferences = new ArrayList<URI>();
    private CopyResourcesOnSave copyResourcesOnSave;
    static final String UI_LOGGER_NAME = "org.netbeans.ui.maven.project";
    static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.maven.project");
    static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.maven";
    static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.maven");
    private static final Logger LOGGER = Logger.getLogger(ProjectOpenedHookImpl.class.getName());
    private static final AtomicBoolean checkedIndices = new AtomicBoolean();
    private final PropertyChangeListener extRootChangeListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            if ("MavenProject".equals(pce.getPropertyName())) {
                NbMavenProjectImpl project = (NbMavenProjectImpl)ProjectOpenedHookImpl.this.proj.getLookup().lookup(NbMavenProjectImpl.class);
                Set newuris = ProjectOpenedHookImpl.this.getProjectExternalSourceRoots(project);
                List list = ProjectOpenedHookImpl.this.uriReferences;
                synchronized (list) {
                    HashSet olduris = new HashSet(ProjectOpenedHookImpl.this.uriReferences);
                    olduris.removeAll(newuris);
                    newuris.removeAll(ProjectOpenedHookImpl.this.uriReferences);
                    for (URI old : olduris) {
                        FileOwnerQuery.markExternalOwner((URI)old, null, (int)0);
                    }
                    for (URI nw : newuris) {
                        FileOwnerQuery.markExternalOwner((URI)nw, (Project)ProjectOpenedHookImpl.this.proj, (int)0);
                    }
                    ProjectOpenedHookImpl.this.uriReferences.removeAll(olduris);
                    ProjectOpenedHookImpl.this.uriReferences.addAll(newuris);
                }
            }
        }
    };

    public ProjectOpenedHookImpl(Project proj) {
        this.proj = proj;
    }

    protected void projectOpened() {
        this.checkBinaryDownloads();
        this.checkSourceDownloads();
        this.checkJavadocDownloads();
        NbMavenProjectImpl project = (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
        project.attachUpdater();
        ProjectOpenedHookImpl.registerWithSubmodules(FileUtil.toFile((FileObject)this.proj.getProjectDirectory()), new HashSet<File>());
        MavenFileOwnerQueryImpl.getInstance().attachProjectListener(project);
        Set<URI> uris = this.getProjectExternalSourceRoots(project);
        for (URI uri : uris) {
            FileOwnerQuery.markExternalOwner((URI)uri, (Project)this.proj, (int)0);
            this.uriReferences.add(uri);
        }
        NbMavenProject watcher = project.getProjectWatcher();
        watcher.addPropertyChangeListener(this.extRootChangeListener);
        ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.proj.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        GlobalPathRegistry.getDefault().register("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().register("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().register("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        GlobalPathRegistry.getDefault().register("classpath/execute", cpProvider.getProjectClassPaths("classpath/execute"));
        BatchProblemNotifier.opened(project);
        LogRecord record = new LogRecord(Level.INFO, "UI_MAVEN_PROJECT_OPENED");
        record.setLoggerName(UI_LOGGER_NAME);
        record.setParameters(new Object[]{watcher.getPackagingType()});
        record.setResourceBundle(NbBundle.getBundle(ProjectOpenedHookImpl.class));
        UI_LOGGER.log(record);
        record = new LogRecord(Level.INFO, "USG_PROJECT_OPEN_MAVEN");
        record.setLoggerName(USG_LOGGER_NAME);
        record.setParameters(new Object[]{watcher.getPackagingType()});
        USG_LOGGER.log(record);
        if (this.transRepos == null) {
            this.transRepos = new TransientRepositories(watcher);
        }
        this.transRepos.register();
        this.copyResourcesOnSave = new CopyResourcesOnSave(watcher, this.proj);
        this.copyResourcesOnSave.opened();
        if (checkedIndices.compareAndSet(false, true) && this.existsDefaultIndexLocation()) {
            final int freq = RepositoryPreferences.getIndexUpdateFrequency();
            new RequestProcessor("Maven Repo Index Transfer/Scan").post(new Runnable(){

                @Override
                public void run() {
                    List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
                    for (RepositoryInfo ri : ris) {
                        if (!ri.isRemoteDownloadable() && !ri.isLocal() || freq == 3) continue;
                        boolean run = false;
                        if (freq == 2) {
                            LOGGER.log(Level.FINER, "Index At Startup :{0}", ri.getId());
                            run = true;
                        } else if (freq == 1 && ProjectOpenedHookImpl.this.checkDiff(ri.getId(), 86400000L)) {
                            LOGGER.log(Level.FINER, "Index Once a Day :{0}", ri.getId());
                            run = true;
                        } else if (freq == 0 && ProjectOpenedHookImpl.this.checkDiff(ri.getId(), 604800000L)) {
                            LOGGER.log(Level.FINER, "Index once a Week :{0}", ri.getId());
                            run = true;
                        }
                        if (!run || !ri.isRemoteDownloadable()) continue;
                        RepositoryIndexer.indexRepo((RepositoryInfo)ri);
                    }
                }
            }, 120000);
        }
    }

    private Set<URI> getProjectExternalSourceRoots(NbMavenProjectImpl project) throws IllegalArgumentException {
        HashSet<URI> uris = new HashSet<URI>();
        HashSet<URI> toRet = new HashSet<URI>();
        uris.addAll(Arrays.asList(project.getSourceRoots(false)));
        uris.addAll(Arrays.asList(project.getSourceRoots(true)));
        uris.addAll(Arrays.asList(project.getGeneratedSourceRoots(false)));
        uris.addAll(Arrays.asList(project.getGeneratedSourceRoots(true)));
        URI rootUri = Utilities.toURI((File)FileUtil.toFile((FileObject)project.getProjectDirectory()));
        File rootDir = Utilities.toFile((URI)rootUri);
        for (URI uri : uris) {
            if (FileUtilities.getRelativePath(rootDir, Utilities.toFile((URI)uri)) != null) continue;
            toRet.add(uri);
        }
        return toRet;
    }

    private boolean existsDefaultIndexLocation() {
        File cacheDir = new File(Places.getCacheDirectory(), "mavenindex");
        return cacheDir.exists() && cacheDir.isDirectory();
    }

    private boolean checkDiff(String repoid, long amount) {
        Date date = RepositoryPreferences.getLastIndexUpdate((String)repoid);
        Date now = new Date();
        LOGGER.log(Level.FINER, "Check Date Diff :{0}", repoid);
        LOGGER.log(Level.FINER, "Last Indexed Date :{0}", SimpleDateFormat.getInstance().format(date));
        LOGGER.log(Level.FINER, "Now :{0}", SimpleDateFormat.getInstance().format(now));
        long diff = now.getTime() - date.getTime();
        LOGGER.log(Level.FINER, "Diff :{0}", diff);
        return diff < 0L || diff > amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void projectClosed() {
        NbMavenProjectImpl project = (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class);
        project.getProjectWatcher().removePropertyChangeListener(this.extRootChangeListener);
        List<URI> list = this.uriReferences;
        synchronized (list) {
            this.uriReferences.clear();
        }
        project.detachUpdater();
        ProjectSourcesClassPathProvider cpProvider = (ProjectSourcesClassPathProvider)this.proj.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        GlobalPathRegistry.getDefault().unregister("classpath/boot", cpProvider.getProjectClassPaths("classpath/boot"));
        GlobalPathRegistry.getDefault().unregister("classpath/source", cpProvider.getProjectClassPaths("classpath/source"));
        GlobalPathRegistry.getDefault().unregister("classpath/compile", cpProvider.getProjectClassPaths("classpath/compile"));
        GlobalPathRegistry.getDefault().unregister("classpath/execute", cpProvider.getProjectClassPaths("classpath/execute"));
        BatchProblemNotifier.closed(project);
        if (this.copyResourcesOnSave != null) {
            this.copyResourcesOnSave.closed();
        }
        this.copyResourcesOnSave = null;
        if (this.transRepos != null) {
            this.transRepos.unregister();
        }
    }

    private void checkBinaryDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getBinaryDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.proj, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.synchronousDependencyDownload();
            prefs.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_BINARIES_CHECKED, false))) {
            watcher.synchronousDependencyDownload();
            prefs.putBoolean(PROP_BINARIES_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void checkJavadocDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getJavadocDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.proj, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.triggerSourceJavadocDownload(true);
            prefs.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_JAVADOC_CHECKED, false))) {
            watcher.triggerSourceJavadocDownload(true);
            prefs.putBoolean(PROP_JAVADOC_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void checkSourceDownloads() {
        boolean alreadyChecked;
        MavenSettings.DownloadStrategy ds = MavenSettings.getDefault().getSourceDownloadStrategy();
        if (ds.equals((Object)MavenSettings.DownloadStrategy.NEVER)) {
            return;
        }
        NbMavenProject watcher = (NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class);
        Preferences prefs = ProjectUtils.getPreferences((Project)this.proj, NbMavenProject.class, (boolean)false);
        if (ds.equals((Object)MavenSettings.DownloadStrategy.EVERY_OPEN)) {
            watcher.triggerSourceJavadocDownload(false);
            prefs.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else if (ds.equals((Object)MavenSettings.DownloadStrategy.FIRST_OPEN) && !(alreadyChecked = prefs.getBoolean(PROP_SOURCE_CHECKED, false))) {
            watcher.triggerSourceJavadocDownload(false);
            prefs.putBoolean(PROP_SOURCE_CHECKED, true);
            try {
                prefs.sync();
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static void registerWithSubmodules(File basedir, Set<File> registered) {
        Model model;
        block22: {
            if (!registered.add(basedir)) {
                return;
            }
            File pom = new File(basedir, "pom.xml");
            if (!pom.isFile()) {
                return;
            }
            ModelReader reader = (ModelReader)EmbedderFactory.getProjectEmbedder().lookupComponent(ModelReader.class);
            try {
                model = reader.read(pom, Collections.singletonMap("org.apache.maven.model.io.isStrict", false));
            }
            catch (IOException x) {
                LOGGER.log(Level.FINE, "could not parse " + pom, x);
                return;
            }
            Parent parent = model.getParent();
            String groupId = model.getGroupId();
            if (groupId == null && parent != null) {
                groupId = parent.getGroupId();
            }
            if (groupId == null) {
                LOGGER.log(Level.WARNING, "no groupId in {0}", pom);
                return;
            }
            String artifactId = model.getArtifactId();
            if (artifactId == null && parent != null) {
                artifactId = parent.getArtifactId();
            }
            if (artifactId == null) {
                LOGGER.log(Level.WARNING, "no artifactId in {0}", pom);
                return;
            }
            String version = model.getVersion();
            if (version == null && parent != null) {
                version = parent.getVersion();
            }
            if (version == null) {
                LOGGER.log(Level.WARNING, "no version in {0}", pom);
                return;
            }
            if (groupId.contains("${") || artifactId.contains("${") || version.contains("${")) {
                LOGGER.log(Level.FINE, "Unevaluated groupId/artifactId/version in {0}", basedir);
                FileObject basedirFO = FileUtil.toFileObject((File)basedir);
                if (basedirFO != null) {
                    try {
                        Project p = ProjectManager.getDefault().findProject(basedirFO);
                        if (p != null) {
                            NbMavenProjectImpl nbmp = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
                            if (nbmp != null) {
                                MavenFileOwnerQueryImpl.getInstance().registerProject(nbmp);
                            } else {
                                LOGGER.log(Level.FINE, "not a Maven project in {0}", basedir);
                            }
                            break block22;
                        }
                        LOGGER.log(Level.FINE, "no project in {0}", basedir);
                    }
                    catch (IOException x) {
                        LOGGER.log(Level.FINE, null, x);
                    }
                } else {
                    LOGGER.log(Level.FINE, "no FileObject for {0}", basedir);
                }
            } else {
                try {
                    MavenFileOwnerQueryImpl.getInstance().registerCoordinates(groupId, artifactId, version, Utilities.toURI((File)basedir).toURL());
                }
                catch (MalformedURLException x) {
                    LOGGER.log(Level.FINE, null, x);
                }
            }
        }
        ProjectOpenedHookImpl.scanForSubmodulesIn((ModelBase)model, basedir, registered);
        model.getProfiles();
        for (Profile profile : model.getProfiles()) {
            ProjectOpenedHookImpl.scanForSubmodulesIn((ModelBase)profile, basedir, registered);
        }
    }

    private static void scanForSubmodulesIn(ModelBase projectOrProfile, File basedir, Set<File> registered) throws IllegalArgumentException {
        for (String module : projectOrProfile.getModules()) {
            if (module == null) continue;
            ProjectOpenedHookImpl.registerWithSubmodules(FileUtilities.resolveFilePath(basedir, module), registered);
        }
    }
}

