/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.maven.Bundle;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.execute.ActionToGoalUtils;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.ModelRunConfig;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.ui.RunGoalsPanel;
import org.netbeans.modules.maven.operations.Operations;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.modules.maven.problems.ProblemsPanel;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.ActionConvertor;
import org.netbeans.modules.maven.spi.actions.MavenActionsProvider;
import org.netbeans.modules.maven.spi.actions.ReplaceTokenProvider;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ActionProviderImpl
implements ActionProvider {
    public static final String BUILD_WITH_DEPENDENCIES = "build-with-dependencies";
    private final Project proj;
    private static String[] supported = new String[]{"build", "build-with-dependencies", "clean", "rebuild", "javadoc", "test", "test.single", "run", "run.single", "debug", "debug.single", "debug.test.single", "debug.fix", "profile", "profile.single", "profile.test.single", "delete", "rename", "move", "copy"};
    private RequestProcessor RP = new RequestProcessor(ActionProviderImpl.class.getName(), 3);

    public ActionProviderImpl(Project proj) {
        this.proj = proj;
    }

    public String[] getSupportedActions() {
        HashSet<String> supp = new HashSet<String>();
        supp.addAll(Arrays.asList(supported));
        for (MavenActionsProvider mavenActionsProvider : ActionToGoalUtils.actionProviders(this.proj)) {
            Set<String> added = mavenActionsProvider.getSupportedDefaultActions();
            if (added == null) continue;
            supp.addAll(added);
        }
        supp.add("run.single.method");
        supp.add("debug.single.method");
        return supp.toArray(new String[0]);
    }

    private boolean usingSurefire28() {
        String v = PluginPropertyUtils.getPluginVersion(((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin");
        return v != null && new ComparableVersion(v).compareTo(new ComparableVersion("2.8")) >= 0;
    }

    private boolean usingJUnit4() {
        for (Artifact a : ((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getArtifacts()) {
            String version;
            if (!"junit".equals(a.getGroupId()) || !"junit".equals(a.getArtifactId()) || (version = a.getVersion()) == null || new ComparableVersion(version).compareTo(new ComparableVersion("4.8")) < 0) continue;
            return true;
        }
        return false;
    }

    private boolean usingTestNG() {
        for (Artifact a : ((NbMavenProject)this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getArtifacts()) {
            if (!"org.testng".equals(a.getGroupId()) || !"testng".equals(a.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    boolean runSingleMethodEnabled() {
        return RunUtils.hasTestCompileOnSaveEnabled(this.proj) || this.usingSurefire28() && (this.usingJUnit4() || this.usingTestNG());
    }

    public void invokeAction(final String action, final Lookup lookup) {
        ActionConvertor convertor;
        if ((action.equals("run.single.method") || action.equals("debug.single.method")) && !this.runSingleMethodEnabled()) {
            StatusDisplayer.getDefault().setStatusText(Bundle.run_single_method_disabled());
            return;
        }
        if ("delete".equals(action)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.proj);
            return;
        }
        if ("copy".equals(action)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.proj);
            return;
        }
        if ("move".equals(action)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.proj);
            return;
        }
        if ("rename".equals(action)) {
            Operations.renameProject((NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class));
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    ActionProviderImpl.this.invokeAction(action, lookup);
                }
            });
            return;
        }
        Collection convertors = this.proj.getLookup().lookupAll(ActionConvertor.class);
        String convertedAction = null;
        Iterator i$ = convertors.iterator();
        while (i$.hasNext() && (convertedAction = (convertor = (ActionConvertor)i$.next()).convert(action, lookup)) == null) {
        }
        if (convertedAction == null) {
            convertedAction = action;
        }
        ProxyLookup enhanced = new ProxyLookup(new Lookup[]{lookup, Lookups.fixed((Object[])new Object[]{ActionProviderImpl.replacements(this.proj, convertedAction, lookup)})});
        RunConfig rc = ActionToGoalUtils.createRunConfig(convertedAction, (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class), (Lookup)enhanced);
        if (rc == null) {
            Logger.getLogger(ActionProviderImpl.class.getName()).log(Level.INFO, "No handling for action: {0}. Ignoring.", action);
        } else {
            this.setupTaskName(action, rc, lookup);
            final ActionProgress listener = ActionProgress.start((Lookup)lookup);
            final ExecutorTask task = RunUtils.run(rc);
            if (task != null) {
                task.addTaskListener(new TaskListener(){

                    public void taskFinished(Task _) {
                        listener.finished(task.result() == 0);
                    }
                });
            } else {
                listener.finished(false);
            }
        }
    }

    public static Map<String, String> replacements(Project proj, String action, Lookup lookup) {
        HashMap<String, String> replacements = new HashMap<String, String>();
        for (ReplaceTokenProvider prov : proj.getLookup().lookupAll(ReplaceTokenProvider.class)) {
            replacements.putAll(prov.createReplacements(action, lookup));
        }
        return replacements;
    }

    private void setupTaskName(String action, RunConfig config, Lookup lkp) {
        String dobjName;
        assert (config instanceof BeanRunConfig);
        BeanRunConfig bc = (BeanRunConfig)config;
        DataObject dobj = (DataObject)lkp.lookup(DataObject.class);
        NbMavenProject prj = (NbMavenProject)bc.getProject().getLookup().lookup(NbMavenProject.class);
        String string = dobjName = dobj != null ? dobj.getName() : "";
        String title = "run".equals(action) ? Bundle.TXT_Run(prj.getMavenProject().getArtifactId()) : ("debug".equals(action) ? Bundle.TXT_Debug(prj.getMavenProject().getArtifactId()) : ("profile".equals(action) ? Bundle.TXT_Profile(prj.getMavenProject().getArtifactId()) : ("test".equals(action) ? Bundle.TXT_Test(prj.getMavenProject().getArtifactId()) : (action.startsWith("run.single") ? Bundle.TXT_Run(dobjName) : (action.startsWith("debug.single") || "debug.test.single".equals(action) ? Bundle.TXT_Debug(dobjName) : (action.startsWith("profile.single") || "profile.test.single".equals(action) ? Bundle.TXT_Profile(dobjName) : ("test.single".equals(action) ? Bundle.TXT_Test(dobjName) : Bundle.TXT_Build(prj.getMavenProject().getArtifactId()))))))));
        bc.setTaskDisplayName(title);
    }

    public boolean isActionEnabled(String action, Lookup lookup) {
        ActionConvertor convertor;
        if ("delete".equals(action) || "rename".equals(action) || "copy".equals(action) || "move".equals(action)) {
            return true;
        }
        if (action.equals("run.single.method") || action.equals("debug.single.method")) {
            return true;
        }
        Collection convertors = this.proj.getLookup().lookupAll(ActionConvertor.class);
        String convertedAction = null;
        Iterator i$ = convertors.iterator();
        while (i$.hasNext() && (convertedAction = (convertor = (ActionConvertor)i$.next()).convert(action, lookup)) == null) {
        }
        if (convertedAction == null) {
            convertedAction = action;
        }
        return ActionToGoalUtils.isActionEnable(convertedAction, (NbMavenProjectImpl)this.proj.getLookup().lookup(NbMavenProjectImpl.class), lookup);
    }

    public Action createCustomMavenAction(String name, NetbeansActionMapping mapping, boolean showUI) {
        return new CustomAction(name, mapping, showUI);
    }

    public static ContextAwareAction customPopupActions() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(Project p) {
                CustomPopupActions customPopupActions;
                ActionProviderImpl ap = (ActionProviderImpl)p.getLookup().lookup(ActionProviderImpl.class);
                if (ap != null) {
                    ActionProviderImpl actionProviderImpl = ap;
                    actionProviderImpl.getClass();
                    customPopupActions = actionProviderImpl.new CustomPopupActions();
                } else {
                    customPopupActions = null;
                }
                return customPopupActions;
            }
        };
    }

    public static ContextAwareAction closeSubprojectsAction() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(Project p) {
                NbMavenProjectImpl project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
                if (project != null && "pom".equalsIgnoreCase(project.getProjectWatcher().getPackagingType())) {
                    return new CloseSubprojectsAction(project);
                }
                return null;
            }
        };
    }

    public static ContextAwareAction showProblemsAction() {
        return new ConditionallyShownAction(){

            @Override
            protected Action forProject(Project p) {
                ProblemReporterImpl reporter = (ProblemReporterImpl)p.getLookup().lookup(ProblemReporterImpl.class);
                return reporter != null && !reporter.getReports().isEmpty() ? new ShowProblemsAction(reporter) : null;
            }
        };
    }

    public static ContextAwareAction buildWithDependenciesAction() {
        return (ContextAwareAction)ProjectSensitiveActions.projectCommandAction((String)BUILD_WITH_DEPENDENCIES, (String)Bundle.ACT_Build_Deps(), null);
    }

    private static class CloseSubprojectsAction
    extends AbstractAction {
        private final NbMavenProjectImpl project;

        public CloseSubprojectsAction(NbMavenProjectImpl project) {
            this.project = project;
            this.putValue("Name", Bundle.ACT_CloseRequired());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubprojectProvider subs = (SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class);
            Set lst = subs.getSubprojects();
            Project[] arr = lst.toArray(new Project[lst.size()]);
            OpenProjects.getDefault().close(arr);
        }
    }

    private static abstract class ConditionallyShownAction
    extends AbstractAction
    implements ContextAwareAction {
        protected ConditionallyShownAction() {
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            assert (false);
        }

        protected abstract Action forProject(Project var1);

        public final Action createContextAwareInstance(Lookup actionContext) {
            Collection projects = actionContext.lookupAll(Project.class);
            if (projects.size() != 1) {
                return this;
            }
            Action a = this.forProject((Project)projects.iterator().next());
            return a != null ? a : this;
        }
    }

    private final class CustomAction
    extends AbstractAction {
        private NetbeansActionMapping mapping;
        private boolean showUI;

        private CustomAction(String name, NetbeansActionMapping mapp, boolean showUI) {
            this.mapping = mapp;
            this.putValue("Name", name);
            this.showUI = showUI;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Map<String, String> replacements = ActionProviderImpl.replacements(ActionProviderImpl.this.proj, (String)this.getValue("Name"), Lookup.EMPTY);
            for (Map.Entry<String, String> entry : this.mapping.getProperties().entrySet()) {
                entry.setValue(AbstractMavenActionsProvider.dynamicSubstitutions(replacements, entry.getValue()));
            }
            if (!this.showUI) {
                M2ConfigProvider conf = (M2ConfigProvider)ActionProviderImpl.this.proj.getLookup().lookup(M2ConfigProvider.class);
                ModelRunConfig rc = this.createCustomRunConfig(conf);
                RunUtils.run(rc);
                return;
            }
            RunGoalsPanel pnl = new RunGoalsPanel();
            DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.TIT_Run_Maven());
            ActionToGoalMapping maps = ActionToGoalUtils.readMappingsFromFileAttributes(ActionProviderImpl.this.proj.getProjectDirectory());
            pnl.readMapping(this.mapping, (NbMavenProjectImpl)ActionProviderImpl.this.proj.getLookup().lookup(NbMavenProjectImpl.class), maps);
            pnl.setShowDebug(MavenSettings.getDefault().isShowDebug());
            pnl.setOffline(MavenSettings.getDefault().isOffline() != null ? MavenSettings.getDefault().isOffline() : false);
            pnl.setRecursive(true);
            Object retValue = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (retValue == DialogDescriptor.OK_OPTION) {
                pnl.applyValues(this.mapping);
                if (maps.getActions().size() > 10) {
                    maps.getActions().remove(0);
                }
                maps.getActions().add(this.mapping);
                M2ConfigProvider conf = (M2ConfigProvider)ActionProviderImpl.this.proj.getLookup().lookup(M2ConfigProvider.class);
                ActionToGoalUtils.writeMappingsToFileAttributes(ActionProviderImpl.this.proj.getProjectDirectory(), maps);
                if (pnl.isRememberedAs() != null) {
                    try {
                        String tit = "CUSTOM-" + pnl.isRememberedAs();
                        this.mapping.setActionName(tit);
                        this.mapping.setDisplayName(pnl.isRememberedAs());
                        ModelHandle2.putMapping(this.mapping, ActionProviderImpl.this.proj, conf.getDefaultConfig());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                ModelRunConfig rc = this.createCustomRunConfig(conf);
                rc.setOffline(pnl.isOffline());
                rc.setShowDebug(pnl.isShowDebug());
                rc.setRecursive(pnl.isRecursive());
                rc.setUpdateSnapshots(pnl.isUpdateSnapshots());
                ActionProviderImpl.this.setupTaskName("custom", rc, Lookup.EMPTY);
                RunUtils.run(rc);
            }
        }

        private ModelRunConfig createCustomRunConfig(M2ConfigProvider conf) {
            ModelRunConfig rc = new ModelRunConfig(ActionProviderImpl.this.proj, this.mapping, this.mapping.getActionName(), null, Lookup.EMPTY);
            ArrayList<String> acts = new ArrayList<String>();
            acts.addAll(rc.getActivatedProfiles());
            acts.addAll(conf.getActiveConfiguration().getActivatedProfiles());
            rc.setActivatedProfiles(acts);
            HashMap<String, String> props = new HashMap<String, String>(rc.getProperties());
            props.putAll(conf.getActiveConfiguration().getProperties());
            rc.addProperties(props);
            rc.setTaskDisplayName(Bundle.TXT_Build(((NbMavenProject)ActionProviderImpl.this.proj.getLookup().lookup(NbMavenProject.class)).getMavenProject().getArtifactId()));
            return rc;
        }
    }

    private final class CustomPopupActions
    extends AbstractAction
    implements Presenter.Popup {
        private CustomPopupActions() {
            this.putValue("Name", Bundle.LBL_Custom_Run());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            final JMenu menu = new JMenu(Bundle.LBL_Custom_Run());
            final JMenuItem loading = new JMenuItem(Bundle.LBL_Loading());
            menu.add(loading);
            ActionProviderImpl.this.RP.post(new Runnable(){

                @Override
                public void run() {
                    NetbeansActionMapping[] maps = ActionToGoalUtils.getActiveCustomMappings((NbMavenProjectImpl)ActionProviderImpl.this.proj.getLookup().lookup(NbMavenProjectImpl.class));
                    for (int i = 0; i < maps.length; ++i) {
                        NetbeansActionMapping mapp = maps[i];
                        Action act = ActionProviderImpl.this.createCustomMavenAction(mapp.getActionName(), mapp, false);
                        JMenuItem item = new JMenuItem(act);
                        item.setText(mapp.getDisplayName() == null ? mapp.getActionName() : mapp.getDisplayName());
                        menu.add(item);
                    }
                    menu.add(new JMenuItem(ActionProviderImpl.this.createCustomMavenAction(Bundle.LBL_Custom_run_goals(), new NetbeansActionMapping(), true)));
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            boolean selected = menu.isSelected();
                            menu.remove(loading);
                            menu.getPopupMenu().pack();
                            menu.repaint();
                            menu.updateUI();
                            menu.setSelected(selected);
                        }
                    });
                }
            }, 100);
            return menu;
        }
    }

    private static class ShowProblemsAction
    extends AbstractAction {
        private final ProblemReporterImpl reporter;

        ShowProblemsAction(ProblemReporterImpl reporter) {
            this.reporter = reporter;
            this.putValue("Name", Bundle.ACT_ShowProblems());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JButton butt = new JButton();
            ProblemsPanel panel = new ProblemsPanel(this.reporter);
            panel.setActionButton(butt);
            JButton close = new JButton();
            panel.setCloseButton(close);
            close.setText(Bundle.BTN_Close());
            DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.TIT_Show_Problems());
            dd.setOptions(new Object[]{butt, close});
            dd.setClosingOptions(new Object[]{butt, close});
            dd.setModal(false);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        }
    }
}

