/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.dfa;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlowNode
implements IDataFlowNode {
    private SimpleNode node;
    private Map<Integer, String> typeMap = new HashMap<Integer, String>();
    protected List<DataFlowNode> parents = new ArrayList<DataFlowNode>();
    protected List<DataFlowNode> children = new ArrayList<DataFlowNode>();
    protected BitSet type = new BitSet();
    protected List<VariableAccess> variableAccess = new ArrayList<VariableAccess>();
    protected LinkedList<DataFlowNode> dataFlow;
    protected int line;

    protected DataFlowNode() {
    }

    public DataFlowNode(SimpleNode node, LinkedList<DataFlowNode> dataFlow) {
        this.dataFlow = dataFlow;
        this.node = node;
        node.setDataFlowNode(this);
        this.line = node.getBeginLine();
        if (!this.dataFlow.isEmpty()) {
            DataFlowNode parent = this.dataFlow.getLast();
            parent.addPathToChild(this);
        }
        this.dataFlow.addLast(this);
    }

    @Override
    public void addPathToChild(IDataFlowNode child) {
        DataFlowNode thisChild = (DataFlowNode)child;
        if (!this.children.contains(thisChild) || this.equals(thisChild)) {
            this.children.add(thisChild);
            thisChild.parents.add(this);
        }
    }

    @Override
    public boolean removePathToChild(IDataFlowNode child) {
        DataFlowNode thisChild = (DataFlowNode)child;
        thisChild.parents.remove(this);
        return this.children.remove(thisChild);
    }

    @Override
    public void reverseParentPathsTo(IDataFlowNode destination) {
        while (!this.parents.isEmpty()) {
            DataFlowNode parent = this.parents.get(0);
            parent.removePathToChild(this);
            parent.addPathToChild(destination);
        }
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setType(int type) {
        this.type.set(type);
    }

    @Override
    public boolean isType(int intype) {
        try {
            return this.type.get(intype);
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public SimpleNode getSimpleNode() {
        return this.node;
    }

    public List<DataFlowNode> getChildren() {
        return this.children;
    }

    public List<DataFlowNode> getParents() {
        return this.parents;
    }

    public List<DataFlowNode> getFlow() {
        return this.dataFlow;
    }

    @Override
    public int getIndex() {
        return this.dataFlow.indexOf(this);
    }

    @Override
    public void setVariableAccess(List<VariableAccess> variableAccess) {
        if (this.variableAccess.isEmpty()) {
            this.variableAccess = variableAccess;
        } else {
            this.variableAccess.addAll(variableAccess);
        }
    }

    @Override
    public List<VariableAccess> getVariableAccess() {
        return this.variableAccess;
    }

    public String toString() {
        String res = "DataFlowNode: line " + this.getLine() + ", ";
        if (this.node instanceof ASTMethodDeclaration || this.node instanceof ASTConstructorDeclaration) {
            res = res + (this.node instanceof ASTMethodDeclaration ? "(method)" : "(constructor)");
        } else {
            String tmp = this.type.toString();
            String newTmp = "";
            for (char c : tmp.toCharArray()) {
                if (c == '{' || c == '}' || c == ' ') continue;
                newTmp = newTmp + c;
            }
            StringTokenizer st = new StringTokenizer(newTmp, ",");
            while (st.hasMoreTokens()) {
                int newTmpInt = Integer.parseInt(st.nextToken());
                res = res + "(" + this.stringFromType(newTmpInt) + ")";
            }
            res = res + ", " + this.node.getClass().getName().substring(this.node.getClass().getName().lastIndexOf(46) + 1);
            res = res + (this.node.getImage() == null ? "" : "(" + this.node.getImage() + ")");
        }
        return res;
    }

    private String stringFromType(int intype) {
        if (this.typeMap.isEmpty()) {
            this.typeMap.put(1, "IF_EXPR");
            this.typeMap.put(2, "IF_LAST_STATEMENT");
            this.typeMap.put(3, "IF_LAST_STATEMENT_WITHOUT_ELSE");
            this.typeMap.put(4, "ELSE_LAST_STATEMENT");
            this.typeMap.put(11, "WHILE_LAST_STATEMENT");
            this.typeMap.put(10, "WHILE_EXPR");
            this.typeMap.put(20, "SWITCH_START");
            this.typeMap.put(21, "CASE_LAST_STATEMENT");
            this.typeMap.put(22, "SWITCH_LAST_DEFAULT_STATEMENT");
            this.typeMap.put(23, "SWITCH_END");
            this.typeMap.put(30, "FOR_INIT");
            this.typeMap.put(31, "FOR_EXPR");
            this.typeMap.put(32, "FOR_UPDATE");
            this.typeMap.put(33, "FOR_BEFORE_FIRST_STATEMENT");
            this.typeMap.put(34, "FOR_END");
            this.typeMap.put(40, "DO_BEFORE_FIRST_STATEMENT");
            this.typeMap.put(41, "DO_EXPR");
            this.typeMap.put(50, "RETURN_STATEMENT");
            this.typeMap.put(51, "BREAK_STATEMENT");
            this.typeMap.put(52, "CONTINUE_STATEMENT");
            this.typeMap.put(60, "LABEL_STATEMENT");
            this.typeMap.put(61, "LABEL_END");
            this.typeMap.put(70, "THROW_STATEMENT");
        }
        if (!this.typeMap.containsKey(intype)) {
            throw new RuntimeException("Couldn't find type id " + intype);
        }
        return this.typeMap.get(intype);
    }
}

