/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PMD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceCode {
    private CodeLoader cl;

    public SourceCode(CodeLoader cl) {
        this.cl = cl;
    }

    public List<String> getCode() {
        return this.cl.getCode();
    }

    public StringBuffer getCodeBuffer() {
        StringBuffer sb = new StringBuffer();
        List<String> lines = this.cl.getCode();
        for (String line : lines) {
            sb.append(line);
            sb.append(PMD.EOL);
        }
        return sb;
    }

    public String getSlice(int startLine, int endLine) {
        int i;
        StringBuffer sb = new StringBuffer();
        List<String> lines = this.cl.getCode();
        int n = i = startLine == 0 ? startLine : startLine - 1;
        while (i < endLine && i < lines.size()) {
            if (sb.length() != 0) {
                sb.append(PMD.EOL);
            }
            sb.append(lines.get(i));
            ++i;
        }
        return sb.toString();
    }

    public String getFileName() {
        return this.cl.getFileName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CodeLoader {
        private SoftReference<List<String>> code;

        public List<String> getCode() {
            List<String> c = null;
            if (this.code != null) {
                c = this.code.get();
            }
            if (c != null) {
                return c;
            }
            this.code = new SoftReference<List<String>>(this.load());
            return this.code.get();
        }

        public abstract String getFileName();

        protected abstract Reader getReader() throws Exception;

        protected List<String> load() {
            LineNumberReader lnr = null;
            try {
                String currentLine;
                lnr = new LineNumberReader(this.getReader());
                ArrayList<String> lines = new ArrayList<String>();
                while ((currentLine = lnr.readLine()) != null) {
                    lines.add(currentLine);
                }
                ArrayList<String> arrayList = lines;
                return arrayList;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e.getMessage());
            }
            finally {
                try {
                    if (lnr != null) {
                        lnr.close();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem while reading " + this.getFileName() + ":" + e.getMessage());
                }
            }
        }
    }

    public static class FileCodeLoader
    extends CodeLoader {
        private File file;
        private String encoding;

        public FileCodeLoader(File file, String encoding) {
            this.file = file;
            this.encoding = encoding;
        }

        public Reader getReader() throws Exception {
            return new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding);
        }

        public String getFileName() {
            return this.file.getAbsolutePath();
        }
    }

    public static class StringCodeLoader
    extends CodeLoader {
        public static final String DEFAULT_NAME = "CODE_LOADED_FROM_STRING";
        private String source_code;
        private String name;

        public StringCodeLoader(String code) {
            this(code, DEFAULT_NAME);
        }

        public StringCodeLoader(String code, String name) {
            this.source_code = code;
            this.name = name;
        }

        public Reader getReader() {
            return new StringReader(this.source_code);
        }

        public String getFileName() {
            return this.name;
        }
    }
}

