/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.DiscoveredExternalAnnotatedType;
import org.jboss.weld.introspector.ExternalAnnotatedType;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.TypeClosureLazyValueHolder;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.AbstractWeldAnnotated;
import org.jboss.weld.introspector.jlr.WeldConstructorImpl;
import org.jboss.weld.introspector.jlr.WeldFieldImpl;
import org.jboss.weld.introspector.jlr.WeldMethodImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.SharedObjectFacade;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldClassImpl<T>
extends AbstractWeldAnnotated<T, Class<T>>
implements WeldClass<T> {
    private final WeldClass<? super T> superclass;
    private final Set<WeldField<?, ?>> fields;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldField<?, ?>> annotatedFields;
    private final ArraySet<WeldField<?, ?>> declaredFields;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldField<?, ? super T>> declaredAnnotatedFields;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldField<?, ?>> declaredMetaAnnotatedFields;
    private final Set<WeldMethod<?, ? super T>> methods;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldMethod<?, ?>> annotatedMethods;
    private final ArraySet<WeldMethod<?, ? super T>> declaredMethods;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldMethod<?, ? super T>> declaredAnnotatedMethods;
    private final ArrayListMultimap<Class<? extends Annotation>, WeldMethod<?, ? super T>> declaredMethodsByAnnotatedParameters;
    private final ArraySet<WeldConstructor<T>> constructors;
    private final Map<ConstructorSignature, WeldConstructor<?>> declaredConstructorsBySignature;
    private final ArraySetMultimap<Class<? extends Annotation>, Annotation> declaredMetaAnnotationMap;
    private final boolean discovered;

    public static <T> WeldClass<T> of(Class<T> clazz, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(clazz, clazz, null, new TypeClosureLazyValueHolder(clazz), WeldClassImpl.buildAnnotationMap(clazz.getAnnotations()), WeldClassImpl.buildAnnotationMap(clazz.getDeclaredAnnotations()), classTransformer);
    }

    public static <T> WeldClass<T> of(AnnotatedType<T> annotatedType, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(annotatedType.getJavaClass(), annotatedType.getBaseType(), annotatedType, new TypeClosureLazyValueHolder(annotatedType.getTypeClosure()), WeldClassImpl.buildAnnotationMap(annotatedType.getAnnotations()), WeldClassImpl.buildAnnotationMap(annotatedType.getAnnotations()), classTransformer);
    }

    public static <T> WeldClass<T> of(Class<T> rawType, Type type, ClassTransformer classTransformer) {
        return new WeldClassImpl<T>(rawType, type, null, new TypeClosureLazyValueHolder(type), WeldClassImpl.buildAnnotationMap(rawType.getAnnotations()), WeldClassImpl.buildAnnotationMap(rawType.getDeclaredAnnotations()), classTransformer);
    }

    protected WeldClassImpl(Class<T> rawType, Type type, AnnotatedType<T> annotatedType, LazyValueHolder<Set<Type>> typeClosure, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        super(annotationMap, declaredAnnotationMap, classTransformer, rawType, type, typeClosure);
        boolean modified;
        if (annotatedType instanceof DiscoveredExternalAnnotatedType) {
            this.discovered = true;
            modified = ((DiscoveredExternalAnnotatedType)DiscoveredExternalAnnotatedType.class.cast(annotatedType)).isModifed();
        } else if (annotatedType instanceof ExternalAnnotatedType) {
            this.discovered = false;
            modified = false;
        } else {
            this.discovered = true;
            modified = false;
        }
        this.superclass = modified ? classTransformer.loadClass(Object.class) : (rawType.getSuperclass() != null ? classTransformer.loadClass(rawType.getSuperclass()) : null);
        this.declaredAnnotatedFields = ArrayListMultimap.create();
        this.declaredMetaAnnotatedFields = ArrayListMultimap.create();
        Set<WeldField<Object, Object>> fieldsTemp = null;
        ArrayList declaredFieldsTemp = new ArrayList();
        if (annotatedType == null) {
            this.annotatedFields = null;
            if (rawType != Object.class) {
                for (Field field : SecureReflections.getDeclaredFields(rawType)) {
                    WeldFieldImpl annotatedField = WeldFieldImpl.of(field, this.getDeclaringWeldClass(field, classTransformer), classTransformer);
                    declaredFieldsTemp.add(annotatedField);
                    for (Annotation annotation : annotatedField.getAnnotations()) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), (Object)annotatedField);
                        for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                            this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), (Object)annotatedField);
                        }
                    }
                }
                fieldsTemp = new ArraySet(declaredFieldsTemp).trimToSize();
                if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                    fieldsTemp = Sets.union(fieldsTemp, (Set)Reflections.cast(this.superclass.getFields()));
                }
            }
            this.declaredFields = new ArraySet(declaredFieldsTemp);
        } else {
            this.annotatedFields = ArrayListMultimap.create();
            fieldsTemp = new HashSet();
            for (AnnotatedField<T> annotatedField : annotatedType.getFields()) {
                WeldFieldImpl<?, T> weldField = WeldFieldImpl.of(annotatedField, this, classTransformer);
                fieldsTemp.add(weldField);
                if (annotatedField.getDeclaringType().getJavaClass() == rawType) {
                    declaredFieldsTemp.add(weldField);
                }
                for (Annotation annotation : weldField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), weldField);
                    if (annotatedField.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredAnnotatedFields.put(annotation.annotationType(), weldField);
                    for (Annotation metaAnnotation : annotation.annotationType().getAnnotations()) {
                        this.declaredMetaAnnotatedFields.put(metaAnnotation.annotationType(), weldField);
                    }
                }
            }
            this.declaredFields = new ArraySet(declaredFieldsTemp);
            fieldsTemp = new ArraySet(fieldsTemp).trimToSize();
            this.annotatedFields.trimToSize();
        }
        this.fields = fieldsTemp;
        this.declaredFields.trimToSize();
        this.declaredAnnotatedFields.trimToSize();
        this.declaredMetaAnnotatedFields.trimToSize();
        this.constructors = new ArraySet();
        this.declaredConstructorsBySignature = new HashMap();
        if (annotatedType == null) {
            for (AccessibleObject accessibleObject : SecureReflections.getDeclaredConstructors(rawType)) {
                Constructor c = (Constructor)Reflections.cast(accessibleObject);
                WeldConstructor annotatedConstructor = WeldConstructorImpl.of(c, this.getDeclaringWeldClass(c, classTransformer), classTransformer);
                this.constructors.add(annotatedConstructor);
                this.declaredConstructorsBySignature.put(annotatedConstructor.getSignature(), annotatedConstructor);
            }
        } else {
            for (AnnotatedConstructor annotatedConstructor : annotatedType.getConstructors()) {
                WeldConstructor weldConstructor = WeldConstructorImpl.of(annotatedConstructor, this, classTransformer);
                this.constructors.add(weldConstructor);
                ArrayList arrayList = new ArrayList();
                for (AnnotatedParameter parameter : annotatedConstructor.getParameters()) {
                    arrayList.add(Reflections.getRawType(parameter.getBaseType()));
                }
                this.declaredConstructorsBySignature.put(weldConstructor.getSignature(), weldConstructor);
            }
        }
        this.constructors.trimToSize();
        this.declaredAnnotatedMethods = ArrayListMultimap.create();
        this.declaredMethodsByAnnotatedParameters = ArrayListMultimap.create();
        Set<WeldMethod<Object, Object>> methodsTemp = null;
        ArrayList arrayList = new ArrayList();
        if (annotatedType == null) {
            this.annotatedMethods = null;
            if (rawType != Object.class) {
                for (Method method : SecureReflections.getDeclaredMethods(rawType)) {
                    WeldMethodImpl weldMethod = WeldMethodImpl.of(method, this.getDeclaringWeldClass(method, classTransformer), classTransformer);
                    arrayList.add(weldMethod);
                    for (Annotation annotation : weldMethod.getAnnotations()) {
                        this.declaredAnnotatedMethods.put(annotation.annotationType(), (Object)weldMethod);
                    }
                    for (Class annotationType : WeldMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                        if (weldMethod.getWeldParameters(annotationType).size() <= 0) continue;
                        this.declaredMethodsByAnnotatedParameters.put((Object)annotationType, weldMethod);
                    }
                }
                methodsTemp = new ArraySet(arrayList).trimToSize();
                if (this.superclass != null) {
                    WeldClass<T> current = this.superclass;
                    while (current.getJavaClass() != Object.class) {
                        Set set = (Set)Reflections.cast(current.getDeclaredWeldMethods());
                        methodsTemp = Sets.union(methodsTemp, set);
                        current = current.getWeldSuperclass();
                    }
                }
            }
            this.declaredMethods = new ArraySet(arrayList);
        } else {
            this.annotatedMethods = ArrayListMultimap.create();
            methodsTemp = new HashSet();
            for (AnnotatedMethod<T> annotatedMethod : annotatedType.getMethods()) {
                WeldMethodImpl weldMethod = WeldMethodImpl.of(annotatedMethod, this, classTransformer);
                methodsTemp.add(weldMethod);
                if (annotatedMethod.getDeclaringType().getJavaClass() == rawType) {
                    arrayList.add(weldMethod);
                }
                for (Annotation annotation : weldMethod.getAnnotations()) {
                    this.annotatedMethods.put(annotation.annotationType(), (Object)weldMethod);
                    if (annotatedMethod.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredAnnotatedMethods.put(annotation.annotationType(), (Object)weldMethod);
                }
                for (Class annotationType : WeldMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (weldMethod.getWeldParameters(annotationType).size() <= 0 || annotatedMethod.getDeclaringType().getJavaClass() != rawType) continue;
                    this.declaredMethodsByAnnotatedParameters.put((Object)annotationType, weldMethod);
                }
            }
            this.declaredMethods = new ArraySet(arrayList);
            methodsTemp = new ArraySet(methodsTemp).trimToSize();
            this.annotatedMethods.trimToSize();
        }
        this.methods = methodsTemp;
        this.declaredMethods.trimToSize();
        this.declaredAnnotatedMethods.trimToSize();
        this.declaredMethodsByAnnotatedParameters.trimToSize();
        ArraySetMultimap<Class<? extends Annotation>, Annotation> declaredMetaAnnotationMap = new ArraySetMultimap<Class<? extends Annotation>, Annotation>();
        for (Annotation declaredAnnotation : declaredAnnotationMap.values()) {
            WeldClassImpl.addMetaAnnotations(declaredMetaAnnotationMap, declaredAnnotation, declaredAnnotation.annotationType().getAnnotations(), true);
            WeldClassImpl.addMetaAnnotations(declaredMetaAnnotationMap, declaredAnnotation, classTransformer.getTypeStore().get(declaredAnnotation.annotationType()), true);
            declaredMetaAnnotationMap.putSingleElement(declaredAnnotation.annotationType(), declaredAnnotation);
        }
        declaredMetaAnnotationMap.trimToSize();
        this.declaredMetaAnnotationMap = SharedObjectFacade.wrap(declaredMetaAnnotationMap);
    }

    private <X> WeldClass<X> getDeclaringWeldClass(Member member, ClassTransformer transformer) {
        if (member.getDeclaringClass().equals(this.getJavaClass())) {
            return (WeldClass)this.cast(this);
        }
        return transformer.loadClass((Class)Reflections.cast(member.getDeclaringClass()));
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getJavaClass();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getJavaClass();
    }

    @Override
    public Collection<WeldField<?, ?>> getWeldFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public Collection<WeldField<?, ?>> getDeclaredFields() {
        return Collections.unmodifiableCollection(this.declaredFields);
    }

    @Override
    public <F> WeldField<F, ?> getDeclaredWeldField(String fieldName) {
        for (WeldField<?, ?> field : this.declaredFields) {
            if (!field.getName().equals(fieldName)) continue;
            return (WeldField)this.cast(field);
        }
        return null;
    }

    @Override
    public Collection<WeldField<?, ? super T>> getDeclaredWeldFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public WeldConstructor<T> getDeclaredWeldConstructor(ConstructorSignature signature) {
        return (WeldConstructor)this.cast(this.declaredConstructorsBySignature.get(signature));
    }

    @Override
    public Collection<WeldField<?, ?>> getWeldFields(Class<? extends Annotation> annotationType) {
        if (this.annotatedFields == null) {
            ArrayList aggregatedFields = new ArrayList(this.declaredAnnotatedFields.get(annotationType));
            if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                aggregatedFields.addAll(this.superclass.getWeldFields(annotationType));
            }
            return Collections.unmodifiableCollection(aggregatedFields);
        }
        return Collections.unmodifiableCollection(this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isLocalClass() {
        return this.getJavaClass().isLocalClass();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.getJavaClass().isAnonymousClass();
    }

    @Override
    public boolean isMemberClass() {
        return this.getJavaClass().isMemberClass();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isEnum() {
        return this.getJavaClass().isEnum();
    }

    @Override
    public boolean isSerializable() {
        return Reflections.isSerializable(this.getJavaClass());
    }

    @Override
    public Collection<WeldMethod<?, ?>> getWeldMethods(Class<? extends Annotation> annotationType) {
        if (this.annotatedMethods == null) {
            ArrayList aggregateMethods = new ArrayList(this.declaredAnnotatedMethods.get(annotationType));
            if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                aggregateMethods.addAll(this.superclass.getDeclaredWeldMethods(annotationType));
            }
            return Collections.unmodifiableCollection(aggregateMethods);
        }
        return Collections.unmodifiableCollection(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getDeclaredWeldMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Collection<WeldConstructor<T>> getWeldConstructors(Class<? extends Annotation> annotationType) {
        HashSet<WeldConstructor<T>> ret = new HashSet<WeldConstructor<T>>();
        for (WeldConstructor<T> constructor : this.constructors) {
            if (!constructor.isAnnotationPresent(annotationType)) continue;
            ret.add(constructor);
        }
        return ret;
    }

    @Override
    public WeldConstructor<T> getNoArgsWeldConstructor() {
        for (WeldConstructor<T> constructor : this.constructors) {
            if (((Constructor)constructor.getJavaMember()).getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getDeclaredWeldMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public WeldMethod<?, ?> getWeldMethod(Method methodDescriptor) {
        for (WeldMethod<?, T> annotatedMethod : this.getWeldMethods()) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getWeldMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public WeldMethod<?, ?> getDeclaredWeldMethod(Method method) {
        for (WeldMethod<?, T> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Collection<WeldMethod<?, ? super T>> getDeclaredWeldMethods() {
        return Collections.unmodifiableSet(this.declaredMethods);
    }

    @Override
    public <M> WeldMethod<M, ?> getDeclaredWeldMethod(MethodSignature signature) {
        for (WeldMethod<?, T> method : this.declaredMethods) {
            if (!method.getSignature().equals(signature)) continue;
            return (WeldMethod)this.cast(method);
        }
        return null;
    }

    @Override
    public <M> WeldMethod<M, ?> getWeldMethod(MethodSignature signature) {
        WeldMethod method = (WeldMethod)this.cast(this.getDeclaredWeldMethod(signature));
        if (method == null && this.superclass != null && this.superclass.getJavaClass() != Object.class) {
            method = this.superclass.getWeldMethod(signature);
        }
        return method;
    }

    public String toString() {
        return Formats.formatModifiers(this.getJavaClass().getModifiers()) + Formats.formatAnnotations(this.getAnnotations()) + " class " + this.getName() + Formats.formatActualTypeArguments(this.getActualTypeArguments());
    }

    @Override
    public String getSimpleName() {
        return this.getJavaClass().getSimpleName();
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic(this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal(this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isFinal(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isGeneric() {
        return this.getJavaClass().getTypeParameters().length > 0;
    }

    @Override
    public String getName() {
        return this.getJavaClass().getName();
    }

    @Override
    public WeldClass<? super T> getWeldSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return this.getDelegate().equals(clazz);
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isPackagePrivate() {
        return Reflections.isPackagePrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public Package getPackage() {
        return this.getJavaClass().getPackage();
    }

    @Override
    public <U> WeldClass<? extends U> asWeldSubclass(WeldClass<U> clazz) {
        return (WeldClass)this.cast(this);
    }

    @Override
    public <S> S cast(Object object) {
        return (S)Reflections.cast(object);
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return Collections.unmodifiableSet((Set)Reflections.cast(this.constructors));
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return (Set)this.cast(this.fields);
    }

    @Override
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return (Set)this.cast(this.methods);
    }

    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(new ArraySet(this.declaredMetaAnnotationMap.get(metaAnnotationType)));
    }

    @Override
    public boolean isDiscovered() {
        return this.discovered;
    }
}

