/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.bridge.impl;

import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.module.AntModule;
import org.apache.tools.ant.module.AntSettings;
import org.apache.tools.ant.module.api.IntrospectedInfo;
import org.apache.tools.ant.module.bridge.AntBridge;
import org.apache.tools.ant.module.bridge.BridgeInterface;
import org.apache.tools.ant.module.bridge.IntrospectionHelperProxy;
import org.apache.tools.ant.module.bridge.impl.ForkedJavaOverride;
import org.apache.tools.ant.module.bridge.impl.InputOverride;
import org.apache.tools.ant.module.bridge.impl.IntrospectionHelperImpl;
import org.apache.tools.ant.module.bridge.impl.NbAntlib;
import org.apache.tools.ant.module.bridge.impl.NbBuildLogger;
import org.apache.tools.ant.module.bridge.impl.NbInputHandler;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class BridgeImpl
implements BridgeInterface {
    private static final Logger LOG = Logger.getLogger(BridgeImpl.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(BridgeImpl.class);
    private static final int STOP_TIMEOUT = 10000;
    private static boolean classpathInitialized = false;
    private static final Map<Thread, NbBuildLogger> loggersByThread = new WeakHashMap<Thread, NbBuildLogger>();
    private static final RequestProcessor.Task refreshFilesystemsTask = RP.create(new Runnable(){

        @Override
        public void run() {
            LOG.log(Level.FINE, "Refreshing filesystems");
            FileUtil.refreshAll();
        }
    });
    private static boolean doGutProject = !Boolean.getBoolean("org.apache.tools.ant.module.bridge.impl.BridgeImpl.doNotGutProject");

    public String getAntVersion() {
        try {
            return Main.getAntVersion();
        }
        catch (BuildException be) {
            AntModule.err.notify(1, (Throwable)be);
            return NbBundle.getMessage(BridgeImpl.class, (String)"LBL_ant_version_unknown");
        }
    }

    public boolean isAnt16() {
        try {
            Class.forName("org.apache.tools.ant.taskdefs.Antlib");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public IntrospectionHelperProxy getIntrospectionHelper(Class<?> clazz) {
        return new IntrospectionHelperImpl(clazz);
    }

    public boolean toBoolean(String val) {
        return Project.toBoolean((String)val);
    }

    public String[] getEnumeratedValues(Class<?> c) {
        if (EnumeratedAttribute.class.isAssignableFrom(c)) {
            try {
                return ((EnumeratedAttribute)c.newInstance()).getValues();
            }
            catch (Exception e) {
                AntModule.err.notify(1, (Throwable)e);
            }
        } else if (Enum.class.isAssignableFrom(c)) {
            try {
                Enum[] vals = (Enum[])c.getMethod("values", new Class[0]).invoke(null, new Object[0]);
                String[] names = new String[vals.length];
                for (int i = 0; i < vals.length; ++i) {
                    names[i] = vals[i].name();
                }
                return names;
            }
            catch (Exception x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(File buildFile, List<String> targets, InputStream in, OutputWriter out, OutputWriter err, Map<String, String> properties, int verbosity, String displayName, Runnable interestingOutputCallback, ProgressHandle handle, InputOutput io) {
        if (!classpathInitialized) {
            classpathInitialized = true;
            Path.systemClasspath = new Path(null, AntBridge.getMainClassPath());
        }
        boolean ok = false;
        boolean ant16 = this.isAnt16();
        ClassLoader oldCCL = Thread.currentThread().getContextClassLoader();
        ClassLoader newCCL = Project.class.getClassLoader();
        LOG.log(Level.FINER, "Fixing CCL: {0} -> {1}", new Object[]{oldCCL, newCCL});
        Thread.currentThread().setContextClassLoader(newCCL);
        AntBridge.fakeJavaClassPath();
        try {
            Object c2;
            Vector<String> targs;
            Project project;
            NbBuildLogger logger = new NbBuildLogger(buildFile, out, err, verbosity, displayName, properties, interestingOutputCallback, handle, io);
            try {
                project = new Project();
                project.addBuildListener((BuildListener)logger);
                project.init();
                project.addTaskDefinition("java", ForkedJavaOverride.class);
                project.addTaskDefinition("input", InputOverride.class);
                try {
                    BridgeImpl.addCustomDefs(project);
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
                project.setUserProperty("ant.file", buildFile.getAbsolutePath());
                project.setUserProperty("ant.version", Main.getAntVersion());
                File antHome = AntSettings.getAntHome();
                if (antHome != null) {
                    project.setUserProperty("ant.home", antHome.getAbsolutePath());
                }
                String ENABLE_TESTLISTENER_EVENTS = "ant.junit.enabletestlistenerevents";
                project.setProperty(ENABLE_TESTLISTENER_EVENTS, "true");
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    project.setUserProperty(entry.getKey(), entry.getValue());
                }
                if (in != null && ant16) {
                    try {
                        Method m = Project.class.getMethod("setDefaultInputStream", InputStream.class);
                        m.invoke((Object)project, in);
                    }
                    catch (Exception e) {
                        AntModule.err.notify(1, (Throwable)e);
                    }
                }
                LOG.log(Level.FINER, "CCL when configureProject is called: {0}", Thread.currentThread().getContextClassLoader());
                ProjectHelper projhelper = ProjectHelper.getProjectHelper();
                project.addReference("ant.projectHelper", (Object)projhelper);
                projhelper.parse(project, (Object)buildFile);
                project.setInputHandler((InputHandler)new NbInputHandler(interestingOutputCallback));
                if (targets != null) {
                    targs = new Vector<String>(targets);
                } else {
                    targs = new Vector(1);
                    targs.add(project.getDefaultTarget());
                }
                logger.setActualTargets(targets != null ? targets.toArray(new String[targets.size()]) : null);
            }
            catch (BuildException be) {
                logger.buildInitializationFailed(be);
                logger.shutdown();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        AntModule.err.notify((Throwable)e);
                    }
                }
                boolean e = false;
                AntBridge.unfakeJavaClassPath();
                LOG.log(Level.FINER, "Restoring CCL: {0}", oldCCL);
                Thread.currentThread().setContextClassLoader(oldCCL);
                return e;
            }
            project.fireBuildStarted();
            InputStream is = System.in;
            if (in != null && ant16) {
                try {
                    Class<InputStream> dis = Class.forName("org.apache.tools.ant.DemuxInputStream").asSubclass(InputStream.class);
                    c2 = dis.getConstructor(Project.class);
                    is = ((Constructor)c2).newInstance(project);
                }
                catch (Exception e) {
                    AntModule.err.notify(1, (Throwable)e);
                }
            }
            AntBridge.pushSystemInOutErr((InputStream)is, (PrintStream)new PrintStream((OutputStream)new DemuxOutputStream(project, false)), (PrintStream)new PrintStream((OutputStream)new DemuxOutputStream(project, true)));
            Thread currentThread = Thread.currentThread();
            c2 = loggersByThread;
            synchronized (c2) {
                assert (!loggersByThread.containsKey(currentThread));
                loggersByThread.put(currentThread, logger);
            }
            try {
                if (Thread.interrupted()) {
                    logger.shutdown();
                    boolean c2 = false;
                    return c2;
                }
                project.executeTargets(targs);
                project.fireBuildFinished(null);
                ok = true;
            }
            catch (Throwable t) {
                project.fireBuildFinished(t);
            }
            finally {
                AntBridge.restoreSystemInOutErr();
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        AntModule.err.notify((Throwable)e);
                    }
                }
                Map<Thread, NbBuildLogger> map = loggersByThread;
                synchronized (map) {
                    loggersByThread.remove(currentThread);
                }
            }
            RP.post((Runnable)new PostRun(project, logger));
        }
        finally {
            AntBridge.unfakeJavaClassPath();
            LOG.log(Level.FINER, "Restoring CCL: {0}", oldCCL);
            Thread.currentThread().setContextClassLoader(oldCCL);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Thread process) {
        NbBuildLogger logger;
        Map<Thread, NbBuildLogger> map = loggersByThread;
        synchronized (map) {
            logger = loggersByThread.get(process);
        }
        if (logger != null) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BridgeImpl.class, (String)"MSG_stopping", (Object)logger.getDisplayNameNoLock()));
            logger.stop();
        }
        process.interrupt();
        RP.create((Runnable)new StopProcess(process)).schedule(10000);
    }

    private static void addCustomDefs(Project project) throws BuildException, IOException {
        long start = System.currentTimeMillis();
        if (AntBridge.getInterface().isAnt16()) {
            Map antlibLoaders = AntBridge.getCustomDefClassLoaders();
            for (Map.Entry entry : antlibLoaders.entrySet()) {
                String resource;
                String cnb = (String)entry.getKey();
                ClassLoader l = (ClassLoader)entry.getValue();
                URL antlib = l.getResource(resource = cnb.replace('.', '/') + "/antlib.xml");
                if (antlib == null) {
                    throw new IOException("Could not find " + resource + " in ant/nblib/" + cnb.replace('.', '-') + ".jar");
                }
                NbAntlib.process(project, antlib, null, l);
                String antlibUri = "antlib:" + cnb;
                NbAntlib.process(project, antlib, antlibUri, l);
            }
        } else {
            Map customDefs = AntBridge.getCustomDefsNoNamespace();
            for (Map.Entry entry : ((Map)customDefs.get("task")).entrySet()) {
                project.addTaskDefinition((String)entry.getKey(), (Class)entry.getValue());
            }
            for (Map.Entry entry : ((Map)customDefs.get("type")).entrySet()) {
                project.addDataTypeDefinition((String)entry.getKey(), (Class)entry.getValue());
            }
        }
        if (AntModule.err.isLoggable(1)) {
            AntModule.err.log("addCustomDefs took " + (System.currentTimeMillis() - start) + "msec");
        }
    }

    private static void gutProject(Project p) {
        if (!doGutProject) {
            return;
        }
        try {
            Field helpersF;
            String s = p.getName();
            AntModule.err.log("Gutting extra references in project \"" + s + "\"");
            for (Field f : Project.class.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
                f.setAccessible(true);
                Object o = f.get(p);
                if (o == null) continue;
                try {
                    if (o instanceof Collection) {
                        ((Collection)o).clear();
                        continue;
                    }
                    if (o instanceof Map) {
                        ((Map)o).clear();
                        continue;
                    }
                }
                catch (UnsupportedOperationException e) {
                    // empty catch block
                }
                if (Modifier.isFinal(f.getModifiers())) continue;
                if (o.getClass().isArray()) {
                    f.set(p, Array.newInstance(o.getClass().getComponentType(), 0));
                    continue;
                }
                f.set(p, null);
            }
            try {
                helpersF = IntrospectionHelper.class.getDeclaredField("helpers");
            }
            catch (NoSuchFieldException x) {
                helpersF = IntrospectionHelper.class.getDeclaredField("HELPERS");
            }
            helpersF.setAccessible(true);
            Object helpersO = helpersF.get(null);
            Map helpersM = (Map)helpersO;
            helpersM.clear();
            Introspector.flushCaches();
        }
        catch (Exception e) {
            AntModule.err.notify(1, (Throwable)e);
            doGutProject = false;
        }
    }

    private static class PostRun
    implements Runnable {
        private Project project;
        private NbBuildLogger logger;

        public PostRun(Project project, NbBuildLogger logger) {
            this.project = project;
            this.logger = logger;
        }

        @Override
        public void run() {
            IntrospectedInfo custom = AntSettings.getCustomDefs();
            HashMap<String, Map> defs = new HashMap<String, Map>();
            try {
                defs.put("task", NbCollections.checkedMapByCopy((Map)this.project.getTaskDefinitions(), String.class, Class.class, (boolean)true));
                defs.put("type", NbCollections.checkedMapByCopy((Map)this.project.getDataTypeDefinitions(), String.class, Class.class, (boolean)true));
            }
            catch (ThreadDeath threadDeath) {
                // empty catch block
            }
            custom.scanProject(defs);
            AntSettings.setCustomDefs((IntrospectedInfo)custom);
            this.logger.shutdown();
            refreshFilesystemsTask.schedule(0);
            BridgeImpl.gutProject(this.project);
            this.project = null;
            this.logger = null;
        }
    }

    private static class StopProcess
    implements Runnable {
        private final Thread process;

        StopProcess(Thread process) {
            this.process = process;
        }

        @Override
        public void run() {
            if (this.process.isAlive()) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BridgeImpl.class, (String)"MSG_halting"));
                this.stopThread();
            }
        }

        private void stopThread() {
            this.process.stop();
        }
    }
}

