/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.nio.ByteBuffer;
import java.util.Vector;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.howl.log.xa.XACommittingTx;
import org.objectweb.howl.log.xa.XALogRecord;
import org.objectweb.jotm.RecoverRmInfo;
import org.objectweb.jotm.RmRegistration;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionRecoveryImpl;
import org.objectweb.jotm.TxRecovered;
import org.objectweb.jotm.TxxidRecovered;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;
import org.objectweb.jotm.abortXAResourceXid;
import org.objectweb.jotm.commitXAResourceXid;

public class JotmRecovery {
    private static JotmRecovery unique = null;
    private static Vector vTxRecovered = new Vector();
    private static Vector vRecoverRmInfo = new Vector();
    private Vector userRecoveryRecords = new Vector();

    public JotmRecovery() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"JotmRecovery constructor");
        }
        unique = this;
    }

    public static JotmRecovery getJotmRecovery() {
        return unique;
    }

    public static Vector getTxRecovered() {
        return vTxRecovered;
    }

    public static Vector getRecoverRmInfo() {
        return vRecoverRmInfo;
    }

    public int getRmIndex(byte[] pxares) {
        int numRm = vRecoverRmInfo.size();
        for (int i = 0; i < numRm; ++i) {
            RecoverRmInfo myrecoverRmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(i);
            byte[] inrmxares = myrecoverRmInfo.getRecoverXaRes();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("XAResource param " + pxares));
                TraceTm.recovery.debug((Object)("XAResource in rm " + inrmxares));
            }
            if (inrmxares != pxares) continue;
            return myrecoverRmInfo.getRecoverIndex();
        }
        return 99;
    }

    public Vector getUserRecoveryVector() {
        return this.userRecoveryRecords;
    }

    public void rebuildTransaction(XALogRecord lr) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"rebuildTransaction");
        }
        RecoverRmInfo myrecoverRmInfo = null;
        TxxidRecovered myrecoverTxInfo = null;
        TxRecovered mytxRecovered = null;
        byte[] rt = new byte[3];
        byte[] rmname = null;
        Object rmxares = null;
        byte[] txXid = null;
        int xarescount = 0;
        byte[] rt2 = new byte[3];
        XACommittingTx myxacommittx = lr.getTx();
        byte[] tempRec = lr.getFields()[0];
        ByteBuffer rr = ByteBuffer.wrap(tempRec);
        rr.get(rt, 0, 3);
        String trt = new String(rt);
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("Recovery Record type= " + trt));
        }
        if (trt.equals("RM1")) {
            long rmdatetime = rr.getLong();
            int rmcount = rr.getInt();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Resource Manager count= " + rmcount));
            }
            for (int i = 1; i <= rmcount; ++i) {
                byte[] resmgr2 = lr.getFields()[i];
                ByteBuffer resm2 = ByteBuffer.wrap(resmgr2);
                resm2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RM2")) continue;
                int rmlength = resm2.getInt();
                rmname = new byte[rmlength];
                resm2.get(rmname, 0, rmlength);
                int xareslength = resm2.getInt();
                byte[] xares = new byte[xareslength];
                resm2.get(xares, 0, xareslength);
                int xaresnamelength = resm2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                resm2.get(xaresname, 0, xaresnamelength);
                int rmindx = resm2.getInt();
                String myrmname = new String(rmname);
                String myxares = new String(xares);
                String myxaresname = new String(xaresname);
                myrecoverRmInfo = new RecoverRmInfo();
                myrecoverRmInfo.addRecoverRmXaRes(myrmname, xares, myxaresname, rmindx);
                vRecoverRmInfo.addElement(myrecoverRmInfo);
            }
        } else if (trt.equals("RR1")) {
            long rcdatetime = rr.getLong();
            int txxidlength = rr.getInt();
            txXid = new byte[txxidlength];
            rr.get(txXid, 0, txxidlength);
            int txdatelength = rr.getInt();
            byte[] txdatetime = new byte[txdatelength];
            rr.get(txdatetime, 0, txdatelength);
            xarescount = rr.getInt();
            String mytxXid = new String(txXid);
            String mytxdatetime = new String(txdatetime);
            mytxRecovered = new TxRecovered();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("XAResource count= " + xarescount));
            }
            mytxRecovered.addtxrecovered(rcdatetime, txXid, mytxdatetime, xarescount, myxacommittx);
            for (int i = 1; i <= xarescount; ++i) {
                myrecoverTxInfo = new TxxidRecovered();
                byte[] recov2 = lr.getFields()[i];
                ByteBuffer rr2 = ByteBuffer.wrap(recov2);
                rr2.get(rt2, 0, 3);
                trt = new String(rt2);
                if (!trt.equals("RR2")) continue;
                int xaresindex = rr2.getInt();
                int xareslength = rr2.getInt();
                byte[] xares = new byte[xareslength];
                rr2.get(xares, 0, xareslength);
                int xaresnamelength = rr2.getInt();
                byte[] xaresname = new byte[xaresnamelength];
                rr2.get(xaresname, 0, xaresnamelength);
                int xidlength = rr2.getInt();
                byte[] recoveryxid = new byte[xidlength];
                rr2.get(recoveryxid, 0, xidlength);
                int xidstatus = rr2.getInt();
                String myxares = new String(xares);
                String myxaresname = new String(xaresname);
                String myrecoveryxid = new String(recoveryxid);
                myrecoverTxInfo.addXidInfo(xaresindex, xares, myxaresname, recoveryxid, xidstatus);
                mytxRecovered.addRecoverTxXidInfo(myrecoverTxInfo, i - 1);
            }
            vTxRecovered.addElement(mytxRecovered);
        } else if (trt.equals("RU1")) {
            XidImpl.setUuids(rr.getLong(), rr.getLong());
        } else {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Unknown record type during replay = " + trt));
            }
            rr.rewind();
            this.userRecoveryRecords.add(rr);
            this.userRecoveryRecords.add(myxacommittx);
        }
    }

    public void recoverTransactions(Vector rmreg) throws XAException {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"recoverTransactions");
        }
        Object myregisteredRmInfo = null;
        String myregrm = null;
        XAResource myregxares = null;
        int rmregsize = rmreg.size();
        RecoverRmInfo myrecoverRmInfo = null;
        String myrm = null;
        byte[] byxares = null;
        int rcflag = 0;
        int rmsize = vRecoverRmInfo.size();
        if (rmsize == 0) {
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"Nothing to recover");
            }
            return;
        }
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)("number Resource Manager recover= " + rmsize));
        }
        block2: for (int i = 0; i < rmregsize; ++i) {
            RmRegistration myrmreg = (RmRegistration)rmreg.elementAt(i);
            myregrm = myrmreg.rmGetName();
            myregxares = myrmreg.rmCheckoutXARes();
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)("Registered Resource Manager " + myregrm));
                TraceTm.recovery.debug((Object)("Registered XAResource " + myregxares));
            }
            for (int j = 0; j < rmsize; ++j) {
                myrecoverRmInfo = (RecoverRmInfo)vRecoverRmInfo.elementAt(j);
                myrm = myrecoverRmInfo.getRecoverRm();
                byxares = myrecoverRmInfo.getRecoverXaRes();
                if (TraceTm.recovery.isDebugEnabled()) {
                    TraceTm.recovery.debug((Object)("Recover Resource Manager " + myrm));
                    TraceTm.recovery.debug((Object)("Recover XAResource " + new String(byxares)));
                }
                if (myregrm.equals(myrm)) {
                    javax.transaction.xa.Xid[] javaxid = new javax.transaction.xa.Xid[100];
                    try {
                        javaxid = myregxares.recover(rcflag);
                    }
                    catch (XAException e) {
                        throw new XAException("xaResource.recover call failed during recovery " + e.getMessage());
                    }
                    if (javaxid == null) {
                        if (!TraceTm.recovery.isDebugEnabled()) continue block2;
                        TraceTm.recovery.debug((Object)"No XIDs to recover for Xares javaxid is null");
                        continue block2;
                    }
                    if (TraceTm.recovery.isDebugEnabled()) {
                        TraceTm.recovery.debug((Object)("javaxid size= " + javaxid.length));
                    }
                    if (javaxid.length == 0) {
                        if (!TraceTm.recovery.isDebugEnabled()) continue block2;
                        TraceTm.recovery.debug((Object)("No XIDs to recover for Xares= " + myregxares));
                        continue block2;
                    }
                    Xid[] rcxid = new Xid[javaxid.length];
                    for (int xx = 0; xx < javaxid.length; ++xx) {
                        rcxid[xx] = (Xid)javaxid[xx];
                    }
                    this.settxxidrecoveraction(myregxares, rcxid);
                    continue block2;
                }
                myrmreg.rmCheckinXARes();
            }
        }
        this.doActionXidRecover();
        this.doCleanupXidRecover();
    }

    private void settxxidrecoveraction(XAResource actxares, Xid[] actionxid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"settxxidrecoveraction");
        }
        TxxidRecovered myrecoverTxInfo = null;
        TxRecovered mytxRecovered = null;
        for (int i = 0; i < actionxid.length; ++i) {
            boolean xidfound = false;
            Xid myxid = actionxid[i];
            byte[] mybrqu = myxid.getBranchQualifier();
            if (myxid.IsThisOneOfOurs(mybrqu)) {
                for (int j = 0; j < vTxRecovered.size(); ++j) {
                    mytxRecovered = (TxRecovered)vTxRecovered.elementAt(j);
                    for (int k = 0; k < mytxRecovered.getxidcount(); ++k) {
                        myrecoverTxInfo = mytxRecovered.getRecoverTxXidInfo(k);
                        byte[] mytxxid = myrecoverTxInfo.getRecoverxid();
                        if (TraceTm.recovery.isDebugEnabled()) {
                            TraceTm.recovery.debug((Object)("mytxxid= " + new String(mytxxid)));
                            TraceTm.recovery.debug((Object)("myxid  = " + myxid.toString(true)));
                        }
                        if (!new String(mytxxid).equals(myxid.toString(true))) continue;
                        xidfound = true;
                        int myaction = 1;
                        myrecoverTxInfo.setRecoveraction(myaction);
                        myrecoverTxInfo.setCommitxares(actxares);
                        myrecoverTxInfo.setCommitxid(myxid);
                        mytxRecovered.addRecoverTxXidInfo(myrecoverTxInfo, k);
                        break;
                    }
                    if (xidfound) break;
                }
                if (xidfound) continue;
                this.abortimmediate(actxares, myxid);
                continue;
            }
            if (!TraceTm.recovery.isDebugEnabled()) continue;
            TraceTm.recovery.debug((Object)"Xid is not one of ours");
        }
    }

    private void doActionXidRecover() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"doActionXidRecover");
        }
        Object myrecoverTxInfo = null;
        TxRecovered mytxRecovered = null;
        for (int i = 0; i < vTxRecovered.size(); ++i) {
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            new commitXAResourceXid(mytxRecovered).start();
        }
    }

    private void abortimmediate(XAResource abortxares, Xid abortxid) {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"abortimmediate");
        }
        new abortXAResourceXid(abortxares, abortxid).start();
    }

    private void doCleanupXidRecover() {
        if (TraceTm.recovery.isDebugEnabled()) {
            TraceTm.recovery.debug((Object)"doCleanupXidRecover");
        }
        TxxidRecovered myTxxidRecovered = null;
        TxRecovered mytxRecovered = null;
        for (int i = vTxRecovered.size() - 1; i >= 0; --i) {
            boolean possibleheuristic = false;
            XACommittingTx myxacommittingtx = null;
            mytxRecovered = (TxRecovered)vTxRecovered.elementAt(i);
            for (int j = 0; j < mytxRecovered.getxidcount(); ++j) {
                myTxxidRecovered = mytxRecovered.getRecoverTxXidInfo(j);
                if (myTxxidRecovered.getRecoveraction() != 9) continue;
                possibleheuristic = true;
            }
            if (possibleheuristic) {
                if (!TraceTm.recovery.isDebugEnabled()) continue;
                TraceTm.recovery.debug((Object)"build new txRecovered entry");
                continue;
            }
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"write howlDonelog");
            }
            myxacommittingtx = mytxRecovered.getXACommittingTx();
            byte[] rmDone = new byte[11];
            byte[][] rmDoneRecord = new byte[1][11];
            rmDone = "RR3JOTMDONE".getBytes();
            try {
                rmDoneRecord[0] = rmDone;
                TransactionRecoveryImpl.getTransactionRecovery().howlDoneLog(rmDoneRecord, myxacommittingtx);
            }
            catch (Exception f) {
                String howlerror = "Cannot howlDoneLog:" + f + "--" + f.getMessage();
                TraceTm.jotm.error((Object)("Got LogException from howlDoneLog: " + howlerror));
            }
            if (TraceTm.recovery.isDebugEnabled()) {
                TraceTm.recovery.debug((Object)"remove txRecovered entry");
            }
            vTxRecovered.remove(i);
        }
    }
}

