/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.ejb.codegen;

import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.IASEjbCMPEntityDescriptor;
import com.sun.jdo.spi.persistence.support.ejb.codegen.GeneratorException;
import com.sun.jdo.spi.persistence.support.ejb.codegen.LogHelperCmpCompiler;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.CMPProcessor;
import com.sun.jdo.spi.persistence.support.ejb.ejbc.JDOCodeGenerator;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.ejb.spi.CMPDeployer;
import org.glassfish.persistence.common.I18NHelper;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CMPDeployerImpl
implements CMPDeployer {
    @Inject(optional=true)
    private JavaConfig javaConfig = null;
    @Inject
    private Habitat habitat;
    private static final Logger _logger = LogHelperCmpCompiler.getLogger();
    private static final ResourceBundle messages = I18NHelper.loadBundle(CMPDeployerImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentContext ctx) throws DeploymentException {
        Application application = null;
        EjbBundleDescriptor bundle = null;
        String beanName = null;
        StringBuffer generatorExceptionMsg = null;
        try {
            long start;
            JDOCodeGenerator gen = new JDOCodeGenerator();
            File stubsDir = ctx.getScratchDir("ejb");
            application = (Application)ctx.getModuleMetaData(Application.class);
            if (_logger.isLoggable(500)) {
                _logger.fine("cmpc.processing_cmp", (Object)application.getRegistrationName());
            }
            ArrayList<File> cmpFiles = new ArrayList<File>();
            ClassLoader jcl = application.getClassLoader();
            bundle = (EjbBundleDescriptor)ctx.getModuleMetaData(EjbBundleDescriptor.class);
            String archiveUri = ctx.getSource().getURI().getSchemeSpecificPart();
            if (_logger.isLoggable(500)) {
                _logger.fine("[CMPC] Module Dir name is " + archiveUri);
            }
            String generatedXmlsPath = ctx.getScratchDir("xml").getCanonicalPath();
            if (_logger.isLoggable(500)) {
                _logger.fine("[CMPC] Generated XML Dir name is " + generatedXmlsPath);
            }
            try {
                start = System.currentTimeMillis();
                gen.init(bundle, ctx, archiveUri, generatedXmlsPath);
                for (EjbDescriptor desc : bundle.getEjbs()) {
                    beanName = desc.getName();
                    if (_logger.isLoggable(500)) {
                        _logger.fine("[CMPC] Ejb Class Name: " + desc.getEjbClassName());
                    }
                    if (!(desc instanceof IASEjbCMPEntityDescriptor)) continue;
                    IASEjbCMPEntityDescriptor entd = (IASEjbCMPEntityDescriptor)desc;
                    if (_logger.isLoggable(500)) {
                        _logger.fine("[CMPC] Home Object Impl name  is " + entd.getLocalHomeImplClassName());
                    }
                    ClassLoader ocl = entd.getClassLoader();
                    entd.setClassLoader(jcl);
                    try {
                        gen.generate(entd, stubsDir, stubsDir);
                    }
                    catch (GeneratorException e) {
                        String msg = e.getMessage();
                        _logger.warning(msg);
                        generatorExceptionMsg = this.addGeneratorExceptionMessage(msg, generatorExceptionMsg);
                    }
                    finally {
                        entd.setClassLoader(ocl);
                    }
                }
                beanName = null;
                cmpFiles.addAll(gen.cleanup());
                long end = System.currentTimeMillis();
                _logger.fine("CMP Generation: " + (end - start) + " msec");
            }
            catch (GeneratorException e) {
                String msg = e.getMessage();
                _logger.warning(msg);
                generatorExceptionMsg = this.addGeneratorExceptionMessage(msg, generatorExceptionMsg);
            }
            bundle = null;
            if (generatorExceptionMsg == null) {
                start = System.currentTimeMillis();
                this.compileClasses(ctx, cmpFiles, stubsDir);
                long end = System.currentTimeMillis();
                _logger.fine("Java Compilation: " + (end - start) + " msec");
                start = System.currentTimeMillis();
                CMPProcessor processor = new CMPProcessor(ctx);
                processor.process();
                end = System.currentTimeMillis();
                _logger.fine("Java2DB processing: " + (end - start) + " msec");
                _logger.fine("cmpc.done_processing_cmp", (Object)application.getRegistrationName());
            }
        }
        catch (GeneratorException e) {
            _logger.warning(e.getMessage());
            throw new DeploymentException((Throwable)e);
        }
        catch (Throwable e) {
            String eType = e.getClass().getName();
            String appName = application.getRegistrationName();
            String exMsg = e.getMessage();
            String msg = null;
            if (bundle == null) {
                msg = I18NHelper.getMessage((ResourceBundle)messages, (String)"cmpc.cmp_app_error", (String)eType, (String)appName, (String)exMsg);
            } else {
                String bundleName = bundle.getModuleDescriptor().getArchiveUri();
                msg = beanName == null ? I18NHelper.getMessage((ResourceBundle)messages, (String)"cmpc.cmp_module_error", (Object[])new Object[]{eType, appName, bundleName, exMsg}) : I18NHelper.getMessage((ResourceBundle)messages, (String)"cmpc.cmp_bean_error", (Object[])new Object[]{eType, beanName, appName, bundleName, exMsg});
            }
            _logger.log(1000, msg, e);
            throw new DeploymentException(msg);
        }
        if (generatorExceptionMsg != null) {
            throw new DeploymentException(generatorExceptionMsg.toString());
        }
    }

    public void clean(DeploymentContext ctx) {
        CMPProcessor processor = new CMPProcessor(ctx);
        processor.clean();
    }

    public void unload(ClassLoader cl) {
        try {
            EJBHelper.notifyApplicationUnloaded((ClassLoader)cl);
        }
        catch (Exception e) {
            _logger.log(900, "cmpc.cmp_cleanup_problems", (Throwable)e);
        }
    }

    private void compileClasses(DeploymentContext ctx, List<File> files, File destDir) throws GeneratorException {
        if (files.isEmpty()) {
            return;
        }
        String classPath = (String)ctx.getTransientAppMetaData("org.glassfish.ejb.spi.module.classpath", String.class);
        ArrayList<String> options = new ArrayList<String>();
        if (this.javaConfig != null) {
            options.addAll(this.javaConfig.getJavacOptionsAsList());
        }
        StringBuffer msgBuffer = new StringBuffer();
        boolean compilationResult = false;
        try {
            long start;
            options.add("-d");
            options.add(destDir.toString());
            options.add("-classpath");
            options.add(System.getProperty("java.class.path") + File.pathSeparator + classPath);
            if (_logger.isLoggable(500)) {
                for (File file : files) {
                    _logger.fine(I18NHelper.getMessage((ResourceBundle)messages, (String)"cmpc.compile", (String)file.getPath()));
                }
                StringBuffer sbuf = new StringBuffer();
                for (String s : options) {
                    sbuf.append("\n\t").append(s);
                }
                _logger.fine("[CMPC] JAVAC OPTIONS: " + sbuf.toString());
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            StandardJavaFileManager manager = compiler.getStandardFileManager(diagnostics, null, null);
            Iterable<? extends JavaFileObject> compilationUnits = manager.getJavaFileObjectsFromFiles(files);
            long end = start = System.currentTimeMillis();
            compilationResult = compiler.getTask(null, manager, diagnostics, options, null, compilationUnits).call();
            end = System.currentTimeMillis();
            _logger.fine("JAVA compile time (" + files.size() + " files) = " + (end - start));
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                if (diagnostic.getKind().equals((Object)Diagnostic.Kind.NOTE)) {
                    if (!_logger.isLoggable(500)) continue;
                    msgBuffer.append("\n").append(diagnostic.getMessage(null));
                    continue;
                }
                msgBuffer.append("\n").append(diagnostic.getMessage(null));
            }
            manager.close();
        }
        catch (Exception jce) {
            _logger.fine("cmpc.cmp_complilation_exception", (Object)jce);
            String msg = I18NHelper.getMessage((ResourceBundle)messages, (String)"cmpc.cmp_complilation_exception", (Object[])new Object[]{jce.getMessage()});
            GeneratorException ge = new GeneratorException(msg);
            ge.initCause(jce);
            throw ge;
        }
        if (!compilationResult) {
            _logger.warning(I18NHelper.getMessage((ResourceBundle)messages, (String)"cmpc.cmp_complilation_problems", (String)msgBuffer.toString()));
            throw new GeneratorException(I18NHelper.getMessage((ResourceBundle)messages, (String)"cmpc.cmp_complilation_failed"));
        }
    }

    private StringBuffer addGeneratorExceptionMessage(String msg, StringBuffer buf) {
        StringBuffer rc = buf;
        if (rc == null) {
            rc = new StringBuffer(msg);
        } else {
            rc.append('\n').append(msg);
        }
        return rc;
    }
}

