/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.utils;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.common.ui.BrokenServerLibrarySupport;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerInstance;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ServerManager;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.api.problem.ProblemReporter;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.ejb.EjbModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleImpl;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Properties;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MavenProjectSupport {
    private MavenProjectSupport() {
    }

    public static synchronized void changeServer(Project project, boolean initContextPath) {
        if (project == null) {
            return;
        }
        String[] ids = MavenProjectSupport.obtainServerIds(project);
        String instanceID = ids[0];
        String serverID = ids[1];
        ProblemReporter problems = (ProblemReporter)project.getLookup().lookup(ProblemReporter.class);
        if (instanceID != null && serverID == null) {
            MavenProjectSupport.assignServer(project, instanceID, initContextPath);
        } else if (instanceID == null && serverID == null) {
            MavenProjectSupport.assignServer(project, instanceID, initContextPath);
        } else if (instanceID == null && serverID != null) {
            problems.addReport(MavenProjectSupport.createMissingServerReport(project, serverID));
        }
        J2eeModuleProvider moduleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (moduleProvider != null) {
            if (!BrokenServerLibrarySupport.getMissingServerLibraries((Project)project).isEmpty()) {
                problems.addReport(MavenProjectSupport.createBrokenLibraryReport(project));
                BrokenServerLibrarySupport.fixOrShowAlert((Project)project, null);
            }
            if (RunUtils.hasApplicationCompileOnSaveEnabled((Project)project)) {
                Deployment.getDefault().enableCompileOnSaveSupport(moduleProvider);
            }
        }
    }

    private static void assignServer(Project project, String instanceID, boolean initContextPath) {
        MavenProjectSupport.setServer(project, (J2eeModuleProvider)project.getLookup().lookup(WebModuleProviderImpl.class), instanceID);
        MavenProjectSupport.setServer(project, (J2eeModuleProvider)project.getLookup().lookup(EjbModuleProviderImpl.class), instanceID);
        MavenProjectSupport.setServer(project, (J2eeModuleProvider)project.getLookup().lookup(EarModuleProviderImpl.class), instanceID);
        if (initContextPath) {
            MavenProjectSupport.initContextPath(project);
        }
    }

    private static void setServer(Project project, J2eeModuleProvider moduleProvider, String serverID) {
        if (moduleProvider != null) {
            if (J2eeModule.Type.WAR.equals(moduleProvider.getJ2eeModule().getType())) {
                MavenProjectSupport.createDDIfRequired(project, serverID);
            }
            moduleProvider.setServerInstanceID(serverID);
            moduleProvider.getConfigSupport().ensureConfigurationReady();
        }
    }

    private static void initContextPath(Project project) {
        NbMavenProject mavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        WebModuleProviderImpl webModuleProvider = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
        if (!"war".equals(mavenProject.getPackagingType()) || webModuleProvider == null) {
            return;
        }
        WebModuleImpl webModuleImpl = webModuleProvider.getModuleImpl();
        String contextPath = webModuleImpl.getContextPath();
        if (contextPath == null || "".equals(contextPath)) {
            webModuleImpl.setContextPath("/" + mavenProject.getMavenProject().getArtifactId());
        }
    }

    private static ProblemReport createMissingServerReport(Project project, String serverID) {
        String serverName = Deployment.getDefault().getServerDisplayName(serverID);
        if (serverName == null) {
            serverName = serverID;
        }
        ProblemReport serverProblem = new ProblemReport(0, NbBundle.getMessage(MavenProjectSupport.class, (String)"MSG_AppServer", (Object)serverName), NbBundle.getMessage(MavenProjectSupport.class, (String)"HINT_AppServer"), (Action)new AddServerAction(project));
        return serverProblem;
    }

    private static ProblemReport createBrokenLibraryReport(Project project) {
        ProblemReport libProblem = new ProblemReport(0, NbBundle.getMessage(MavenProjectSupport.class, (String)"MSG_LibProblem"), NbBundle.getMessage(MavenProjectSupport.class, (String)"MSG_LibProblem_Description"), (Action)new ServerLibraryAction(project));
        return libProblem;
    }

    public static boolean isWebSupported(Project project, String packaging) {
        return "war".equals(packaging) || MavenProjectSupport.isBundlePackaging(project, packaging);
    }

    public static boolean isBundlePackaging(Project project, String packaging) {
        NbMavenProject proj = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        boolean isBundlePackaging = "bundle".equals(packaging);
        boolean webAppDirExists = new File(proj.getWebAppDirectory()).exists();
        return isBundlePackaging && webAppDirExists;
    }

    public static String[] obtainServerIds(Project project) {
        SessionContent sc = (SessionContent)project.getLookup().lookup(SessionContent.class);
        if (sc != null && sc.getServerInstanceId() != null) {
            return new String[]{sc.getServerInstanceId(), null};
        }
        AuxiliaryProperties props = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
        String val = props.get("netbeans.deployment.server.id", false);
        if (val != null) {
            return new String[]{val, null};
        }
        String server = props.get("netbeans.hint.deploy.server", true);
        if (server == null) {
            server = props.get("netbeans.deployment.server.type", true);
        }
        return new String[]{null, server};
    }

    public static String obtainServerName(Project project) {
        ServerInstance si;
        String id = MavenProjectSupport.obtainServerIds(project)[0];
        if (id != null && (si = Deployment.getDefault().getServerInstance(id)) != null) {
            try {
                return si.getDisplayName();
            }
            catch (InstanceRemovedException ex) {
                Logger.getLogger(Wrapper.class.getName()).log(Level.FINE, "", ex);
            }
        }
        return null;
    }

    public static String obtainServerID(String serverInstanceID) {
        ServerInstance si = Deployment.getDefault().getServerInstance(serverInstanceID);
        try {
            return si.getServerID();
        }
        catch (InstanceRemovedException ex) {
            return null;
        }
    }

    public static void storeSettingsToPom(Project project, String name, String value) {
        MavenProjectSupport.storeSettingsToPom(project.getProjectDirectory(), name, value);
    }

    public static void storeSettingsToPom(FileObject projectFile, final String name, final String value) {
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Properties props = model.getProject().getProperties();
                if (props == null) {
                    props = model.getFactory().createProperties();
                    model.getProject().setProperties(props);
                }
                props.setProperty(name, value);
            }
        };
        final FileObject pom = projectFile.getFileObject("pom.xml");
        try {
            pom.getFileSystem().runAtomicAction(new FileSystem.AtomicAction((ModelOperation)operation){
                final /* synthetic */ ModelOperation val$operation;
                {
                    this.val$operation = modelOperation;
                }

                public void run() throws IOException {
                    Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(this.val$operation));
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void createDDIfRequired(Project project) {
        MavenProjectSupport.createDDIfRequired(project, null);
    }

    public static void createDDIfRequired(Project project, String serverID) {
        if (serverID == null) {
            serverID = MavenProjectSupport.readServerID(project);
        }
        if (serverID != null && serverID.contains("WebLogic")) {
            MavenProjectSupport.createDD(project);
        }
    }

    private static void createDD(Project project) {
        WebModuleProviderImpl webModule = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
        if (webModule != null) {
            WebModuleImpl webModuleImpl = webModule.getModuleImpl();
            try {
                FileObject webInf = webModuleImpl.getWebInf();
                if (webInf == null) {
                    webInf = webModuleImpl.createWebInf();
                }
                assert (webInf != null);
                FileObject webXml = webModuleImpl.getDeploymentDescriptor();
                if (webXml == null) {
                    AuxiliaryProperties props = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
                    String j2eeVersion = props.get("netbeans.hint.j2eeVersion", false);
                    webXml = DDHelper.createWebXml((Profile)Profile.fromPropertiesString((String)j2eeVersion), (FileObject)webInf);
                }
                assert (webXml != null);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static String readServerID(Project project) {
        return MavenProjectSupport.readSettings(project, "netbeans.hint.deploy.server", true);
    }

    public static String readServerInstanceID(Project project) {
        return MavenProjectSupport.readSettings(project, "netbeans.deployment.server.id", false);
    }

    public static String readJ2eeVersion(Project project) {
        return MavenProjectSupport.readSettings(project, "netbeans.hint.j2eeVersion", false);
    }

    private static String readSettings(Project project, String propertyName, boolean shared) {
        return ((AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class)).get(propertyName, shared);
    }

    public static void setJ2eeVersion(Project project, String value) {
        MavenProjectSupport.setSettings(project, "netbeans.hint.j2eeVersion", value, false);
    }

    public static void setServerID(Project project, String value) {
        MavenProjectSupport.setSettings(project, "netbeans.hint.deploy.server", value, true);
    }

    public static void setOldServerInstanceID(Project project, String value) {
        MavenProjectSupport.setSettings(project, "netbeans.deployment.server.type", value, true);
    }

    public static void setServerInstanceID(Project project, String value) {
        MavenProjectSupport.setSettings(project, "netbeans.deployment.server.id", value, false);
    }

    private static void setSettings(Project project, String key, String value, boolean shared) {
        AuxiliaryProperties props = (AuxiliaryProperties)project.getLookup().lookup(AuxiliaryProperties.class);
        props.put(key, value, shared);
    }

    private static class AddServerAction
    extends AbstractAction {
        private Project prj;

        private AddServerAction(Project project) {
            this.prj = project;
            this.putValue("Name", NbBundle.getMessage(MavenProjectSupport.class, (String)"TXT_Add_Server"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final String newOne = ServerManager.showAddServerInstanceWizard();
            final String serverType = newOne != null ? MavenProjectSupport.obtainServerID(newOne) : null;
            Utilities.performPOMModelOperations((FileObject)this.prj.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

                public void performOperation(POMModel model) {
                    if (newOne != null) {
                        Properties props = model.getProject().getProperties();
                        if (props == null) {
                            props = model.getFactory().createProperties();
                            model.getProject().setProperties(props);
                        }
                        props.setProperty("netbeans.hint.deploy.server", serverType);
                    } else {
                        Properties props = model.getProject().getProperties();
                        if (props != null) {
                            props.setProperty("netbeans.hint.deploy.server", null);
                        }
                    }
                }
            }));
            ((AuxiliaryProperties)this.prj.getLookup().lookup(AuxiliaryProperties.class)).put("netbeans.deployment.server.id", newOne, false);
        }
    }

    private static class ServerLibraryAction
    extends AbstractAction {
        private Project project;

        public ServerLibraryAction(Project project) {
            this.putValue("Name", NbBundle.getMessage(MavenProjectSupport.class, (String)"LBL_LibProblem_ActionName"));
            this.project = project;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrokenServerLibrarySupport.fixServerLibraries((Project)this.project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    NbMavenProject.fireMavenProjectReload((Project)ServerLibraryAction.this.project);
                }
            });
        }
    }
}

