/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.Storage;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.profiler.ApplicationProfilerView;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.ProfilingSettingsPresets;
import org.netbeans.lib.profiler.ui.components.JExtendedSpinner;
import org.openide.util.NbBundle;

class MemorySettingsSupport {
    private static final String PROP_PREFIX = "ProfilerMemorySettings_";
    static final String SNAPSHOT_VERSION = "ProfilerMemorySettings_version";
    private static final String SNAPSHOT_VERSION_DIVIDER = ".";
    private static final String CURRENT_SNAPSHOT_VERSION_MAJOR = "1";
    private static final String CURRENT_SNAPSHOT_VERSION_MINOR = "0";
    private static final String CURRENT_SNAPSHOT_VERSION = "1.0";
    public static final String PROP_MODE = "ProfilerMemorySettings_mode";
    public static final String PROP_STACKTRACES = "ProfilerMemorySettings_stacktraces";
    public static final String PROP_TRACK_EVERY = "ProfilerMemorySettings_track_every";
    private JPanel panel;
    private JRadioButton allocRadioButton;
    private JRadioButton livenessRadioButton;
    private JCheckBox stackTracesCheckBox;
    private JButton resetDefaultsButton;
    private JLabel trackEveryLabel1;
    private JLabel trackEveryLabel2;
    private JSpinner trackEverySpinner;
    private Application application;

    public MemorySettingsSupport(Application application) {
        this.application = application;
    }

    public DataViewComponent.DetailsView getDetailsView() {
        return new DataViewComponent.DetailsView(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Memory_settings"), null, 20, (JComponent)this.getPanel(), null);
    }

    public void setUIEnabled(boolean enabled) {
        if (this.panel == null) {
            return;
        }
        this.panel.setEnabled(enabled);
        this.allocRadioButton.setEnabled(enabled);
        this.livenessRadioButton.setEnabled(enabled);
        this.stackTracesCheckBox.setEnabled(enabled);
        this.resetDefaultsButton.setEnabled(enabled);
        this.trackEveryLabel1.setEnabled(enabled);
        this.trackEveryLabel2.setEnabled(enabled);
        this.trackEverySpinner.setEnabled(enabled);
    }

    public ProfilingSettings getSettings() {
        if (this.panel == null) {
            return null;
        }
        ProfilingSettings settings = this.allocRadioButton.isSelected() ? ProfilingSettingsPresets.createMemoryPreset((int)2) : ProfilingSettingsPresets.createMemoryPreset((int)4);
        settings.setAllocStackTraceLimit(this.stackTracesCheckBox.isSelected() ? -1 : 0);
        settings.setAllocTrackEvery(((Integer)this.trackEverySpinner.getValue()).intValue());
        return settings;
    }

    public void saveSettings() {
        if (this.application == null) {
            return;
        }
        Storage storage = this.application.getStorage();
        storage.setCustomProperty(SNAPSHOT_VERSION, CURRENT_SNAPSHOT_VERSION);
        storage.setCustomProperty(PROP_MODE, Integer.toString(this.allocRadioButton.isSelected() ? 2 : 4));
        storage.setCustomProperty(PROP_STACKTRACES, Integer.toString(this.stackTracesCheckBox.isSelected() ? -1 : 0));
        storage.setCustomProperty(PROP_TRACK_EVERY, Integer.toString((Integer)this.trackEverySpinner.getValue()));
    }

    private void loadSettings() {
        String trackEveryObj;
        String stackTraces;
        if (this.application == null) {
            return;
        }
        Storage storage = this.application.getStorage();
        String profilingMode = storage.getCustomProperty(PROP_MODE);
        if (profilingMode != null) {
            try {
                int profilingModeInt = Integer.parseInt(profilingMode);
                if (profilingModeInt == 2) {
                    this.allocRadioButton.setSelected(true);
                } else if (profilingModeInt == 4) {
                    this.livenessRadioButton.setSelected(true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((stackTraces = storage.getCustomProperty(PROP_STACKTRACES)) != null) {
            try {
                int stackTracesInt = Integer.parseInt(stackTraces);
                this.stackTracesCheckBox.setSelected(stackTracesInt != 0);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((trackEveryObj = storage.getCustomProperty(PROP_TRACK_EVERY)) != null) {
            try {
                int trackEveryObjInt = Integer.parseInt(trackEveryObj);
                this.trackEverySpinner.setValue(trackEveryObjInt);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void setDefaults() {
        this.livenessRadioButton.setSelected(true);
        this.stackTracesCheckBox.setSelected(false);
        this.trackEverySpinner.setValue(10);
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            this.setDefaults();
            this.loadSettings();
        }
        return this.panel;
    }

    private JPanel createPanel() {
        JPanel panelImpl = new JPanel();
        panelImpl.setLayout(new GridBagLayout());
        panelImpl.setOpaque(false);
        JLabel referenceLabel = new JLabel("X");
        ButtonGroup modesRadioGroup = new ButtonGroup();
        this.allocRadioButton = new JRadioButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profile_Allocations"));
        this.allocRadioButton.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Allocations"));
        this.allocRadioButton.setOpaque(false);
        this.allocRadioButton.setBorder(referenceLabel.getBorder());
        modesRadioGroup.add(this.allocRadioButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 10, 10);
        panelImpl.add((Component)this.allocRadioButton, constraints);
        this.livenessRadioButton = new JRadioButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profile_AllocationsGC"));
        this.livenessRadioButton.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Allocations_GC"));
        this.livenessRadioButton.setOpaque(false);
        this.livenessRadioButton.setBorder(referenceLabel.getBorder());
        modesRadioGroup.add(this.livenessRadioButton);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 10, 10, 10);
        panelImpl.add((Component)this.livenessRadioButton, constraints);
        JPanel trackEveryContainer = new JPanel(new GridBagLayout());
        this.trackEveryLabel1 = new JLabel(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Track_Every1"));
        this.trackEveryLabel1.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Track_Every"));
        this.trackEveryLabel1.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 5);
        trackEveryContainer.add((Component)this.trackEveryLabel1, constraints);
        this.trackEverySpinner = new JExtendedSpinner(new SpinnerNumberModel(10, 1, Integer.MAX_VALUE, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(55, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.trackEverySpinner.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Track_Every"));
        this.trackEveryLabel1.setLabelFor(this.trackEverySpinner);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 0, 0, 0);
        trackEveryContainer.add((Component)this.trackEverySpinner, constraints);
        this.trackEveryLabel2 = new JLabel(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Track_Every2"));
        this.trackEveryLabel2.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Track_Every"));
        this.trackEveryLabel2.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 5, 0, 0);
        trackEveryContainer.add((Component)this.trackEveryLabel2, constraints);
        trackEveryContainer.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.insets = new Insets(5, 10, 10, 10);
        panelImpl.add((Component)trackEveryContainer, constraints);
        this.stackTracesCheckBox = new JCheckBox(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Record_Stacktraces"));
        this.stackTracesCheckBox.setToolTipText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"TOOLTIP_Stack_Traces"));
        this.stackTracesCheckBox.setOpaque(false);
        this.stackTracesCheckBox.setBorder(referenceLabel.getBorder());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 10, 10, 10);
        panelImpl.add((Component)this.stackTracesCheckBox, constraints);
        JPanel filler = new JPanel(null);
        filler.setOpaque(false);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        panelImpl.add((Component)filler, constraints);
        this.resetDefaultsButton = new JButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Restore_Defaults")){

            protected void fireActionPerformed(ActionEvent event) {
                MemorySettingsSupport.this.setDefaults();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.anchor = 13;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 6, 10);
        panelImpl.add((Component)this.resetDefaultsButton, constraints);
        return panelImpl;
    }
}

