/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiler;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.datasupport.DataRemovedListener;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.DesktopUtils;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import com.sun.tools.visualvm.profiler.CPUSettingsSupport;
import com.sun.tools.visualvm.profiler.MemorySettingsSupport;
import com.sun.tools.visualvm.profiler.ProfilerSupport;
import com.sun.tools.visualvm.profiler.ProfilingResultsSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

class ApplicationProfilerView
extends DataSourceView {
    private static final String IMAGE_PATH = "com/sun/tools/visualvm/profiler/resources/profiler.png";
    private MasterViewSupport masterViewSupport;
    private CPUSettingsSupport cpuSettingsSupport;
    private MemorySettingsSupport memorySettingsSupport;
    private boolean classSharingBreaksProfiling;

    public ApplicationProfilerView(Application application) {
        super((DataSource)application, NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profiler"), new ImageIcon(ImageUtilities.loadImage((String)IMAGE_PATH, (boolean)true)).getImage(), 40, false);
        this.cpuSettingsSupport = new CPUSettingsSupport(application);
        this.memorySettingsSupport = new MemorySettingsSupport(application);
    }

    protected DataViewComponent createComponent() {
        Application application = (Application)this.getDataSource();
        ProfilingResultsSupport profilingResultsSupport = new ProfilingResultsSupport();
        this.masterViewSupport = new MasterViewSupport(application, profilingResultsSupport, this.cpuSettingsSupport, this.memorySettingsSupport, this.classSharingBreaksProfiling);
        DataViewComponent dvc = new DataViewComponent(this.masterViewSupport.getMasterView(), new DataViewComponent.MasterViewConfiguration(false));
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profiling_results"), false), 1);
        dvc.addDetailsView(profilingResultsSupport.getDetailsView(), 1);
        dvc.configureDetailsArea(new DataViewComponent.DetailsAreaConfiguration(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Settings"), true), 2);
        dvc.addDetailsView(this.cpuSettingsSupport.getDetailsView(), 2);
        dvc.addDetailsView(this.memorySettingsSupport.getDetailsView(), 2);
        dvc.hideDetailsArea(2);
        this.cpuSettingsSupport = null;
        this.memorySettingsSupport = null;
        return dvc;
    }

    protected void willBeAdded() {
        this.classSharingBreaksProfiling = ProfilerSupport.getInstance().classSharingBreaksProfiling((Application)this.getDataSource());
    }

    protected void removed() {
        this.masterViewSupport.viewRemoved();
    }

    private static final class OneWayToggleButton
    extends JToggleButton {
        public OneWayToggleButton(String text) {
            super(text);
        }

        protected void processMouseEvent(MouseEvent e) {
            if (!this.isSelected()) {
                super.processMouseEvent(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MasterViewSupport
    extends JPanel
    implements ProfilingStateListener,
    DataRemovedListener<Application>,
    ActionListener,
    PropertyChangeListener {
        private Application application;
        private ProfilingResultsSupport profilingResultsView;
        private CPUSettingsSupport cpuSettingsSupport;
        private MemorySettingsSupport memorySettingsSupport;
        private AttachSettings attachSettings;
        private Timer timer;
        private int lastInstrValue = -1;
        private int state = -1;
        private boolean internalChange = false;
        private boolean applicationTerminated = false;
        private boolean classSharingBreaksProfiling;
        private HTMLTextArea classShareWarningArea;
        private JLabel modeLabel;
        private JToggleButton cpuButton;
        private JToggleButton memoryButton;
        private JButton stopButton;
        private JLabel statusLabel;
        private HTMLLabel statusValueLabel;
        private static final int refLabelHeight = new HTMLLabel((String)"X").getPreferredSize().height;

        public MasterViewSupport(Application application, ProfilingResultsSupport profilingResultsView, CPUSettingsSupport cpuSettingsSupport, MemorySettingsSupport memorySettingsSupport, boolean classSharingBreaksProfiling) {
            this.application = application;
            this.profilingResultsView = profilingResultsView;
            this.cpuSettingsSupport = cpuSettingsSupport;
            this.memorySettingsSupport = memorySettingsSupport;
            this.classSharingBreaksProfiling = classSharingBreaksProfiling;
            this.initComponents();
            this.initSettings();
            this.refreshStatus();
            this.timer = new Timer(1000, this);
            this.timer.setInitialDelay(1000);
            NetBeansProfiler.getDefaultNB().addProfilingStateListener((ProfilingStateListener)this);
            application.notifyWhenRemoved((DataRemovedListener)this);
            application.addPropertyChangeListener("prop_state", WeakListeners.propertyChange((PropertyChangeListener)this, (Object)application));
        }

        public DataViewComponent.MasterView getMasterView() {
            return new DataViewComponent.MasterView(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profiler"), null, (JComponent)this);
        }

        public synchronized void dataRemoved(Application application) {
            this.applicationTerminated = true;
            this.timer.stop();
            this.timer.removeActionListener(this);
            NetBeansProfiler.getDefaultNB().removeProfilingStateListener((ProfilingStateListener)this);
            ProfilerSupport.getInstance().setProfiledApplication(null);
            this.lastInstrValue = -1;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MasterViewSupport.this.resetControlButtons();
                    MasterViewSupport.this.disableControlButtons();
                    MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_application_terminated"));
                    MasterViewSupport.this.enableSettings();
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.dataRemoved(this.application);
        }

        public void viewRemoved() {
            this.timer.stop();
            this.timer.removeActionListener(this);
            NetBeansProfiler.getDefaultNB().removeProfilingStateListener((ProfilingStateListener)this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateRunningText();
        }

        private static JComponent getLiveResultsView() {
            LiveResultsWindow view = LiveResultsWindow.getDefault();
            Component[] components = view.getComponents();
            if (components.length > 0 && components[0] instanceof JToolBar) {
                JToolBar toolbar = (JToolBar)components[0];
                toolbar.setOpaque(false);
                components = toolbar.getComponents();
                for (int i = 0; i < components.length; ++i) {
                    Component component = components[i];
                    if (!(component instanceof AbstractButton)) continue;
                    ((AbstractButton)component).setOpaque(false);
                    if (i != 5) continue;
                    ((AbstractButton)component).setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Snapshot"));
                }
            }
            view.setPreferredSize(new Dimension(1, 1));
            return view;
        }

        private void handleCPUProfiling() {
            if (this.internalChange) {
                return;
            }
            if (this.cpuButton.isSelected()) {
                this.internalChange = true;
                this.memoryButton.setSelected(false);
                this.internalChange = false;
                if (!this.cpuSettingsSupport.isRootValueValid() || !this.cpuSettingsSupport.isFilterValueValid()) {
                    this.internalChange = true;
                    this.cpuButton.setSelected(false);
                    this.internalChange = false;
                    NetBeansProfiler.getDefaultNB().displayError(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Incorrect_CPU_settings"));
                } else {
                    this.cpuSettingsSupport.saveSettings();
                    if (NetBeansProfiler.getDefaultNB().getProfilingState() == 4) {
                        IDEUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                            public void run() {
                                NetBeansProfiler.getDefaultNB().modifyCurrentProfiling(MasterViewSupport.this.cpuSettingsSupport.getSettings());
                            }
                        });
                    } else {
                        this.disableControlButtons();
                        ProfilerSupport.getInstance().setProfiledApplication(this.application);
                        IDEUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                            public void run() {
                                MasterViewSupport.this.startProfiling(MasterViewSupport.this.application, MasterViewSupport.this.cpuSettingsSupport.getSettings());
                            }
                        });
                    }
                }
            }
        }

        private void handleMemoryProfiling() {
            if (this.internalChange) {
                return;
            }
            if (this.memoryButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.internalChange = false;
                this.memorySettingsSupport.saveSettings();
                if (NetBeansProfiler.getDefaultNB().getProfilingState() == 4) {
                    IDEUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        public void run() {
                            NetBeansProfiler.getDefaultNB().modifyCurrentProfiling(MasterViewSupport.this.memorySettingsSupport.getSettings());
                        }
                    });
                } else {
                    this.disableControlButtons();
                    ProfilerSupport.getInstance().setProfiledApplication(this.application);
                    IDEUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                        public void run() {
                            MasterViewSupport.this.startProfiling(MasterViewSupport.this.application, MasterViewSupport.this.memorySettingsSupport.getSettings());
                        }
                    });
                }
            }
        }

        private void startProfiling(Application application, ProfilingSettings pSettings) {
            Runnable calibrationStartUpdater = new Runnable(){

                public void run() {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_calibration_progress"));
                        }
                    });
                }
            };
            Runnable calibrationEndUpdater = new Runnable(){

                public void run() {
                }
            };
            if (ProfilerSupport.getInstance().checkJDKCalibration(application, calibrationStartUpdater, calibrationEndUpdater)) {
                NetBeansProfiler.getDefaultNB().attachToApp(pSettings, this.attachSettings);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ProfilerSupport.getInstance().setProfiledApplication(null);
                        MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_inactive"));
                        MasterViewSupport.this.resetControlButtons();
                        MasterViewSupport.this.enableControlButtons();
                    }
                });
            }
        }

        private void handleStopProfiling() {
            if (this.internalChange) {
                return;
            }
            this.disableControlButtons();
            IDEUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                public void run() {
                    ProfilerSupport.getInstance().setProfiledApplication(null);
                    NetBeansProfiler.getDefaultNB().detachFromApp();
                }
            });
        }

        public void profilingStateChanged(ProfilingStateEvent e) {
            this.refreshStatus();
        }

        public void threadsMonitoringChanged() {
            this.refreshStatus();
        }

        public void instrumentationChanged(int oldInstrType, int currentInstrType) {
            this.refreshStatus();
        }

        private synchronized void refreshStatus() {
            int newState = NetBeansProfiler.getDefaultNB().getProfilingState();
            final Application profiledApplication = ProfilerSupport.getInstance().getProfiledApplication();
            if (this.state != newState) {
                this.state = newState;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        switch (MasterViewSupport.this.state) {
                            case 1: {
                                ProfilerSupport.getInstance().setProfiledApplication(null);
                                MasterViewSupport.this.lastInstrValue = -1;
                                if (MasterViewSupport.this.applicationTerminated) break;
                                MasterViewSupport.this.timer.stop();
                                MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_inactive"));
                                MasterViewSupport.this.resetControlButtons();
                                RequestProcessor.getDefault().post(new Runnable(){

                                    public void run() {
                                        MasterViewSupport.this.enableControlButtons();
                                        MasterViewSupport.this.enableSettings();
                                    }
                                }, 500);
                                break;
                            }
                            case 2: {
                                MasterViewSupport.this.timer.stop();
                                MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_started"));
                                break;
                            }
                            case 8: {
                                MasterViewSupport.this.timer.stop();
                                MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_paused"));
                                break;
                            }
                            case 128: {
                                MasterViewSupport.this.timer.stop();
                                MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_refreshing"));
                                MasterViewSupport.this.disableControlButtons();
                                MasterViewSupport.this.disableSettings();
                                break;
                            }
                            case 4: {
                                if (MasterViewSupport.this.application.equals((Object)profiledApplication)) {
                                    MasterViewSupport.this.updateRunningText();
                                    MasterViewSupport.this.timer.start();
                                    MasterViewSupport.this.enableControlButtons();
                                    MasterViewSupport.this.updateControlButtons();
                                    MasterViewSupport.this.disableSettings();
                                    MasterViewSupport.this.profilingResultsView.setProfilingResultsDisplay(MasterViewSupport.getLiveResultsView());
                                } else {
                                    MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_of") + DataSourceDescriptorFactory.getDescriptor((DataSource)profiledApplication).getName() + NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_in_progress"));
                                    MasterViewSupport.this.disableControlButtons();
                                    MasterViewSupport.this.profilingResultsView.setProfilingResultsDisplay(null);
                                }
                                MasterViewSupport.this.profilingResultsView.revalidate();
                                MasterViewSupport.this.profilingResultsView.repaint();
                                MasterViewSupport.this.revalidate();
                                MasterViewSupport.this.repaint();
                                break;
                            }
                            case 16: {
                                MasterViewSupport.this.timer.stop();
                                MasterViewSupport.this.statusValueLabel.setText(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_stopped"));
                            }
                        }
                    }
                });
            }
        }

        private void updateRunningText() {
            int currentProfilingType;
            ProfilingSettings currentSettings = NetBeansProfiler.getDefaultNB().getLastProfilingSettings();
            int n = currentProfilingType = currentSettings != null ? currentSettings.getProfilingType() : Integer.MIN_VALUE;
            if (this.cpuSettingsSupport.getSettings().getProfilingType() == currentProfilingType) {
                int instrValue = TargetAppRunner.getDefault().getProfilingSessionStatus().getNInstrMethods();
                if (this.lastInstrValue != instrValue) {
                    this.statusValueLabel.setText(MessageFormat.format(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_methods"), instrValue));
                }
                this.lastInstrValue = instrValue;
            } else if (this.memorySettingsSupport.getSettings().getProfilingType() == currentProfilingType) {
                int instrValue = TargetAppRunner.getDefault().getProfilingSessionStatus().getNInstrClasses();
                if (this.lastInstrValue != instrValue) {
                    int allocEvery = currentSettings.getAllocTrackEvery();
                    switch (allocEvery) {
                        case 1: {
                            this.statusValueLabel.setText(MessageFormat.format(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_1"), instrValue, allocEvery));
                            break;
                        }
                        case 2: {
                            this.statusValueLabel.setText(MessageFormat.format(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_2"), instrValue, allocEvery));
                            break;
                        }
                        case 3: {
                            this.statusValueLabel.setText(MessageFormat.format(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_3"), instrValue, allocEvery));
                            break;
                        }
                        default: {
                            this.statusValueLabel.setText(MessageFormat.format(NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_profiling_running_classes_N"), instrValue, allocEvery));
                        }
                    }
                }
                this.lastInstrValue = instrValue;
            }
        }

        private void enableSettings() {
            this.cpuSettingsSupport.setUIEnabled(true);
            this.memorySettingsSupport.setUIEnabled(true);
        }

        private void disableSettings() {
            this.cpuSettingsSupport.setUIEnabled(false);
            this.memorySettingsSupport.setUIEnabled(false);
        }

        private void resetControlButtons() {
            this.internalChange = true;
            this.cpuButton.setSelected(false);
            this.memoryButton.setSelected(false);
            this.internalChange = false;
        }

        private void updateControlButtons() {
            int currentProfilingType;
            ProfilingSettings currentSettings = NetBeansProfiler.getDefaultNB().getLastProfilingSettings();
            int n = currentProfilingType = currentSettings != null ? currentSettings.getProfilingType() : Integer.MIN_VALUE;
            if (this.cpuSettingsSupport.getSettings().getProfilingType() == currentProfilingType && !this.cpuButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(true);
                this.memoryButton.setSelected(false);
                this.internalChange = false;
            } else if (this.memorySettingsSupport.getSettings().getProfilingType() == currentProfilingType && !this.memoryButton.isSelected()) {
                this.internalChange = true;
                this.cpuButton.setSelected(false);
                this.memoryButton.setSelected(true);
                this.internalChange = false;
            }
        }

        private void enableControlButtons() {
            boolean enabled = this.application.getState() == 1;
            this.cpuButton.setEnabled(enabled);
            this.memoryButton.setEnabled(enabled);
            this.stopButton.setEnabled(NetBeansProfiler.getDefaultNB().getTargetAppRunner().targetAppIsRunning());
        }

        private void disableControlButtons() {
            this.cpuButton.setEnabled(false);
            this.memoryButton.setEnabled(false);
            this.stopButton.setEnabled(false);
        }

        private void initSettings() {
            this.attachSettings = new AttachSettings();
            this.attachSettings.setDirect(false);
            this.attachSettings.setDynamic16(true);
            this.attachSettings.setPid(this.application.getPid());
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            JPanel controlPanel = new JPanel();
            controlPanel.setOpaque(false);
            controlPanel.setLayout(new GridBagLayout());
            controlPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 3, 0));
            this.classShareWarningArea = new HTMLTextArea(){

                protected void showURL(URL url) {
                    try {
                        DesktopUtils.browse((URI)url.toURI());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            this.classShareWarningArea.setOpaque(true);
            this.classShareWarningArea.setBackground(new Color(255, 180, 180));
            this.classShareWarningArea.setForeground(new Color(0, 0, 0));
            this.classShareWarningArea.setBorder(BorderFactory.createLineBorder(new Color(180, 180, 180)));
            this.classShareWarningArea.setBorder((Border)BorderFactory.createCompoundBorder(this.classShareWarningArea.getBorder(), BorderFactory.createMatteBorder(5, 5, 5, 5, this.classShareWarningArea.getBackground())));
            this.classShareWarningArea.setVisible(this.classSharingBreaksProfiling);
            if (this.classSharingBreaksProfiling) {
                String link = DesktopUtils.isBrowseAvailable() ? NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Class_Sharing_Link") : NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Class_Sharing_Nolink");
                String message = NbBundle.getMessage(ApplicationProfilerView.class, (String)"MSG_Class_Sharing", (Object)link);
                this.classShareWarningArea.setText(message);
            }
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 0;
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 10, 8);
            controlPanel.add((Component)this.classShareWarningArea, constraints);
            this.modeLabel = new JLabel(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Profile"));
            this.modeLabel.setFont(this.modeLabel.getFont().deriveFont(1));
            this.modeLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.modeLabel, constraints);
            this.cpuButton = new OneWayToggleButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Cpu"));
            this.cpuButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/profiler/resources/cpu.png", (boolean)true)));
            this.cpuButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MasterViewSupport.this.handleCPUProfiling();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.cpuButton, constraints);
            this.memoryButton = new OneWayToggleButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Memory"));
            this.memoryButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/profiler/resources/memory.png", (boolean)true)));
            this.memoryButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MasterViewSupport.this.handleMemoryProfiling();
                }
            });
            constraints = new GridBagConstraints();
            constraints.gridx = 3;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.memoryButton, constraints);
            this.stopButton = new JButton(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Stop"));
            this.stopButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/sun/tools/visualvm/profiler/resources/stop.png", (boolean)true)));
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    MasterViewSupport.this.handleStopProfiling();
                }
            });
            this.stopButton.setEnabled(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 4;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(4, 8, 0, 0);
            controlPanel.add((Component)this.stopButton, constraints);
            JPanel filler1 = new JPanel(new BorderLayout());
            filler1.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 5;
            constraints.gridy = 2;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            controlPanel.add((Component)filler1, constraints);
            this.statusLabel = new JLabel(NbBundle.getMessage(ApplicationProfilerView.class, (String)"LBL_Status"));
            this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(1));
            this.statusLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 3;
            constraints.gridwidth = 1;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(6, 8, 4, 0);
            controlPanel.add((Component)this.statusLabel, constraints);
            this.statusValueLabel = new HTMLLabel(){

                public void setText(String text) {
                    super.setText("<nobr>" + text + "</nobr>");
                }

                protected void showURL(URL url) {
                    ProfilerSupport.getInstance().selectActiveProfilerView();
                }

                public Dimension getPreferredSize() {
                    return new Dimension(super.getPreferredSize().width, refLabelHeight);
                }

                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.statusValueLabel.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = 3;
            constraints.gridwidth = 0;
            constraints.fill = 0;
            constraints.anchor = 17;
            constraints.insets = new Insets(6, 8, 4, 8);
            controlPanel.add((Component)this.statusValueLabel, constraints);
            JPanel filler2 = new JPanel(new BorderLayout());
            filler2.setOpaque(false);
            constraints = new GridBagConstraints();
            constraints.gridx = 2;
            constraints.gridy = 3;
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridwidth = 0;
            constraints.fill = 1;
            constraints.anchor = 18;
            constraints.insets = new Insets(0, 0, 0, 0);
            controlPanel.add((Component)filler2, constraints);
            Dimension cpuD = this.cpuButton.getPreferredSize();
            Dimension memoryD = this.memoryButton.getPreferredSize();
            Dimension stopD = this.stopButton.getPreferredSize();
            Dimension maxD = new Dimension(Math.max(cpuD.width, memoryD.width), Math.max(cpuD.height, memoryD.height));
            maxD = new Dimension(Math.max(maxD.width, stopD.width), Math.max(maxD.height, stopD.height));
            this.cpuButton.setPreferredSize(maxD);
            this.cpuButton.setMinimumSize(maxD);
            this.memoryButton.setPreferredSize(maxD);
            this.memoryButton.setMinimumSize(maxD);
            this.stopButton.setPreferredSize(maxD);
            this.stopButton.setMinimumSize(maxD);
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.add((Component)controlPanel, "Center");
        }
    }
}

