/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.utilities;

import com.ibm.odcb.jrender.mediators.DynamicMediator;
import com.ibm.odcb.jrender.mediators.MappingsMerger;
import com.ibm.odcb.jrender.mediators.gen.EcoreLoader;
import com.ibm.odcb.jrender.mediators.gen.MappingsParser;
import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EFeatureMap;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.ODCClassLoader;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.StringUtil;
import com.ibm.odcb.jrender.misc.TypesUtil;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMapGen {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MERGE_ARG = "-merge";
    public static final String ROOT_ARG = "-root";
    public static final String ACCESS_METHOD_NEEDED = "CUSTOM_JAVA_CODE_FRAGMENT_NEEDED";
    static /* synthetic */ Class array$Ljava$lang$Object;
    static /* synthetic */ Class class$java$lang$Object;

    public static void main(String[] stringArray) {
        Streamer.ForceStdErr();
        Streamer.StartThread();
        Streamer.status.Header().println("USAGE: EMapGen <source path> <build path> <full file name for a .ecore file> -root <root_eclass_name> { <eclass_name> <java_class_name> )*  {-merge <merge_EMap_file>}").Header().println("EMapGen utility:\n     If no list of <eclass name> <java class name> pairs is provided, the Java bean is assumed to be a WDO and the entire ECore will be mapped.\n     \"-root\" indicates the name of the EClass that acts as the root class for the ECore. That class must be mapped thereafter.\n     If the optional \"-merge\" feature is used, the new EMap generated will retain any previous customizations to the EMap.\n     If an EMap file name is provided, the custom mappings from this file will be used. \n     If the EMap file name is omitted, the utility will look for an emap file with the same name as the target EMap.\n     If the EMap file to merge is not found, a new EMap will be created without merging.\n     The -merge feature is false by default.");
        Params params = new Params();
        if (params.Parse(stringArray)) {
            try {
                EMapGen.Process(params);
            }
            catch (Exception exception) {
                Streamer.error.Header().printStackTrace(exception);
            }
        }
        Streamer.status.Header().println("WDO4JSEMapGen ended.");
        Streamer.EndThread();
    }

    public static void Process(Params params) throws Exception {
        WDO4JSMappings wDO4JSMappings = EMapGen.loadEcore(params._EcoreFileName);
        EPackage ePackage = (EPackage)wDO4JSMappings.getEPackagesIterator().next();
        params._Mappings = EMapGen.initParams(params._Mappings, ePackage);
        String string = params._EcoreFileName.substring(0, params._EcoreFileName.length() - 6) + ".emap";
        Streamer.status.Header().println("EMapGen: Creating the matching EMap file '" + string + "' and merging with mappings from EMap file '." + params._EmapFileNameToMerge + "'");
        Streamer.debug.Header().println("EMapGen: Creating EClassMaps");
        HashMap hashMap = EMapGen.createEClassMaps(ePackage, params._Mappings, string, params._SourcePath);
        if (params._EmapFileNameToMerge != null) {
            Streamer.debug.Header().println("EMapGen: Trying to merge with the existing EMap file '" + params._EmapFileNameToMerge + "'");
            EMapGen.mergeWithExistingEMapFile(hashMap, params._EmapFileNameToMerge);
        }
        Streamer.debug.Header().println("EMapGen: Making backups of any existing emaps");
        EMapGen.MakeBackups(string);
        Streamer.status.Header().println("EMapGen: Writing EMap to file");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
        printWriter = EMapGen.writeEMap(printWriter, ePackage.getName(), params._RootEClassName, hashMap.values().iterator());
        printWriter.close();
        Streamer.status.Header().println("EMapGen: EMap generation successfully completed for: '" + string + "'.");
    }

    private static WDO4JSMappings loadEcore(String string) {
        Streamer.debug.Header().println("EMapGen: Looking at '" + string + "' and attempting to create a matching EMap file");
        Streamer.status.Header().println("EMapGen: Reading the EPackage in file '" + string + "'.");
        URI uRI = URI.createFileURI((String)string);
        Streamer.debug.Header().println("EMapGen: Creating local universe");
        WDO4JSMappings wDO4JSMappings = new WDO4JSMappings();
        EcoreLoader ecoreLoader = new EcoreLoader(wDO4JSMappings);
        boolean bl = ecoreLoader.load(uRI);
        if (!bl) {
            Streamer.error.Header().println("EMapGen: Cannot load the EPackage from file '" + string + "'.");
            return null;
        }
        Streamer.status.Header().println("EMapGen: Successfully loaded the EPackage from file '" + string + "'.");
        return wDO4JSMappings;
    }

    public static Map initParams(Map hashMap, EPackage ePackage) {
        if (hashMap == null || hashMap.size() == 0) {
            hashMap = new HashMap<String, String>(11);
            Iterator iterator = ePackage.getEClassifiers().iterator();
            while (iterator.hasNext()) {
                EClass eClass = (EClass)iterator.next();
                hashMap.put(eClass.getName(), DynamicMediator.MakeComplexName(ePackage.getName(), eClass.getName()));
            }
        }
        return hashMap;
    }

    public static HashMap createEClassMaps(EPackage ePackage, Map map, String string, String string2) {
        Streamer.debug.Header().println("EMapGen: Parsing the resource name of the EMap file '" + string + "'");
        String string3 = EMapGen.parseEMapResourceName(string, string2);
        Streamer.debug.Header().println("EMapGen: The resource name of the EMap file is '" + string3 + "'");
        HashMap<String, EClassMap> hashMap = new HashMap<String, EClassMap>();
        EList eList = ePackage.getEClassifiers();
        int n = 0;
        while (n < eList.size()) {
            EClassMap eClassMap;
            EClass eClass = (EClass)eList.get(n);
            String string4 = (String)map.get(eClass.getName());
            Streamer.debug.Header().println("Mapping for EClass '" + eClass.getName() + "' is '" + string4 + "'.");
            if (string4 != null && (eClassMap = EMapGen.createEClassMap(string4, eClass, string, string3, map)) != null) {
                hashMap.put(eClassMap.getExport(), eClassMap);
            }
            ++n;
        }
        return hashMap;
    }

    private static EClassMap createEClassMap(String string, EClass eClass, String string2, String string3, Map map) {
        PropertyDescriptor[] propertyDescriptorArray;
        Class clazz;
        boolean bl = DynamicMediator.isComplexNameDynamic(string);
        Streamer.debug.Header().println("EMapGen: Creating EClassMap for '" + eClass.getName() + "'");
        EClassMap eClassMap = new EClassMap(eClass.getEPackage().getName(), eClass.getName(), string, eClass.getEPackage().getName() + "_" + eClass.getName(), string2, string3, true);
        eClassMap.setEClass(eClass);
        try {
            clazz = ODCClassLoader.getClass(eClassMap.getBaseType());
            propertyDescriptorArray = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        }
        catch (Exception exception) {
            Streamer.error.Header().println("Cannot locate the class '" + eClassMap.getBaseType() + "' to create a mapping from.");
            Streamer.error.Header().printStackTrace(exception);
            return null;
        }
        EList eList = eClass.getEAllStructuralFeatures();
        Streamer.debug.Header().println("EMapGen: Creating EFeatureMaps for EClassMap '" + eClass.getName() + "'");
        int n = 0;
        while (n < eList.size()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)eList.get(n);
            boolean bl2 = !eStructuralFeature.isMany();
            String string4 = EMapGen.FindProperty(eStructuralFeature, clazz, propertyDescriptorArray, true);
            String string5 = eStructuralFeature.isChangeable() ? EMapGen.FindProperty(eStructuralFeature, clazz, propertyDescriptorArray, false) : null;
            String string6 = bl ? EMapGen.getWDOFeatureName(eStructuralFeature, eClass.getEPackage().getName()) : eStructuralFeature.getName();
            Streamer.debug.Header().println("EMapGen: Mapped EFeature '" + string6 + "' to getter '" + string4 + "', with iD='" + bl2 + "'.");
            EFeatureMap eFeatureMap = new EFeatureMap(string6, bl2, string4, string5, true);
            eFeatureMap.setEFeature(eStructuralFeature);
            eFeatureMap.setParentMapping(eClassMap);
            eClassMap.addEFeatureMap(eFeatureMap);
            if (bl2) {
                eClassMap.addEIdFeatureMap(eFeatureMap);
            }
            ++n;
        }
        return eClassMap;
    }

    public static String getWDOFeatureName(EStructuralFeature eStructuralFeature, String string) {
        String string2;
        boolean bl = eStructuralFeature instanceof EReference;
        String string3 = eStructuralFeature.getName();
        if (bl && (string2 = eStructuralFeature.getEType().getEPackage().getName()).equals(string)) {
            string3 = string3 + "(" + DynamicMediator.MakeExtraName(string2, TypesUtil.getRealETypeName(eStructuralFeature.getEType())) + ")";
        }
        return string3;
    }

    private static void mergeWithExistingEMapFile(HashMap hashMap, String string) {
        WDO4JSMappings wDO4JSMappings = EMapGen.getEClassMapsforEMapFile(string);
        if (wDO4JSMappings != null) {
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                EClassMap eClassMap = (EClassMap)iterator.next();
                EClassMap eClassMap2 = wDO4JSMappings.getEClassMapByJavaComplexName(eClassMap.getJavaComplexName());
                MappingsMerger.mergeEmaps(eClassMap, eClassMap2);
            }
        } else {
            Streamer.warning.Header().println("EMapGen: Could not merge with the EMap file '" + string + "'.");
            Streamer.warning.Header().println("EMapGen: Creating a new EMap file without merging.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static WDO4JSMappings getEClassMapsforEMapFile(String string) {
        WDO4JSMappings wDO4JSMappings = null;
        Streamer.status.Header().println("EMapGen: Trying to load EMap file '" + string + "'");
        File file = new File(string);
        if (!file.exists()) {
            Streamer.warning.Header().println("EMapGen: The EMap file '" + string + "' does not exist.");
            return wDO4JSMappings;
        }
        wDO4JSMappings = new WDO4JSMappings();
        MappingsParser mappingsParser = new MappingsParser(wDO4JSMappings);
        boolean bl = false;
        try {
            bl = mappingsParser.parse(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            Streamer.status.Header().println("EMapGen: Successfully loaded the EMap from file '" + string + "'.");
            return wDO4JSMappings;
        }
        Streamer.error.Header().println("EMapGen: Cannot load the EMap from file '" + string + "'.");
        return null;
    }

    public static void MakeBackups(String string) {
        File file;
        int n = 8;
        while (n > 0) {
            file = new File(string + "." + n + ".saved");
            if (file.exists()) {
                File file2 = new File(string + "." + (n + 1) + ".saved");
                file2.delete();
                file.renameTo(file2);
            }
            --n;
        }
        file = new File(string);
        if (file.exists()) {
            file.renameTo(new File(string + ".1.saved"));
        }
    }

    public static PrintWriter writeEMap(PrintWriter printWriter, String string, String string2, Iterator iterator) {
        try {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<mappings>");
            printWriter.println("  <EPackage name=\"" + string + "\" root_eclass_name=\"" + string2 + "\">");
            while (iterator.hasNext()) {
                EClassMap eClassMap = (EClassMap)iterator.next();
                Streamer.debug.Header().println("EMapGen: Writing mapping for EClassMap '" + eClassMap.getEClassName() + "' and it's children");
                EMapGen.writeEClassMap(printWriter, eClassMap);
            }
            printWriter.println("  </EPackage>");
            printWriter.println("</mappings>");
        }
        catch (Exception exception) {
            Streamer.error.printStackTrace(exception);
        }
        return printWriter;
    }

    public static String FindProperty(EStructuralFeature eStructuralFeature, Class clazz, PropertyDescriptor[] propertyDescriptorArray, boolean bl) {
        char c;
        String string;
        boolean bl2;
        boolean bl3 = bl2 = (eStructuralFeature.getLowerBound() == 0 || eStructuralFeature.getLowerBound() == 1) && eStructuralFeature.getUpperBound() == 1;
        if (EMFHelper.DataObject_CLASS.isAssignableFrom(clazz)) {
            if (!bl2) {
                return bl ? "getList('" + eStructuralFeature.getName() + "')" : "setList('" + eStructuralFeature.getName() + "', " + "__SET_OBJ__" + ")";
            }
            if (eStructuralFeature instanceof EAttribute) {
                return bl ? TypesUtil.getEDataGet(TypesUtil.getRealETypeName(eStructuralFeature.getEType())) + "('" + eStructuralFeature.getName() + "')" : TypesUtil.getEDataSet(TypesUtil.getRealETypeName(eStructuralFeature.getEType())) + "('" + eStructuralFeature.getName() + "', " + "__SET_OBJ__" + ")";
            }
            if (eStructuralFeature instanceof EReference) {
                return bl ? "get('" + eStructuralFeature.getName() + "')" : "set('" + eStructuralFeature.getName() + "', " + "__SET_OBJ__" + ")";
            }
            Streamer.error.Header().println("The EFeature " + eStructuralFeature.getName() + " for class " + clazz.getClass().getName() + " must be either an EReference or an EAttribute");
            return ACCESS_METHOD_NEEDED;
        }
        String string2 = string = eStructuralFeature.getName();
        String string3 = string;
        int n = 0;
        if (string.charAt(n) == '_') {
            string2 = string.substring(++n);
        }
        c = Character.isLowerCase(c = string.charAt(n)) ? Character.toUpperCase(c) : Character.toLowerCase(c);
        string3 = c + string.substring(n + 1);
        String string4 = TypesUtil.getRealETypeName(eStructuralFeature.getEType());
        String string5 = TypesUtil.getJavaTypeFromEDataType(string4, eStructuralFeature.isMany());
        if (string5 == null) {
            int n2 = 0;
            while (n2 < propertyDescriptorArray.length) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
                if (propertyDescriptor.getName().equals(string) || propertyDescriptor.getName().equals(string2) || propertyDescriptor.getName().equals(string3)) {
                    string5 = propertyDescriptor.getPropertyType() != null ? propertyDescriptor.getPropertyType().getName() : (eStructuralFeature.isMany() ? (array$Ljava$lang$Object == null ? EMapGen.class$("[Ljava.lang.Object;") : array$Ljava$lang$Object).getName() : (class$java$lang$Object == null ? EMapGen.class$("java.lang.Object") : class$java$lang$Object).getName());
                }
                ++n2;
            }
        }
        if (bl) {
            if (EMapGen.TestMethod(clazz, "get" + string, string5, bl)) {
                return "get" + string + "()";
            }
            if (EMapGen.TestMethod(clazz, "get" + string2, string5, bl)) {
                return "get" + string2 + "()";
            }
            if (EMapGen.TestMethod(clazz, "get" + string3, string5, bl)) {
                return "get" + string3 + "()";
            }
            if (EMapGen.TestMethod(clazz, "Get" + string, string5, bl)) {
                return "Get" + string + "()";
            }
            if (EMapGen.TestMethod(clazz, "Get" + string2, string5, bl)) {
                return "Get" + string2 + "()";
            }
            if (EMapGen.TestMethod(clazz, "Get" + string3, string5, bl)) {
                return "Get" + string3 + "()";
            }
            if (EMapGen.TestMethod(clazz, "is" + string, string5, bl)) {
                return "is" + string + "()";
            }
            if (EMapGen.TestMethod(clazz, "is" + string2, string5, bl)) {
                return "is" + string2 + "()";
            }
            if (EMapGen.TestMethod(clazz, "is" + string3, string5, bl)) {
                return "is" + string3 + "()";
            }
            if (EMapGen.TestMethod(clazz, "Is" + string, string5, bl)) {
                return "Is" + string + "()";
            }
            if (EMapGen.TestMethod(clazz, "Is" + string2, string5, bl)) {
                return "Is" + string2 + "()";
            }
            if (EMapGen.TestMethod(clazz, "Is" + string3, string5, bl)) {
                return "Is" + string3 + "()";
            }
        } else {
            if (EMapGen.TestMethod(clazz, "set" + string, string5, bl)) {
                return "set" + string + "(" + "__SET_OBJ__" + ")";
            }
            if (EMapGen.TestMethod(clazz, "set" + string2, string5, bl)) {
                return "set" + string2 + "(" + "__SET_OBJ__" + ")";
            }
            if (EMapGen.TestMethod(clazz, "set" + string3, string5, bl)) {
                return "set" + string3 + "(" + "__SET_OBJ__" + ")";
            }
            if (EMapGen.TestMethod(clazz, "Set" + string, string5, bl)) {
                return "Set" + string + "(" + "__SET_OBJ__" + ")";
            }
            if (EMapGen.TestMethod(clazz, "Set" + string2, string5, bl)) {
                return "Set" + string2 + "(" + "__SET_OBJ__" + ")";
            }
            if (EMapGen.TestMethod(clazz, "Set" + string3, string5, bl)) {
                return "Set" + string3 + "(" + "__SET_OBJ__" + ")";
            }
        }
        if (EMapGen.TestField(clazz, string, string5)) {
            return bl ? string : string + "=" + "__SET_OBJ__";
        }
        if (EMapGen.TestField(clazz, string2, string5)) {
            return bl ? string2 : string2 + "=" + "__SET_OBJ__";
        }
        if (EMapGen.TestField(clazz, string3, string5)) {
            return bl ? string3 : string3 + "=" + "__SET_OBJ__";
        }
        Streamer.warning.Header().println("Could not find an appropriate " + (bl ? "getter" : "setter") + " in class '" + clazz.getName() + "' for property '" + string + "', '" + string2 + "' or '" + string3 + "' of type '" + string5 + "'");
        return ACCESS_METHOD_NEEDED;
    }

    public static boolean TestMethod(Class clazz, String string, String string2, boolean bl) {
        try {
            Method[] methodArray = clazz.getMethods();
            int n = 0;
            while (n < methodArray.length) {
                Method method = methodArray[n];
                if (method.getName().equals(string)) {
                    int n2 = method.getModifiers();
                    if (bl) {
                        return method.getParameterTypes().length == 0 && EMapGen.TestMethodOrField(method.getReturnType().getName(), string2, n2);
                    }
                    return method.getParameterTypes().length == 1 && EMapGen.TestMethodOrField(method.getParameterTypes()[0].getName(), string2, n2);
                }
                ++n;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Streamer.error.Header().printStackTrace(classNotFoundException);
        }
        return false;
    }

    public static boolean TestField(Class clazz, String string, String string2) {
        try {
            Field field = clazz.getField(string);
            int n = field.getModifiers();
            return EMapGen.TestMethodOrField(field.getType().getName(), string2, n);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean TestMethodOrField(String string, String string2, int n) throws ClassNotFoundException {
        if (!(string.equals(string2) || string.equals((class$java$lang$Object == null ? (class$java$lang$Object = EMapGen.class$("java.lang.Object")) : class$java$lang$Object).getName()) || TypesUtil.isGeneralList(string))) {
            return false;
        }
        return !Modifier.isStatic(n) && Modifier.isPublic(n);
    }

    public static String parseEMapResourceName(String string, String string2) {
        String string3 = string;
        try {
            if (string2 != null && string.startsWith(string2)) {
                string3 = string.substring(string2.length());
                if (string3.startsWith("\\") || string3.startsWith("/")) {
                    string3 = string3.substring(1);
                }
                if (string3.indexOf(92) > -1) {
                    string3 = string3.replace('\\', '/');
                }
            }
        }
        catch (Exception exception) {
            Streamer.error.Header().printStackTrace(exception);
        }
        Streamer.debug.Header().println("ResourceURI of EMap file '" + string + "' is '" + string3 + "'");
        return string3;
    }

    private static PrintWriter writeEClassMap(PrintWriter printWriter, EClassMap eClassMap) {
        printWriter.println("    <EClassMap app_class=\"" + eClassMap.getJavaComplexName() + "\" eclass_name=\"" + eClassMap.getEClassName() + "\" export=\"" + eClassMap.getExport() + "\" " + "diff_on_refresh" + "=\"" + eClassMap.isDiffOnRefresh() + "\">");
        Iterator iterator = eClassMap.getEFeatureMapIterator();
        while (iterator.hasNext()) {
            EFeatureMap eFeatureMap = (EFeatureMap)iterator.next();
            if (eFeatureMap.isCalculateAttribute()) {
                EMapGen.writeClientFeatureMap(printWriter, eFeatureMap);
                continue;
            }
            EMapGen.writeEFeatureMap(printWriter, eFeatureMap);
        }
        printWriter.println("    </EClassMap>");
        return printWriter;
    }

    public static PrintWriter writeEFeatureMap(PrintWriter printWriter, EFeatureMap eFeatureMap) {
        String string = eFeatureMap.getEFeatureName();
        if (eFeatureMap.getExtraTargetType() != null) {
            string = string + "(" + eFeatureMap.getExtraTargetType() + ")";
        }
        boolean bl = TypesUtil.isUnsupportedType(eFeatureMap.getGetter());
        printWriter.println((bl ? "<!--  " : "      ") + "<EFeatureMap efeature_name=\"" + string + "\" iD=\"" + eFeatureMap.isID() + "\" get=\"" + eFeatureMap.getGetter() + (eFeatureMap.getSetter() == null ? "" : "\" set=\"" + eFeatureMap.getSetter()) + (bl ? "\" />   -->" : "\" />"));
        return printWriter;
    }

    public static PrintWriter writeClientFeatureMap(PrintWriter printWriter, EFeatureMap eFeatureMap) {
        String string = StringUtil.QuoteDoubleAndEscapeForXML(eFeatureMap.getCalculateExpression(), false, true);
        printWriter.println("      <CalculateAttribute attribute_name=\"" + eFeatureMap.getEFeatureName() + "\" expression=" + string + " type=\"" + eFeatureMap.getCalculatedType() + "\" iD=\"false\" />");
        return printWriter;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Params {
        public String _SourcePath = null;
        public String _BuildPath = null;
        public String _EcoreFileName = null;
        public String _RootEClassName = null;
        public Map _Mappings = null;
        public String _EmapFileNameToMerge = null;

        /*
         * Unable to fully structure code
         */
        public boolean Parse(String[] var1_1) {
            if (var1_1.length < 3) {
                Streamer.error.Header().println("This program was called with an incorrect number of parameters.");
                return false;
            }
            this._SourcePath = var1_1[0];
            this._BuildPath = var1_1[1];
            var2_2 = var1_1[2].lastIndexOf(".ecore");
            if (var2_2 == -1 || var2_2 != var1_1[2].length() - 6) {
                Streamer.error.Header().println("The filename supplied '" + var1_1[2] + "' is incorrect. Expected a filename ending in '.ecore'.");
                return false;
            }
            this._EcoreFileName = var1_1[2];
            var3_3 = 3;
            if (var3_3 >= var1_1.length || !var1_1[var3_3].equalsIgnoreCase("-root")) ** GOTO lbl22
            if (++var3_3 < var1_1.length) {
                this._RootEClassName = var1_1[var3_3];
                ++var3_3;
            } else {
                Streamer.error.Header().println("We found a -root without a follow-up parameter");
                return false;
lbl22:
                // 1 sources

                Streamer.error.Header().println("The -root parameter is mandatory, but could not be found.");
                return false;
            }
            this._Mappings = new HashMap<K, V>(7);
            while (var3_3 < var1_1.length) {
                if (var1_1[var3_3].equalsIgnoreCase("-merge")) break;
                if (var3_3 >= var1_1.length - 1) {
                    Streamer.error.Header().println("The EClassName parameter '" + var1_1[var3_3] + "' is the last parameter. It should be followed by an JavaClassName paramater.");
                    return false;
                }
                this._Mappings.put(var1_1[var3_3].replace('$', '_'), var1_1[var3_3 + 1]);
                var3_3 += 2;
            }
            if (var3_3 < var1_1.length) {
                if (var1_1[var3_3].equalsIgnoreCase("-merge")) {
                    if (++var3_3 < var1_1.length) {
                        this._EmapFileNameToMerge = var1_1[var3_3];
                    } else {
                        this.MakeDefaultEMapMerge();
                    }
                } else {
                    Streamer.error.Header().println("The parameter '" + var1_1[var3_3] + "' is unexpected. We should either have -merge, or the end of the parameter list.");
                    return false;
                }
            }
            return true;
        }

        public void MakeDefaultEMapMerge() {
            int n = this._EcoreFileName.lastIndexOf(".ecore");
            this._EmapFileNameToMerge = this._EcoreFileName.substring(0, n) + ".emap";
        }
    }
}

