/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.misc;

import com.ibm.odcb.jrender.misc.ODCClassLoader;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.MissingResourceException;
import java.util.Properties;

public class Config {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final PROPERTY PROP_ECORE_FILES = new PROPERTY("ECORE_FILES");
    public static final PROPERTY PROP_EMAP_FILES = new PROPERTY("EMAP_FILES");
    public static final PROPERTY PROP_CLIENT_LOCALE = new PROPERTY("CLIENT_LOCALE");
    public static final PROPERTY PROP_CLIENT_DEBUG_MODE = new PROPERTY("CLIENT_DEBUG_MODE");
    public static final PROPERTY PROP_CLIENT_LOG_LEVEL = new PROPERTY("CLIENT_LOG_LEVEL");
    public static final PROPERTY PROP_SERVER_LOG_LEVEL = new PROPERTY("SERVER_LOG_LEVEL");
    public static final PROPERTY PROP_MEDIATOR_DEBUG_MODE = new PROPERTY("MEDIATOR_DEBUG_MODE");
    public static final PROPERTY PROP_SERVER_LOG_FILENAME = new PROPERTY("SERVER_LOG_FILENAME");
    public static final PROPERTY PROP_REQUEST_CLASS = new PROPERTY("REQUEST_CLASS");
    public static final PROPERTY PROP_PROGRESSBAR = new PROPERTY("PROGRESSBAR");
    public static final PROPERTY PROP_PATH_PREFIX = new PROPERTY("PATH_PREFIX");
    public static final PROPERTY PROP_SYSTEM_ECORE_FILES = new PROPERTY("SYSTEM_ECORE_FILES");
    protected static String PROPERTIES_FILE_NAME = "OdysseyBrowserFramework.properties";
    protected static boolean IS_RESOURCE = true;
    protected static Properties _Props = Config.InternalInit();

    protected static synchronized Properties InternalInit() {
        try {
            InputStream inputStream = IS_RESOURCE ? ODCClassLoader.getResourceAsStream(PROPERTIES_FILE_NAME) : new FileInputStream(PROPERTIES_FILE_NAME);
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            return properties;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void ChangePropertiesFileAndReInit(String string, boolean bl) {
        PROPERTIES_FILE_NAME = string;
        IS_RESOURCE = bl;
        Config.ReInit();
    }

    public static boolean ReInit() {
        _Props = Config.InternalInit();
        return _Props != null;
    }

    public static final int getInteger(PROPERTY pROPERTY) throws MissingResourceException, NumberFormatException {
        try {
            String string = _Props.getProperty(pROPERTY.toString());
            if (string == null) {
                throw new MissingResourceException("Missing property", PROPERTIES_FILE_NAME, pROPERTY.toString());
            }
            return Integer.parseInt(string);
        }
        catch (MissingResourceException missingResourceException) {
            Streamer.error.Header().print("Missing mandatory resource ").println(pROPERTY).printStackTrace(missingResourceException);
            throw missingResourceException;
        }
        catch (NumberFormatException numberFormatException) {
            Streamer.error.Header().print("Resource ").print(pROPERTY).println(" does not seem to be an Integer").printStackTrace(numberFormatException);
            throw numberFormatException;
        }
    }

    public static final int getInteger(PROPERTY pROPERTY, int n) throws MissingResourceException, NumberFormatException {
        try {
            String string = _Props.getProperty(pROPERTY.toString());
            if (string == null) {
                throw new MissingResourceException("Missing property", PROPERTIES_FILE_NAME, pROPERTY.toString());
            }
            return Integer.parseInt(string);
        }
        catch (MissingResourceException missingResourceException) {
            Streamer.debug.Header().print("Missing optional resource ").print(pROPERTY).print(". Returning supplied default value ").println(n);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            Streamer.error.Header().print("Resource ").print(pROPERTY).println(" does not seem to be an Integer").printStackTrace(numberFormatException);
            throw numberFormatException;
        }
    }

    public static final String getString(PROPERTY pROPERTY) throws MissingResourceException {
        try {
            String string = _Props.getProperty(pROPERTY.toString());
            if (string == null) {
                throw new MissingResourceException("Missing property", PROPERTIES_FILE_NAME, pROPERTY.toString());
            }
            return string;
        }
        catch (MissingResourceException missingResourceException) {
            Streamer.error.Header().print("Missing mandatory resource ").println(pROPERTY).printStackTrace(missingResourceException);
            throw missingResourceException;
        }
    }

    public static final String getString(PROPERTY pROPERTY, String string) throws MissingResourceException {
        try {
            String string2 = _Props.getProperty(pROPERTY.toString());
            if (string2 == null) {
                throw new MissingResourceException("Missing property", PROPERTIES_FILE_NAME, pROPERTY.toString());
            }
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            Streamer.debug.Header().print("Missing optional resource ").print(pROPERTY).print(". Returning supplied default value ").println(string);
            return string;
        }
    }

    public static final String getStringDecrypted(PROPERTY pROPERTY, String string) throws MissingResourceException {
        return Config.getString(pROPERTY);
    }

    protected static final int getIntegerSilent(PROPERTY pROPERTY, int n) {
        try {
            String string = _Props.getProperty(pROPERTY.toString());
            if (string == null) {
                throw new MissingResourceException("Missing property", PROPERTIES_FILE_NAME, pROPERTY.toString());
            }
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static final String getStringSilent(PROPERTY pROPERTY) {
        try {
            String string = _Props.getProperty(pROPERTY.toString());
            if (string == null) {
                throw new MissingResourceException("Missing property", PROPERTIES_FILE_NAME, pROPERTY.toString());
            }
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class PROPERTY {
        protected String _N;

        PROPERTY(String string) {
            this._N = string;
        }

        public String toString() {
            return this._N;
        }
    }
}

