/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen.ecore;

import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.IntWrapper;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.TypesUtil;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EFeatureMap {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String SET_TOKEN = "X";
    public static final String XMI_ID_FEATURE = "xmi:id";
    public static final String ODYSSEY_STATUS_FEATURE = "ODCstatus";
    public static final String ODYSSEY_ID_FEATURE = "ODCid";
    public static final String[] OBF_RESERVED_NAMES = new String[]{"ODCid", "ODCstatus"};
    protected EStructuralFeature _EFeature = null;
    protected String _EFeatureName;
    protected String _ExtraTargetType;
    protected boolean _ID = false;
    protected boolean _Reference = false;
    protected String _Getter = null;
    protected String _GetterType = null;
    protected Class _GetterTypeClass = null;
    protected String _Setter = null;
    protected EClassMap _ReferenceMap = null;
    protected boolean _Containment = false;
    protected EClassMap _ParentMapping;
    protected String _CalculateExpression;
    protected String _CalculatedType;
    public static final String __SETTER_PARAM_MARKER = "__SET_OBJ__";

    public EFeatureMap(String string, boolean bl, String string2, String string3, boolean bl2) {
        String[] stringArray = EClassMap.ParseComplexName(string);
        this._EFeatureName = stringArray[0];
        this._ExtraTargetType = stringArray[1];
        this._ID = bl;
        this._Getter = string2;
        this._Setter = string3;
    }

    protected EFeatureMap(String string, boolean bl, String string2, String string3) {
        this._EFeatureName = string;
        this._ID = bl;
        this._CalculateExpression = string2;
        this._CalculatedType = string3;
    }

    public String getEFeatureName() {
        return this._EFeatureName;
    }

    public String getExport() {
        return this._EFeatureName;
    }

    public String getGetter() {
        return this._Getter;
    }

    public String getGetterType() {
        return this._GetterType;
    }

    public Class getGettterTypeClass() {
        return this._GetterTypeClass;
    }

    public String getSetter() {
        return this._Setter;
    }

    public boolean isMany() {
        return this._EFeature == null ? false : this._EFeature.isMany();
    }

    public EStructuralFeature getEFeature() {
        return this._EFeature;
    }

    public void setEFeature(EStructuralFeature eStructuralFeature) {
        this._EFeature = eStructuralFeature;
    }

    public EClassMap getParentMapping() {
        return this._ParentMapping;
    }

    public void setParentMapping(EClassMap eClassMap) {
        this._ParentMapping = eClassMap;
    }

    public String getExtraTargetType() {
        return this._ExtraTargetType;
    }

    public void setExtraTargetType(String string) {
        this._ExtraTargetType = string;
    }

    public String getEFeatureType() {
        return this._EFeature != null ? TypesUtil.getRealETypeName(this._EFeature.getEType()) : null;
    }

    public EClassMap getReferenceMap() {
        return this._ReferenceMap;
    }

    public boolean isCalculateAttribute() {
        return this._CalculateExpression != null;
    }

    public String getCalculateExpression() {
        return this._CalculateExpression;
    }

    public void setCalculateExpression(String string) {
        this._CalculateExpression = string;
    }

    public String getCalculatedType() {
        return this._CalculatedType;
    }

    public void setCalculatedType(String string) {
        this._CalculatedType = string;
    }

    public boolean isID() {
        return this._ID;
    }

    public boolean isReference() {
        return this._Reference;
    }

    public void setID(boolean bl) {
        this._ID = bl;
    }

    public void setReference(boolean bl) {
        this._Reference = bl;
    }

    public void setGet(String string) {
        this._Getter = string;
    }

    public void setSetter(String string) {
        this._Setter = string;
    }

    public boolean Verify(EClassMap eClassMap, WDO4JSMappings wDO4JSMappings, IntWrapper intWrapper) {
        EReference eReference;
        boolean bl = true;
        if (this._EFeatureName == null || this._EFeatureName.trim().length() == 0) {
            intWrapper.increment();
            Streamer.error.Header().println("An EFeatureMap was defined with an empty EAttributeName in EClassMap '" + eClassMap.getExport() + "'. This is not supported.");
            return false;
        }
        boolean bl2 = bl = !EFeatureMap.isOBFReservedName(this._EFeatureName);
        if (!bl) {
            intWrapper.increment();
            Streamer.error.Header().println("EFeatureMap name '" + this._EFeatureName + "' is an OBF Reserved name.  It cannot be used as feature names in OBF systems.  Please rename your feature and try again.  Following are OBF Reserved Names: " + EFeatureMap.getOBFReservedNames());
            return false;
        }
        this._EFeature = eClassMap.getEStructuralFeatureByName(this._EFeatureName);
        if (this._EFeature == null) {
            intWrapper.increment();
            Streamer.error.Header().println("The efeature_name '" + this._EFeatureName + "' defined for EClassMap with export '" + eClassMap.getExport() + "', was not found in the source EClass '" + eClassMap._EClassName + "'.");
            return false;
        }
        if (this.isMany() && this.isID()) {
            this._ID = false;
            Streamer.warning.Header().println("EAttribute '" + this._EFeatureName + "'' has multiplicity greater than 1, and the iD attribute is set to true.  Attributes with mutliplicity greater than 1 cannot be a primary key.  The iD attribute will be set to FALSE.");
            this.getParentMapping()._EIdFeatureMaps.remove(this);
        }
        if ((eReference = eClassMap.getEReferenceByName(this._EFeatureName)) == null) {
            this._Reference = false;
            this._Containment = false;
        } else {
            this._Reference = true;
            this._Containment = eReference.isContainment();
        }
        this._GetterTypeClass = EFeatureMap.ResolveGetterExpressionType(this._Getter, eClassMap._BaseTypeClass, intWrapper, null);
        if (this._GetterTypeClass == null) {
            intWrapper.increment();
            Streamer.error.Header().println("The java Class for '" + this._Getter + "' was not found.");
            return false;
        }
        this._GetterType = this._GetterTypeClass.getName();
        if (this._Setter != null) {
            int n = this._Setter.indexOf(__SETTER_PARAM_MARKER);
            if (n == -1) {
                Streamer.error.Header().println("Cannot find marker '__SET_OBJ__' in setter '" + this._Setter + "'.");
                intWrapper.increment();
                return false;
            }
            n = this._Setter.indexOf("(");
            if (n == -1) {
                Streamer.error.Header().println("Cannot find '(' in setter '" + this._Setter + "'.");
                intWrapper.increment();
                return false;
            }
            if (!this._ParentMapping.getBaseType().equals(EMFHelper.DataObject_CLASS.getName())) {
                try {
                    Class clazz = eClassMap._BaseTypeClass;
                    Class[] classArray = new Class[]{this._GetterTypeClass};
                    Method method = clazz.getMethod(this._Setter.substring(0, n), classArray);
                }
                catch (Exception exception) {
                    Streamer.warning.Header().println("Setter '" + this._Setter + "' on '" + eClassMap._BaseTypeClass.getName() + "' could not be verified. If this is a setter with more than one argument, then this may be OK.");
                }
            }
        }
        try {
            boolean bl3 = TypesUtil.isGeneralList(this._GetterType);
            if (this.isMany() && !bl3) {
                bl = false;
                intWrapper.increment();
                Streamer.error.Header().println("The type for '" + this._Getter + "' should be List, Collection, Iterator, or an array because it was defined in the model as a multi-cardinality feature.");
            }
            if (!this.isMany() && bl3) {
                bl = false;
                intWrapper.increment();
                Streamer.error.Header().println("The type for '" + this._Getter + "' is List, Collection, Iterator, or an array, but it was defined in the model as a single cardinality feature.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
            intWrapper.increment();
            Streamer.error.Header().printStackTrace(classNotFoundException);
        }
        if (this.isReference()) {
            if (!this.VerifyEReference(eClassMap, wDO4JSMappings, intWrapper)) {
                bl = false;
            }
        } else if (!this.VerifyEAttribute(eClassMap, wDO4JSMappings, intWrapper)) {
            bl = false;
        }
        return bl;
    }

    public static boolean isOBFReservedName(String string) {
        int n = 0;
        while (n < OBF_RESERVED_NAMES.length) {
            if (OBF_RESERVED_NAMES[n].equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getOBFReservedNames() {
        String string = "";
        int n = 0;
        while (n < OBF_RESERVED_NAMES.length) {
            string = string + ", " + OBF_RESERVED_NAMES[n];
            ++n;
        }
        if (string.length() > 2) {
            string = string.substring(2);
        }
        return string;
    }

    public static Class ResolveGetterExpressionType(String string, Class clazz, IntWrapper intWrapper, String string2) {
        while (string != null) {
            int n = string.length();
            int n2 = string.indexOf(46);
            if (n2 == -1) {
                n2 = n;
            }
            String string3 = string.substring(0, n2);
            String string4 = EFeatureMap.ExtractMethodName(string3);
            Method method = null;
            Field field = null;
            if (string4 != null) {
                method = EFeatureMap.getClassMethod(clazz, string4);
            } else {
                field = EFeatureMap.getClassField(clazz, string3);
            }
            if (method == null && field == null) {
                intWrapper.increment();
                return null;
            }
            if (method == null) {
                clazz = field.getType();
            } else if (string2 == null) {
                clazz = method.getReturnType();
            } else {
                int n3 = EFeatureMap.ExtractMethodArg(string3, string2);
                if (n3 != -1) {
                    clazz = method.getParameterTypes()[n3];
                } else {
                    Streamer.error.Header().println("A Setter '" + string + "' for class '" + clazz.getName() + "' does not have a set token '" + string2 + "'.");
                    intWrapper.increment();
                    return null;
                }
            }
            String string5 = string = n2 == n ? null : string.substring(n2 + 1, n);
        }
        return clazz;
    }

    public static Method getClassMethod(Class clazz, String string) {
        Method[] methodArray = clazz.getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (string.equals(methodArray[n].getName())) {
                return methodArray[n];
            }
            ++n;
        }
        Streamer.error.Header().println("Cannot resolve method " + string + " for class " + clazz.getName());
        return null;
    }

    public static Field getClassField(Class clazz, String string) {
        Field[] fieldArray = clazz.getFields();
        int n = 0;
        while (n < fieldArray.length) {
            if (string.equals(fieldArray[n].getName())) {
                return fieldArray[n];
            }
            ++n;
        }
        Streamer.error.Header().println("Cannot resolve field " + string + " for class " + clazz.getName());
        return null;
    }

    public static String ExtractMethodName(String string) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        return n != -1 && n2 != -1 ? string.substring(0, n) : null;
    }

    public static int ExtractMethodArg(String string, String string2) {
        int n;
        int n2 = string.indexOf(40);
        if (n2 >= (n = string.indexOf(41))) {
            return -1;
        }
        String string3 = string.substring(n2 + 1, n);
        int n3 = string3.indexOf(string2);
        if (n3 == -1) {
            return -1;
        }
        int n4 = 0;
        boolean bl = false;
        n2 = 0;
        while (n2 < string3.length()) {
            char c = string3.charAt(n2);
            if (c == '\"') {
                bl = !bl;
            } else if (!bl) {
                if (c == ',') {
                    ++n4;
                } else if (n2 == n3) {
                    boolean bl2;
                    char c2 = n2 == 0 ? (char)' ' : (char)string3.charAt(n2 - 1);
                    char c3 = n2 + string2.length() == string3.length() ? (char)' ' : (char)string3.charAt(n2 + string2.length());
                    boolean bl3 = c2 == ',' || c2 == '(' || Character.isSpaceChar(c2);
                    boolean bl4 = bl2 = c3 == ',' || c3 == ')' || Character.isSpaceChar(c3);
                    if (bl3 && bl2) {
                        return n4;
                    }
                    if ((n3 = string3.indexOf(string2, n3 + 1)) == -1) break;
                }
            }
            ++n2;
        }
        return -1;
    }

    public static String CleanupGetterSetter(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '\'') {
                if (n < stringBuffer.length() - 1 && stringBuffer.charAt(n + 1) == '\'') {
                    stringBuffer.deleteCharAt(n + 1);
                } else {
                    stringBuffer.setCharAt(n, '\"');
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected boolean VerifyEReference(EClassMap eClassMap, WDO4JSMappings wDO4JSMappings, IntWrapper intWrapper) {
        if (!this.isReference()) {
            intWrapper.increment();
            Streamer.error.Header().println("EFeature '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' is supposed to be an EReference, but it is actually an EAttribute.");
            return false;
        }
        if (TypesUtil.isBasicJavaType(this._GetterType) || TypesUtil.isArrayOfBasicJavaType(this._GetterType)) {
            intWrapper.increment();
            Streamer.error.Header().println("EReference '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' has a basic type. EReferences cannot be of basic types.");
            return false;
        }
        if (this._EFeatureName == null || this._EFeatureName.trim().length() == 0) {
            intWrapper.increment();
            Streamer.error.Header().println("An EFeatureMap was defined with an empty EAttributeName in EClassMap '" + eClassMap.getExport() + "'.");
            return false;
        }
        String string = TypesUtil.getRealETypeName(this._EFeature.getEType());
        if (TypesUtil.isBasicEDataType(string)) {
            Streamer.error.Header().println("EReference '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' is of type '" + string + "'.  EReferences of basic types are not supported.");
            intWrapper.increment();
            return false;
        }
        boolean bl = true;
        this._ReferenceMap = wDO4JSMappings.getEClassMapByEPackageAndECoreComplexName(eClassMap.getEPackageName(), string, this._ExtraTargetType);
        if (this._ReferenceMap == null) {
            Streamer.error.Header().println("EReference '" + this._EFeatureName + "' with EType '" + eClassMap.getEPackageName() + "`" + string + "' was not found in the parent's Ecore or the EType is not mapped in the EMap.");
            wDO4JSMappings.PrintEClassMapByEcoreName();
            bl = false;
            intWrapper.increment();
        }
        return bl;
    }

    protected boolean VerifyEAttribute(EClassMap eClassMap, WDO4JSMappings wDO4JSMappings, IntWrapper intWrapper) {
        Object object;
        boolean bl;
        if (this.isReference()) {
            intWrapper.increment();
            Streamer.error.Header().println("EFeature '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' is supposed to be an EAttribute, but it is actually an EReference.");
            return false;
        }
        if (this._EFeatureName == null || this._EFeatureName.trim().length() == 0) {
            intWrapper.increment();
            Streamer.error.Header().println("An EFeatureMap was defined with an empty EAttributeName in EClassMap '" + eClassMap.getExport() + "'.");
            return false;
        }
        String string = TypesUtil.getRealETypeName(this._EFeature.getEType());
        if (!TypesUtil.isBasicEDataType(string)) {
            Streamer.error.Header().println("EFeature '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' is of type '" + string + "'.  EAttributes must be of basic types.");
            intWrapper.increment();
            return false;
        }
        try {
            bl = TypesUtil.isGeneralListNoArrays(this._GetterType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            intWrapper.increment();
            Streamer.error.Header().println("Cannot verify that the class '" + this._GetterType + "' exists");
            Streamer.error.Header().printStackTrace(classNotFoundException);
            return false;
        }
        if (!(TypesUtil.isBasicJavaType(this._GetterType) || TypesUtil.isArrayOfBasicJavaType(this._GetterType) || bl || TypesUtil.isJavaObjectType(this._GetterType, true))) {
            intWrapper.increment();
            Streamer.error.Header().println("EAttribute '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' is of type '" + this._GetterType + "'. EAttribute must be of basic types.");
            return false;
        }
        if (this._EFeature != null && (object = this._EFeature.getEType()) == null) {
            intWrapper.increment();
            Streamer.error.Header().println("UNSUPPORTED EFEATURE: " + this._EFeature.getName() + ".  The EClassifier associated with this feature could not be obtained.");
            return false;
        }
        if (!bl) {
            object = TypesUtil.getJavaTypeFromEDataType(string, this.isMany());
            if (object != null && !this._GetterType.equals(object)) {
                Streamer.warning.Header().println("EAttribute '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' is a '" + this._GetterType + "' that is different from the expected ecore type '" + (String)object + "'. If this is really an error, runtime cast errors will occur.");
            }
        } else {
            Streamer.warning.Header().println("EAttribute '" + this._EFeatureName + "' in EClass '" + eClassMap._EClassName + "' is a '" + this._GetterType + "'. We cannot validate the type of a container. If invalid, runtime cast errors will occur.");
        }
        return true;
    }

    public boolean isContainment() {
        return this._Containment;
    }

    public EReference getEOpposite() {
        if (this.isReference() && this._EFeature != null) {
            return ((EReference)this._EFeature).getEOpposite();
        }
        return null;
    }

    public PrintWriter printXML(PrintWriter printWriter) {
        printWriter.println("      <EFeatureMap efeature_name=\"" + this._EFeatureName + "\" iD=\"" + this._ID + "\" get=\"" + this._Getter + "\" />");
        return printWriter;
    }

    public String MergeSetterCode(String string) {
        String string2 = EFeatureMap.CleanupGetterSetter(this._Setter);
        int n = string2.indexOf(__SETTER_PARAM_MARKER);
        if (n == -1) {
            Streamer.defect.Header().println("Cannot find marker '__SET_OBJ__' in setter '" + this._Setter + "'. This should have been verified.");
            throw new Error("Cannot find marker '__SET_OBJ__' in setter '" + this._Setter + "'.");
        }
        return string2.substring(0, n) + string + string2.substring(n + __SETTER_PARAM_MARKER.length());
    }
}

