/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators.gen;

import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.CalculateAttribute;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EFeatureMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EPackageMap;
import com.ibm.odcb.jrender.misc.SaxBase;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.StringUtil;
import java.io.File;
import java.io.InputStream;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class MappingsParser
extends SaxBase {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String TAG_MAPPINGS = "mappings";
    public static final String TAG_EPACKAGE = "EPackage";
    public static final String TAG_ECLASSMAP = "EClassMap";
    public static final String TAG_EFEATUREMAP = "EFeatureMap";
    public static final String TAG_CALCULATE = "CalculateAttribute";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ROOT_ECLASSNAME = "root_eclass_name";
    public static final String ATTR_ON_UPDATE = "on_update";
    public static final String ATTR_JS_FILE = "js_file";
    public static final String ATTR_APPCLASS = "app_class";
    public static final String ATTR_ECLASS_NAME = "eclass_name";
    public static final String ATTR_EXPORT = "export";
    public static final String ATTR_EFEATURE_NAME = "efeature_name";
    public static final String ATTR_GET = "get";
    public static final String ATTR_SET = "set";
    public static final String ATTR_ID = "iD";
    public static final String ATTR_REFERENCE = "reference";
    public static final String ATTR_DIFF_REFRESH = "diff_on_refresh";
    public static final String ATTR_EXPRESSION = "expression";
    public static final String ATTR_ATTR_NAME = "attribute_name";
    public static final String ATTR_TYPE = "type";
    protected String _SourceEmapName;
    protected WDO4JSMappings _Universe;
    protected EPackageMap _EPM = null;
    protected EClassMap _ECM = null;

    public MappingsParser(WDO4JSMappings wDO4JSMappings) {
        this._Universe = wDO4JSMappings;
    }

    public boolean parse(File file) throws Exception {
        super.Parse(file.getPath());
        if (this.getError() > 0) {
            Streamer.error.Header().println(this.getError() + " error(s) were found parsing '" + file.getPath() + "'.");
            return false;
        }
        return true;
    }

    public boolean parse(InputStream inputStream) throws Exception {
        super.Parse(inputStream);
        if (this.getError() > 0) {
            Streamer.error.Header().println(this.getError() + " error(s) were found parsing the XML InputStream.");
            return false;
        }
        return true;
    }

    public WDO4JSMappings getMappings() {
        return this._Universe;
    }

    public void setSourceEmapName(String string) {
        this._SourceEmapName = string;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        block10: {
            try {
                Streamer.trace.Header().print("Line ").print(this._Line).print(", Tag '").print(string).println("' found");
                if (string.equalsIgnoreCase(TAG_MAPPINGS)) break block10;
                if (string.equalsIgnoreCase(TAG_EPACKAGE)) {
                    if (this._ECM != null) {
                        Streamer.error.Header().println("Line " + this._Line + ", '" + TAG_EPACKAGE + "' tag found inside another '" + TAG_EPACKAGE + "'.");
                        return;
                    }
                    this.doEPackageTag(attributeList);
                    break block10;
                }
                if (string.equalsIgnoreCase(TAG_ECLASSMAP)) {
                    if (this._ECM != null) {
                        Streamer.error.Header().println("Line " + this._Line + ", '" + TAG_ECLASSMAP + "' tag found inside another '" + TAG_ECLASSMAP + "'.");
                        return;
                    }
                    this.doEClassMapTag(attributeList);
                    break block10;
                }
                if (string.equalsIgnoreCase(TAG_EFEATUREMAP)) {
                    if (this._ECM == null) {
                        Streamer.error.Header().println("Line " + this._Line + ", '" + TAG_EFEATUREMAP + "' tag found outside of a '" + TAG_ECLASSMAP + "'.");
                        return;
                    }
                    this.doEFeatureMapTag(attributeList);
                    break block10;
                }
                if (string.equalsIgnoreCase(TAG_CALCULATE)) {
                    if (this._ECM == null) {
                        Streamer.error.Header().println("Line " + this._Line + ", '" + TAG_CALCULATE + "' tag found outside of a '" + TAG_ECLASSMAP + "'.");
                        return;
                    }
                    this.doCalculateAttributeTag(attributeList);
                    break block10;
                }
                Streamer.warning.Header().println("Line " + this._Line + ", Unknown tag '" + string + "'.");
                ++this._Warning;
            }
            catch (Throwable throwable) {
                Streamer.error.Header().printStackTrace(throwable);
            }
        }
    }

    protected void doEPackageTag(AttributeList attributeList) {
        String string = this.CheckAttribute(attributeList, ATTR_NAME, null, true);
        String string2 = this.CheckAttribute(attributeList, ATTR_ROOT_ECLASSNAME, null, false);
        String string3 = this.CheckAttribute(attributeList, ATTR_ON_UPDATE, null, false);
        String string4 = this.CheckAttribute(attributeList, ATTR_JS_FILE, null, false);
        this._EPM = new EPackageMap(string);
        this._EPM.setOnUpdate(string3);
        this._EPM.setJsFile(string4);
        this._EPM.setRootEClassMapName(string2);
        this._EPM.setEMapResourceName(this._SourceEmapName);
        this._EPM.setEMapXMLFileName(this._XmlFileSource);
        this._Universe.addEPackageMap(this._EPM, false);
        this._EPM.setUniverse(this._Universe);
    }

    protected void doEClassMapTag(AttributeList attributeList) {
        String string = this.CheckAttribute(attributeList, ATTR_APPCLASS, null, true);
        String string2 = this.CheckAttribute(attributeList, ATTR_ECLASS_NAME, null, true);
        String string3 = this.CheckAttribute(attributeList, ATTR_EXPORT, null, true);
        boolean bl = this.CheckAttributeBool(attributeList, ATTR_DIFF_REFRESH, true, false);
        if (EClassMap.ParseComplexName(string) == null) {
            Streamer.error.Header().println("Line " + this._Line + ", The 'app_class' attribute for EClassMap '" + string2 + "' has an invalid syntax. We received '" + string + "' when we expected something of the form 'BaseType(ExtraName)' or 'BaseType'");
            ++this._Error;
        } else {
            this._ECM = new EClassMap(this._EPM.getName(), string2, string, string3, this.getXmlFileSource(), this._SourceEmapName, bl);
        }
    }

    protected void doEFeatureMapTag(AttributeList attributeList) {
        String string = this.CheckAttribute(attributeList, ATTR_EFEATURE_NAME, null, true);
        boolean bl = this.CheckAttributeBool(attributeList, ATTR_ID, false, false);
        String string2 = this.CheckAttribute(attributeList, ATTR_GET, null, true);
        String string3 = this.CheckAttribute(attributeList, ATTR_SET, null, false);
        String string4 = this.CheckAttribute(attributeList, ATTR_EXPORT, null, false);
        if (string4 != null) {
            Streamer.warning.Header().println("The export attribute for EFeatureMaps is deprecated. The value will be ignored and the EFeature will be exported using its ogirinal name.");
        }
        if (EClassMap.ParseComplexName(string) == null) {
            Streamer.error.Header().println("Line " + this._Line + ", The 'efeature_name' attribute '" + string + "' in EClassMap '" + this._ECM.getJavaComplexName() + "'has an invalid syntax. We expected something of the form 'BaseType(ExtraName)' or 'BaseType'");
            ++this._Error;
        } else {
            EFeatureMap eFeatureMap = new EFeatureMap(string, bl, string2, string3, false);
            this._ECM.addEFeatureMap(eFeatureMap);
            if (bl) {
                this._ECM.addEIdFeatureMap(eFeatureMap);
            }
        }
    }

    protected void doCalculateAttributeTag(AttributeList attributeList) {
        String string = this.CheckAttribute(attributeList, ATTR_ATTR_NAME, null, true);
        boolean bl = this.CheckAttributeBool(attributeList, ATTR_ID, false, false);
        String string2 = this.CheckAttribute(attributeList, ATTR_EXPRESSION, null, true);
        string2 = StringUtil.convertXMLEscapingtoJS(string2);
        String string3 = this.CheckAttribute(attributeList, ATTR_TYPE, null, false);
        String string4 = this.CheckAttribute(attributeList, ATTR_EXPORT, null, false);
        if (string4 != null) {
            Streamer.warning.Header().println("The export attribute for CalculateAttribute is deprecated. The value will be ignored and the EFeature will be exported using its ogirinal name.");
        }
        CalculateAttribute calculateAttribute = new CalculateAttribute(string, bl, string2, string3);
        this._ECM.addEFeatureMap(calculateAttribute);
        if (bl) {
            this._ECM.addEIdFeatureMap(calculateAttribute);
        }
    }

    public void endElement(String string) throws SAXException {
        block10: {
            try {
                Streamer.trace.Header().print("Line ").print(this._Line).print(", Tag '").print(string).println("' found");
                if (string.equalsIgnoreCase(TAG_MAPPINGS)) break block10;
                if (string.equalsIgnoreCase(TAG_EPACKAGE)) {
                    if (this._EPM == null) {
                        Streamer.error.Header().println("Line " + this._Line + ", closing '" + TAG_EPACKAGE + "' tag found outside a '" + TAG_EPACKAGE + "' block.");
                        ++this._Error;
                        return;
                    }
                    this._EPM = null;
                } else if (string.equalsIgnoreCase(TAG_ECLASSMAP)) {
                    if (this._ECM == null) {
                        Streamer.error.Header().println("Line " + this._Line + ", closing '" + TAG_ECLASSMAP + "' tag found outside a '" + TAG_ECLASSMAP + "' block.");
                        ++this._Error;
                        return;
                    }
                    if (!this._Universe.addEClassMap(this._EPM, this._ECM, false)) {
                        this._Universe.PrintEClassMapByEcoreName();
                        Streamer.error.Header().println("Line " + this._Line + ", " + TAG_ECLASSMAP + " '" + this._ECM.getEcoreName() + "' is defined in duplicate. Note that both table and object definitions share the same namespace.");
                        ++this._Error;
                        return;
                    }
                    this._ECM = null;
                } else if (!string.equalsIgnoreCase(TAG_EFEATUREMAP) && !string.equalsIgnoreCase(TAG_CALCULATE)) {
                    Streamer.warning.Header().println("Line " + this._Line + ", Unknown tag '" + string + "'.");
                    ++this._Warning;
                }
            }
            catch (Throwable throwable) {
                Streamer.error.Header().printStackTrace(throwable);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : "F:\\eclipse\\workspace\\WDOSource\\src\\com\\ibm\\odcb\\test\\jrender\\jsdo\\sources\\imc\\portfolio.emap";
            File file = new File(string);
            WDO4JSMappings wDO4JSMappings = new WDO4JSMappings();
            boolean bl = new MappingsParser(wDO4JSMappings).parse(file);
            System.out.println("Finished parsing mappings");
            System.out.println("The following mappings were added:");
            wDO4JSMappings.PrintEClassMapByEcoreName();
        }
        catch (Exception exception) {
            System.err.println("Error parsing mappings:");
            exception.printStackTrace();
        }
    }
}

