/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators;

import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.GenericSDO4JSMediatorGen;
import com.ibm.odcb.jrender.mediators.Mediator;
import com.ibm.odcb.jrender.mediators.gen.MappingsCompiler;
import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.misc.Streamer;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Iterator;

public class MediatorFactory {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static MediatorFactory _Instance;
    protected static Object _Mutex;
    protected HashMap _Mediators;
    protected WDO4JSMappings _Universe;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediatorFactory getInstance() throws ExportException {
        if (_Instance == null) {
            Object object = _Mutex;
            synchronized (object) {
                MappingsCompiler mappingsCompiler;
                if (_Instance == null && (mappingsCompiler = MediatorFactory.BuildMediators(false, false, null, null, null, null, false)).getUniverse().getError() != 0) {
                    throw new ExportException("Cannot create MediatorFactory Instance.  The universe failed verification.");
                }
            }
        }
        return _Instance;
    }

    protected MediatorFactory(WDO4JSMappings wDO4JSMappings, HashMap hashMap) {
        this.Init(wDO4JSMappings, hashMap);
    }

    protected void Init(WDO4JSMappings wDO4JSMappings, HashMap hashMap) {
        this._Universe = wDO4JSMappings;
        this._Mediators = hashMap == null ? new HashMap() : hashMap;
    }

    public static void GenMediators(boolean bl, String string, String string2, String string3, String string4, boolean bl2) {
        MediatorFactory.BuildMediators(true, bl, string, string2, string3, string4, bl2);
    }

    protected static synchronized MappingsCompiler BuildMediators(boolean bl, boolean bl2, String string, String string2, String string3, String string4, boolean bl3) {
        MappingsCompiler mappingsCompiler = null;
        boolean bl4 = true;
        try {
            mappingsCompiler = new MappingsCompiler(string, string2, string3);
            mappingsCompiler.init();
            bl4 = mappingsCompiler.PrepareTheUniverse();
            if (bl4) {
                bl4 = mappingsCompiler.VerifyTheUniverse();
            }
            if (bl4 && bl && (bl4 = mappingsCompiler.createClientEcores())) {
                bl4 = mappingsCompiler.CompileTheUniverse(bl2, string4, bl3);
            }
            if (bl4 && !bl && !bl2) {
                if (_Instance == null) {
                    _Instance = new MediatorFactory(mappingsCompiler.getUniverse(), mappingsCompiler.GetMediators());
                } else {
                    _Instance.Init(mappingsCompiler.getUniverse(), mappingsCompiler.GetMediators());
                }
                bl4 = mappingsCompiler.cacheClientEcores();
            }
        }
        catch (Exception exception) {
            Streamer.error.Header().println("Cannot create some or all mediators for this system");
            Streamer.error.Header().printStackTrace(exception);
            bl4 = false;
        }
        if (bl4) {
            Streamer.status.Header().println("Mediator generation completed Successfully.");
        } else {
            Streamer.error.Header().println("Mediator generation completed with errors.");
        }
        return mappingsCompiler;
    }

    public static String GenTypeKey(String string, String string2, String string3) {
        return EClassMap.MakeComplexName(string, string2) + "`" + string3;
    }

    public static String GenTypeKey(String string, String string2) {
        return string + "`" + string2;
    }

    protected Mediator getMediator(String string, String string2, String string3) {
        return (Mediator)this._Mediators.get(MediatorFactory.GenTypeKey(string, string2, string3));
    }

    protected Mediator getMediator(String string, String string2) {
        return (Mediator)this._Mediators.get(MediatorFactory.GenTypeKey(string, string2));
    }

    protected Mediator getMediator(String string) {
        return (Mediator)this._Mediators.get(string);
    }

    public static Mediator getMediator_OnlyUseIfYouKnowWhatYouAreDoing(String string, String string2) throws ExportException {
        String string3 = MediatorFactory.GenTypeKey(string, string2);
        Mediator mediator = (Mediator)MediatorFactory.getInstance()._Mediators.get(string3);
        if (mediator == null) {
            Streamer.error.Header().println("Cannot find the mediator for key " + string3);
        }
        return mediator;
    }

    protected void addMediator(String string, Mediator mediator) {
        this._Mediators.put(string, mediator);
    }

    protected void printMediatorList() {
        Streamer.debug.Header().println("Printing out the list of Mediators in the factory");
        Iterator iterator = this._Mediators.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Streamer.debug.Header().println("   " + string);
        }
    }

    public WDO4JSMappings getUniverse() {
        return this._Universe;
    }

    public static void initGenericMediator(String string, String string2, Object object) throws ExportException {
        boolean bl = GenericSDO4JSMediatorGen.isGenericSDO4JSMediatorNeeded(string, object);
        if (!bl) {
            bl = GenericSDO4JSMediatorGen.isGenericSDO4JSMediatorNeeded(string2, object);
        }
        if (bl) {
            GenericSDO4JSMediatorGen genericSDO4JSMediatorGen = new GenericSDO4JSMediatorGen((DataObject)object);
            genericSDO4JSMediatorGen.gen();
        }
    }

    static {
        _Mutex = new Object();
    }
}

