/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators;

import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.Mediator;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.mediators.gen.ecore.EClassMap;
import com.ibm.odcb.jrender.mediators.gen.ecore.EFeatureMap;
import com.ibm.odcb.jrender.mediators.gen.generators.FeatureExporter;
import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.StringUtil;
import com.ibm.odcb.jrender.misc.TypesUtil;
import commonj.sdo.DataObject;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreEList;

public class GenericSDO4JSMediator
extends Mediator {
    private EClassMap eClassMap = null;
    public static final String KEY = "_wdo4js_js";
    protected final int MEDIATOR_DEBUG_MODE = Config.getInteger(Config.PROP_MEDIATOR_DEBUG_MODE);

    public GenericSDO4JSMediator(EClassMap eClassMap) {
        super("GenericSDO4JSMediator", ",");
        this.eClassMap = eClassMap;
    }

    public String getSignature(Object object, String string, boolean bl, int n) {
        if (object == null) {
            return "";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer(128);
            this.eClassMap.getKeySignature(stringBuffer, (DataObject)object, 1, null);
            return bl ? string + "`" + this.eClassMap.getJavaComplexName() + stringBuffer.toString() : stringBuffer.toString();
        }
        catch (Exception exception) {
            if (exception instanceof ClassCastException) {
                System.out.println("ClassCastException: Expecting type 'commonj.sdo.DataObject' but found object of type '" + object.getClass().getName() + "'");
            }
            exception.printStackTrace();
            return null;
        }
    }

    private DataObject getDataObject(Object object) throws ExportException {
        if (object instanceof DataObject) {
            return (DataObject)object;
        }
        if (object instanceof EcoreEList) {
            Iterator iterator = ((EcoreEList)object).iterator();
            if (iterator.hasNext()) {
                Object e = iterator.next();
                return this.getDataObject(e);
            }
        } else {
            throw new ExportException("GenericSDO4JSMediator does not support the type '" + object.getClass().getName() + "'.  Only DataObjects and EcoreELists containing DataObjects are supported.");
        }
        return null;
    }

    public void Export(Writer writer, PageContext pageContext, Object object) throws ExportException {
        try {
            if (object == null || !(object instanceof DataObject)) {
                throw new ExportException("Generically exporting schema without supplying an instance of DataObject in not supported!  DataObject can not be null!");
            }
            boolean bl = pageContext.isFirstSchemaExport();
            if (bl) {
                writer.write("<SCRIPT> var A; var XTOTOX1=A; A=new ECreator().AddEAs; var R; var XTOTOX2=R; R=new ECreator().AddERs;");
                writer.write("var WDO4JSModel_");
                writer.write(pageContext.getSchemaExportName());
                writer.write("=new EClass(\"WDO4JSMR_");
                writer.write(pageContext.getLastModelName());
                writer.write("\");\n");
            }
            writer.write("var " + this.eClassMap.getExport() + "Class=new EClass(\"" + this.eClassMap.getExport() + "\"," + (this.eClassMap.isDiffOnRefresh() ? 1 : 0) + ");");
            writer.write("R(WDO4JSModel_");
            writer.write(pageContext.getSchemaExportName());
            writer.write(",[[\"" + this.eClassMap.getExport() + "\"," + this.eClassMap.getExport() + "Class,0,-1,0,0]]);\n");
            FeatureExporter featureExporter = new FeatureExporter(this.eClassMap);
            featureExporter.createSchemaString();
            HashMap hashMap = featureExporter.getReferenceTypes();
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                EClassMap eClassMap = (EClassMap)iterator.next();
                EFeatureMap eFeatureMap = (EFeatureMap)hashMap.get(eClassMap);
                Object object2 = ((DataObject)object).get(eFeatureMap.getEFeatureName());
                DataObject dataObject = this.getDataObject(object2);
                if (dataObject == null) continue;
                Mediator.ExportSchema(writer, pageContext, MediatorFactory.GenTypeKey(eClassMap.getJavaComplexName(), KEY), dataObject);
            }
            writer.write(featureExporter.getEAttributesSchema());
            writer.write(featureExporter.getEReferencesSchema());
            if (bl) {
                writer.write("var WDO4JSModelRoot_");
                writer.write(pageContext.getLastModelName());
                writer.write("=new XMILoader(WDO4JSModel_");
                writer.write(pageContext.getSchemaExportName());
                writer.write(", '" + this.eClassMap.getExport() + "', '" + this.eClassMap.getClientEcoreName() + "');\n");
                writer.write("A=XTOTOX1;R=XTOTOX2;</SCRIPT>\n");
            }
        }
        catch (Exception exception) {
            throw new ExportException(exception.toString());
        }
    }

    public void Export(Writer writer, PageContext pageContext, Object object, String string, boolean bl) throws ExportException {
        try {
            boolean bl2 = pageContext.isFirstDataExport();
            if (bl2) {
                writer.write("<SCRIPT> var C; var XTOTOX1=C; C=new EFactory().create; var I; var XTOTOX2=I; I=new ECreator().Init;\n");
            }
            if (object == null) {
                writer.write("var " + string + " = null;");
                return;
            }
            DataObject dataObject = (DataObject)object;
            writer.write("var " + string + " = C(" + this.eClassMap.getExport() + "Class);");
            Iterator iterator = this.eClassMap.getEFeatureMapIterator();
            int n = -1;
            StringBuffer stringBuffer = new StringBuffer(128);
            StringBuffer stringBuffer2 = new StringBuffer(128);
            while (iterator.hasNext()) {
                Object object2;
                ++n;
                EFeatureMap eFeatureMap = (EFeatureMap)iterator.next();
                if (eFeatureMap.isCalculateAttribute()) continue;
                if (eFeatureMap.getReferenceMap() != null) {
                    if (!eFeatureMap.isMany() && !TypesUtil.isGeneralList(eFeatureMap.getGetterType())) {
                        object2 = Mediator.ExportData(writer, pageContext, dataObject.get(eFeatureMap.getEFeatureName()), MediatorFactory.GenTypeKey(eFeatureMap.getReferenceMap().getJavaComplexName(), KEY), bl);
                        stringBuffer2.append("," + (String)(object2 == null || ((String)object2).length() == 0 ? "null" : object2) + (this.MEDIATOR_DEBUG_MODE == 1 ? " /*" + eFeatureMap.getExport() + "*/" : ""));
                        continue;
                    }
                    object2 = dataObject.getList(eFeatureMap.getEFeatureName());
                    Mediator.ExportData(writer, pageContext, (Collection)object2, MediatorFactory.GenTypeKey(eFeatureMap.getReferenceMap().getJavaComplexName(), KEY), bl);
                    String string2 = pageContext.PopArrayVar(MediatorFactory.GenTypeKey(eFeatureMap.getReferenceMap().getJavaComplexName(), KEY));
                    stringBuffer2.append("," + string2 == null ? "null" : "[" + string2 + "]" + (this.MEDIATOR_DEBUG_MODE == 1 ? " /*" + eFeatureMap.getExport() + "*/" : ""));
                    continue;
                }
                object2 = eFeatureMap.getGetterType();
                char c = TypesUtil.getOutputTypeFromJavaType((String)object2);
                if (TypesUtil.isGeneralList((String)object2)) {
                    List list = dataObject.getList(eFeatureMap.getEFeatureName());
                    stringBuffer.append("," + Mediator.constructArrayString(list, c) + (this.MEDIATOR_DEBUG_MODE == 1 ? " /*" + eFeatureMap.getExport() + "*/" : ""));
                    continue;
                }
                if (c == 'D') {
                    Date date = dataObject.getDate(eFeatureMap.getEFeatureName());
                    stringBuffer.append("," + (date == null ? -1L : date.getTime()) + (this.MEDIATOR_DEBUG_MODE == 1 ? " /*" + eFeatureMap.getExport() + "*/" : ""));
                    continue;
                }
                if (c == 'C') {
                    char c2 = dataObject.getChar(eFeatureMap.getEFeatureName());
                    stringBuffer.append("," + c2 + (this.MEDIATOR_DEBUG_MODE == 1 ? " /*" + eFeatureMap.getExport() + "*/" : ""));
                    continue;
                }
                if (c == 'S' || c == ' ') {
                    Object object3 = dataObject.get(eFeatureMap.getEFeatureName());
                    stringBuffer.append("," + (object3 == null ? "\"\"" : StringUtil.QuoteDoubleAndEscape(object3, false) + (this.MEDIATOR_DEBUG_MODE == 1 ? " /*" + eFeatureMap.getExport() + "*/" : "")));
                    continue;
                }
                Object object4 = dataObject.get(eFeatureMap.getEFeatureName());
                stringBuffer.append("," + object4 + (this.MEDIATOR_DEBUG_MODE == 1 ? " /*" + eFeatureMap.getExport() + "*/" : ""));
            }
            writer.write("I(" + string + ",[\"" + string + "\"" + stringBuffer.toString() + "],[");
            if (stringBuffer2.length() > 0) {
                stringBuffer2.setCharAt(0, '[');
                writer.write(" " + stringBuffer2.toString());
            }
            writer.write("]);\n");
            if (bl2) {
                writer.write("WDO4JSModelRoot_");
                writer.write(pageContext.getLastModelName());
                writer.write(".Root.eAdd('" + this.eClassMap.getExport() + "', " + string + ");");
                writer.write("C=XTOTOX1;I=XTOTOX2;</SCRIPT>\n");
            }
        }
        catch (Exception exception) {
            throw new ExportException(exception.toString());
        }
    }

    public void ExportXMILoader(Writer writer, PageContext pageContext) throws ExportException {
        block4: {
            try {
                try {
                    boolean bl = pageContext.isFirstSchemaExport();
                    StringBuffer stringBuffer = new StringBuffer();
                    if (!bl) break block4;
                    stringBuffer.append("<SCRIPT>").append("var WDO4JSModelRoot_").append(pageContext.getLastModelName()).append("=new XMILoader(WDO4JSModel_").append(pageContext.getSchemaExportName()).append(", ").append(this.eClassMap.getExport()).append(", ").append(this.eClassMap.getClientEcoreName()).append("\n").append("</SCRIPT>\n");
                    writer.write(stringBuffer.toString());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
    }
}

