/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.mediators;

import com.ibm.odcb.jrender.mediators.EMapWriter;
import com.ibm.odcb.jrender.mediators.MediatorFactory;
import com.ibm.odcb.jrender.mediators.gen.MappingsCompiler;
import com.ibm.odcb.jrender.mediators.gen.WDO4JSMappings;
import com.ibm.odcb.jrender.misc.Config;
import com.ibm.odcb.jrender.misc.EMFHelper;
import com.ibm.odcb.jrender.misc.FileUtil;
import com.ibm.odcb.jrender.misc.PropertiesUtil;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.utilities.Bean2ECoreGen;
import com.ibm.odcb.jrender.utilities.EMapGen;
import java.io.File;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

public class DynamicMediator {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static final String DYN_WDO_BASE_TYPE = EMFHelper.DataObject_CLASS.getName();
    protected static final String DYN_WDO_EXTRA_NAME = "DynWDO`";
    protected static final String DYN_WDO_COMPLEX_NAME_START = EMFHelper.DataObject_CLASS.getName() + "(";
    protected static final boolean TOTO = DynamicMediator.PrintVersion();

    public static boolean HandleDynamicWDOMapping(EClass eClass, String string, String string2, String string3, String string4, boolean bl) {
        DynamicHelper dynamicHelper = new DynamicHelper();
        EPackage ePackage = eClass.getEPackage();
        String string5 = ePackage.getName();
        if (!dynamicHelper.Init(string2, string3, string4, string, string5)) {
            return false;
        }
        EMFHelper.SaveEPackageToECore(ePackage, dynamicHelper._BaseSourcePath + "/" + string, "/" + string5 + ".ecore");
        if (!FileUtil.FileCopy(dynamicHelper._BaseSourcePath + "/" + string + "/" + string5 + ".ecore", dynamicHelper._BaseBuildPath + "/" + string + "/" + string5 + ".ecore", true)) {
            return false;
        }
        dynamicHelper.EMapGen(null, eClass.getName());
        if (!dynamicHelper.RegisterResources(true)) {
            return false;
        }
        return bl ? dynamicHelper.MediatorGen(null, true) : dynamicHelper.MediatorGen(string5, false);
    }

    public static String MakeExtraName(EClass eClass) {
        String string = eClass.getName();
        EPackage ePackage = eClass.getEPackage();
        String string2 = ePackage.getName();
        return DYN_WDO_EXTRA_NAME + string2 + "`" + string;
    }

    public static String MakeExtraName(EObject eObject) {
        return DynamicMediator.MakeExtraName(eObject.eClass());
    }

    public static String MakeExtraName(String string, String string2) {
        return DYN_WDO_EXTRA_NAME + string + "`" + string2;
    }

    public static boolean isExtraNameDynamic(String string) {
        return string.startsWith(DYN_WDO_EXTRA_NAME);
    }

    public static String MakeComplexName(EClass eClass) {
        return DYN_WDO_COMPLEX_NAME_START + DynamicMediator.MakeExtraName(eClass) + ")";
    }

    public static String MakeComplexName(EObject eObject) {
        return DYN_WDO_COMPLEX_NAME_START + DynamicMediator.MakeExtraName(eObject.eClass()) + ")";
    }

    public static String MakeComplexName(String string, String string2) {
        return DYN_WDO_COMPLEX_NAME_START + DynamicMediator.MakeExtraName(string, string2) + ")";
    }

    public static boolean isComplexNameDynamic(String string) {
        return string.startsWith(DYN_WDO_COMPLEX_NAME_START + DYN_WDO_EXTRA_NAME);
    }

    public static String getBasePartFromComplexName(String string) {
        int n = string.indexOf(40);
        return n == -1 ? string : string.substring(0, n);
    }

    protected static boolean PrintVersion() {
        Streamer.status.Header().println("JWL Version is 'JWL 1.1.1, SDO' at static initialization of DynamicMediator.");
        return true;
    }

    public static boolean HandleDynamicBeanMapping(Class clazz, String string, Map map, boolean bl, Map map2, String string2, String string3, String string4, String string5, boolean bl2) {
        DynamicHelper dynamicHelper = new DynamicHelper();
        if (!dynamicHelper.Init(string3, string4, string5, string2, string)) {
            return false;
        }
        Object object = new Bean2ECoreGen.Params();
        ((Bean2ECoreGen.Params)object)._BasePath = new File(dynamicHelper._BaseSourcePath);
        ((Bean2ECoreGen.Params)object)._ECoreFile = new File(dynamicHelper._BaseSourcePath + "/" + string2 + "/" + string + ".ecore");
        ((Bean2ECoreGen.Params)object)._RootJavaClassName = clazz.getName();
        ((Bean2ECoreGen.Params)object)._Mappings = map;
        ((Bean2ECoreGen.Params)object)._Include = bl;
        ((Bean2ECoreGen.Params)object)._IncludesExcludes = map2;
        Object object2 = new File(((Bean2ECoreGen.Params)object)._ECoreFile.getParent());
        if (!((File)object2).isDirectory() && !((File)object2).mkdirs()) {
            Streamer.error.Header().println("The second parameter '" + ((Bean2ECoreGen.Params)object)._ECoreFile + "' does not point to a valid path, or a path which cannot be created off the project root path");
            return false;
        }
        try {
            Bean2ECoreGen.Process((Bean2ECoreGen.Params)object);
        }
        catch (Exception exception) {
            Streamer.error.Header().println("Generating the ECore failed.");
            Streamer.error.Header().printStackTrace(exception);
            return false;
        }
        map = Bean2ECoreGen.GetKnownTypesAndClear();
        if (!FileUtil.FileCopy(dynamicHelper._BaseSourcePath + "/" + string2 + "/" + string + ".ecore", dynamicHelper._BaseBuildPath + "/" + string2 + "/" + string + ".ecore", true)) {
            return false;
        }
        object = null;
        object2 = map.entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry entry = (Map.Entry)object2.next();
            String string6 = (String)entry.getValue();
            if (!string6.equals(clazz.getName())) continue;
            object = (String)entry.getKey();
            break;
        }
        if (object == null) {
            Streamer.error.Header().println("Could not find an EClass Name for Java Class '" + (String)object + "'.");
            return false;
        }
        dynamicHelper.EMapGen(map, (String)object);
        if (!dynamicHelper.RegisterResources(true)) {
            return false;
        }
        return bl2 ? dynamicHelper.MediatorGen(null, true) : dynamicHelper.MediatorGen(string, false);
    }

    public static boolean handleDynamicSDOMapping(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        DynamicHelper dynamicHelper = new DynamicHelper();
        if (!dynamicHelper.Init(string4, string5, string6, string3, string)) {
            return false;
        }
        if (!FileUtil.FileCopy(dynamicHelper._BaseSourcePath + "/" + string3 + "/" + string + ".ecore", dynamicHelper._BaseBuildPath + "/" + string3 + "/" + string + ".ecore", true)) {
            return false;
        }
        dynamicHelper.EMapGen(null, string2);
        if (!dynamicHelper.RegisterResources(true)) {
            return false;
        }
        return bl ? dynamicHelper.MediatorGen(null, true) : dynamicHelper.MediatorGen(string, false);
    }

    public static boolean RemoveDynamicMapping(String string, String string2, String string3, String string4, String string5) {
        DynamicHelper dynamicHelper = new DynamicHelper();
        if (!dynamicHelper.Init(string3, string4, string5, string2, string)) {
            return false;
        }
        FileUtil.FileDelete(dynamicHelper._BaseSourcePath + "/" + string2 + "/" + string + ".ecore");
        FileUtil.FileDelete(dynamicHelper._BaseSourcePath + "/" + string2 + "/" + string + ".emap");
        FileUtil.DirDelete(dynamicHelper._BaseSourcePath + "/" + string2 + "/" + string);
        if (!dynamicHelper.RegisterResources(false)) {
            Streamer.error.Header().println("Could not clean up the SDO4JS mapping resources for " + string);
            return false;
        }
        Streamer.status.Header().println("Successfully cleaned up the SDO4JS mapping resources for " + string);
        return true;
    }

    public static EMapWriter getEMapWriter(String string, String string2, String string3) {
        MappingsCompiler mappingsCompiler = MediatorFactory.BuildMediators(false, false, string2, string3, null, string, false);
        WDO4JSMappings wDO4JSMappings = mappingsCompiler.getUniverse();
        EMapWriter eMapWriter = new EMapWriter(wDO4JSMappings, string, string2, string3);
        return eMapWriter;
    }

    protected static class DynamicHelper {
        protected String _PropertiesPath;
        protected String _PropertiesFileName;
        protected String _BaseSourcePath;
        protected String _BaseBuildPath;
        protected String _PackagePath;
        protected String _DataName;

        public DynamicHelper() {
            Streamer.status.Header().println("JWL Version is 'JWL 1.1.1, SDO' at dynamic usage of DynamicMediator.");
        }

        public static String CleanPath(String string) {
            string = string.trim();
            if (!(string = string.replace('/', File.separatorChar)).endsWith(File.separator)) {
                string = string + File.separator;
            }
            if (string.length() > 2 && string.charAt(1) == ':' && string.charAt(2) == File.separatorChar && !Character.isUpperCase(string.charAt(0))) {
                string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            }
            return string;
        }

        public boolean Init(String string, String string2, String string3, String string4, String string5) {
            Config.ReInit();
            this._PropertiesPath = DynamicHelper.CleanPath(string);
            this._BaseSourcePath = DynamicHelper.CleanPath(string2);
            this._BaseBuildPath = string3;
            this._PackagePath = string4;
            this._DataName = string5;
            if (!this._PropertiesPath.startsWith(this._BaseSourcePath)) {
                Streamer.error.Header().println("The PropertiesPath passed '" + this._PropertiesPath + "' does not match with the BaseSourcePath '" + this._BaseSourcePath + "' passed in.");
                return false;
            }
            this._PropertiesFileName = this._PropertiesPath.substring(this._BaseSourcePath.length());
            return true;
        }

        public boolean EMapGen(Map map, String string) {
            EMapGen.Params params = new EMapGen.Params();
            params._SourcePath = this._BaseSourcePath;
            params._BuildPath = this._BaseBuildPath;
            params._EcoreFileName = this._BaseSourcePath + "/" + this._PackagePath + "/" + this._DataName + ".ecore";
            params._RootEClassName = string;
            params._Mappings = map;
            params.MakeDefaultEMapMerge();
            try {
                EMapGen.Process(params);
            }
            catch (Exception exception) {
                Streamer.error.Header().println("Generating the EMap failed.");
                Streamer.error.Header().printStackTrace(exception);
                return false;
            }
            return FileUtil.FileCopy(this._BaseSourcePath + "/" + this._PackagePath + "/" + this._DataName + ".emap", this._BaseBuildPath + "/" + this._PackagePath + "/" + this._DataName + ".emap", true);
        }

        public boolean RegisterResources(boolean bl) {
            try {
                PropertiesUtil propertiesUtil = new PropertiesUtil();
                propertiesUtil.Open(this._BaseSourcePath + "/" + this._PropertiesFileName);
                if (bl) {
                    propertiesUtil.AddProperty(Config.PROP_ECORE_FILES.toString(), this._PackagePath + "/" + this._DataName + ".ecore");
                    propertiesUtil.AddProperty(Config.PROP_EMAP_FILES.toString(), this._PackagePath + "/" + this._DataName + ".emap");
                } else {
                    propertiesUtil.DeleteProperty(Config.PROP_ECORE_FILES.toString(), this._PackagePath + "/" + this._DataName + ".ecore");
                    propertiesUtil.DeleteProperty(Config.PROP_EMAP_FILES.toString(), this._PackagePath + "/" + this._DataName + ".emap");
                }
                propertiesUtil.Save();
                if (!FileUtil.FileCopy(this._BaseSourcePath + "/" + this._PropertiesFileName, this._BaseBuildPath + "/" + this._PropertiesFileName, true)) {
                    return false;
                }
                Config.ReInit();
                return true;
            }
            catch (Exception exception) {
                Streamer.error.Header().println("Cannot update the properties file resources");
                Streamer.error.Header().printStackTrace(exception);
                return false;
            }
        }

        public boolean MediatorGen(String string, boolean bl) {
            MappingsCompiler mappingsCompiler = MediatorFactory.BuildMediators(true, false, this._BaseSourcePath, null, null, string, bl);
            if (!mappingsCompiler.getVerificationStatus() || !mappingsCompiler.getGenerationStatus()) {
                Streamer.error.Header().println("Could not create the SDO4JS mappings for " + this._DataName);
                return false;
            }
            Streamer.status.Header().println("Successfully created the SDO4JS mappings for " + this._DataName);
            return FileUtil.FileCopy(this._BaseSourcePath + "/" + this._PackagePath + "/" + this._DataName + "/" + this._DataName + "_client.ecore", this._BaseBuildPath + "/" + this._PackagePath + "/" + this._DataName + "/" + this._DataName + "_client.ecore", true);
        }
    }
}

