/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.emitters.NodeAttributeEmitterHelper;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import com.ibm.odcb.jrender.misc.URLRewriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class TreeViewEmitter
extends BaseEmitter {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\nPID 5724-E76 and 5724-E77\n(c) Copyright International Business Machines Corporation 2003.\nAll Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected String _modelName;
    protected String _eObjectID;
    protected String _styleMap;
    protected String _sysIconStyle;
    protected String _rootVisibleFlagString = "true";
    protected String _enableSelectString = "false";
    protected String _treeWidth = null;
    protected String _treeHeight = null;
    protected boolean _percentageExists = false;
    protected String _styleClass;
    protected String _onnodehighlight;
    protected String _onnodeselect;
    protected String _onnodeunselect;
    protected ArrayList _nodeList = new ArrayList(7);
    protected ArrayList _iconMapArr = new ArrayList();
    protected ArrayList _handlerMapArr = new ArrayList();

    public TreeViewEmitter() {
        super("ODCTree");
    }

    public TreeViewEmitter(String string, String string2) {
        super("ODCTree");
        this.Init(string, string2);
    }

    public void Init(String string, String string2) {
        this._modelName = string;
        this._eObjectID = string2;
    }

    public void setSystemIconStyle(String string) {
        this._sysIconStyle = string;
    }

    public void setRootId(String string) {
        this._eObjectID = string;
    }

    public void addNode(NodeAttributeEmitterHelper nodeAttributeEmitterHelper) {
        this._nodeList.add(nodeAttributeEmitterHelper);
    }

    public void setTreeWidth(String string) {
        String string2;
        char c = string.charAt(string.length() - 1);
        if (c == '%') {
            string2 = string.substring(0, string.length() - 1);
            this._percentageExists = true;
        } else {
            string2 = string;
        }
        Integer n = Integer.valueOf(string2);
        if (n > 0) {
            this._treeWidth = string;
        }
    }

    public void setTreeHeight(String string) {
        String string2;
        char c = string.charAt(string.length() - 1);
        if (c == '%') {
            string2 = string.substring(0, string.length() - 1);
            this._percentageExists = true;
        } else {
            string2 = string;
        }
        Integer n = Integer.valueOf(string2);
        if (n > 0) {
            this._treeHeight = string;
        }
    }

    public void setRootVisibleFlag(boolean bl) {
        if (!bl) {
            this._rootVisibleFlagString = "false";
        }
    }

    public void setEnableSelect(boolean bl) {
        if (bl) {
            this._enableSelectString = "true";
        }
    }

    public void setOnnodehighlight(String string) {
        this._onnodehighlight = string;
    }

    public void setOnnodeselect(String string) {
        this._onnodeselect = string;
    }

    public void setOnnodeunselect(String string) {
        this._onnodeunselect = string;
    }

    public void setStyleClass(String string) {
        this._styleClass = string;
    }

    protected void constructStyleMapIconMapHandlerMap() {
        StringBuffer stringBuffer = new StringBuffer(128);
        int n = 0;
        while (n < this._nodeList.size()) {
            ArrayList arrayList;
            NodeAttributeEmitterHelper nodeAttributeEmitterHelper = (NodeAttributeEmitterHelper)this._nodeList.get(n);
            stringBuffer.append(nodeAttributeEmitterHelper.getStyleMap());
            ArrayList arrayList2 = nodeAttributeEmitterHelper.getIconMap();
            if (arrayList2.size() != 0) {
                this._iconMapArr.addAll(arrayList2);
            }
            if ((arrayList = nodeAttributeEmitterHelper.getHandlerMap()).size() != 0) {
                this._handlerMapArr.addAll(arrayList);
            }
            ++n;
        }
        this._styleMap = stringBuffer.length() == 0 ? null : stringBuffer.toString();
        Streamer.debug.Header().println("MapStyle: " + this._styleMap);
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        String string;
        int n;
        boolean bl;
        Streamer.trace.Header().println("Entering TreeViewEmitter export...");
        writer.write("<SCRIPT>ODCProgressBar.startRenderControl(treeview);</SCRIPT>\n");
        this._varIndex = pageContext.NextInstanceCount();
        URLRewriter uRLRewriter = (URLRewriter)pageContext.getContextVariable("URL_REWRITER");
        boolean bl2 = bl = pageContext.getContextVariable("DEBUG_MODE") == "YES";
        if (!BaseEmitter.TestGuard(pageContext, "TREE_JS_FLAG")) {
            if (bl) {
                writer.write("\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/tree/treecontrol.js") + "\"></SCRIPT>" + "\n<SCRIPT src=\"" + uRLRewriter.Rewrite("jsl/tree/treeadapter.js") + "\"></SCRIPT>");
            } else {
                writer.write("<SCRIPT language=\"JavaScript\" src=\"" + uRLRewriter.Rewrite("jsl/jsl_tree_c.js") + "\"></SCRIPT>\n");
            }
        }
        this.constructStyleMapIconMapHandlerMap();
        writer.write("<SPAN id=\"" + this.CONTROL_VAR + this._varIndex + "\"></SPAN>\n" + "<SCRIPT language=\"JavaScript\">\n" + "var " + this.CONTROL_VAR + this._varIndex + " = new Tree(window.document.getElementById(\"" + this.CONTROL_VAR + this._varIndex + "\"), URL_REWRITER_PREFIX);\n" + "var " + this.ADAPTER_VAR + this._varIndex + " = new TreeAdapter(" + this.CONTROL_VAR + this._varIndex + ", WDO4JSModelRoot_" + this._modelName + ".Root);\n" + this.ADAPTER_VAR + this._varIndex + ".setRootByID(\"" + this._eObjectID + "\");\n");
        if (this._styleMap != null) {
            writer.write(this.ADAPTER_VAR + this._varIndex + ".setStyleMap(\"" + this._styleMap + "\");\n");
        }
        if (this._iconMapArr.size() != 0) {
            n = 0;
            while (n < this._iconMapArr.size()) {
                string = (String)this._iconMapArr.get(n);
                if (string != null) {
                    writer.write(this.ADAPTER_VAR + this._varIndex + ".addNodeIconMap(\"" + string + "\");\n");
                }
                ++n;
            }
        }
        if (this._handlerMapArr.size() != 0) {
            n = 0;
            while (n < this._handlerMapArr.size()) {
                string = (String)this._handlerMapArr.get(n);
                if (string != null) {
                    writer.write(this.ADAPTER_VAR + this._varIndex + ".addNodeEventHandler(\"" + string + "\");\n");
                }
                ++n;
            }
        }
        if (this._sysIconStyle != null) {
            writer.write(this.ADAPTER_VAR + this._varIndex + ".setSystemIconStyle(\"" + this._sysIconStyle + "\");\n");
        }
        if (this._treeWidth != null) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".setWidth(\"" + this._treeWidth + "\");\n");
        }
        if (this._treeHeight != null) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".setHeight(\"" + this._treeHeight + "\");\n");
        }
        if (this._styleClass != null) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".setStyleClass(\"" + this._styleClass + "\");" + "\n");
        }
        if (this._percentageExists) {
            writer.write("function " + this.CONTROL_VAR + this._varIndex + "resize() { " + this.CONTROL_VAR + this._varIndex + ".reSize(); }\n" + "\n" + "if (window.addEventListener)\n" + " window.addEventListener('resize'," + this.CONTROL_VAR + this._varIndex + "resize,false);\n" + "else\n" + " window.attachEvent('onresize'," + this.CONTROL_VAR + this._varIndex + "resize);\n");
        }
        writer.write(this.CONTROL_VAR + this._varIndex + ".rootVisibleFlag = " + this._rootVisibleFlagString + ";\n" + this.CONTROL_VAR + this._varIndex + ".enableSelect = " + this._enableSelectString + ";\n");
        if (this._onnodehighlight != null && !this._onnodehighlight.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"onnodehighlight\",\"" + this._onnodehighlight + "\");\n");
        }
        if (this._onnodeselect != null && !this._onnodeselect.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"onnodeselect\",\"" + this._onnodeselect + "\");\n");
        }
        if (this._onnodeunselect != null && !this._onnodeunselect.equals("")) {
            writer.write(this.CONTROL_VAR + this._varIndex + ".addHandler(\"onnodeunselect\",\"" + this._onnodeunselect + "\");\n");
        }
        writer.write(this.ADAPTER_VAR + this._varIndex + ".bind();\n" + this.CONTROL_VAR + this._varIndex + ".updateControl();\n" + "ODCProgressBar.endRenderControl(treeview);\n" + "</SCRIPT>\n");
        Streamer.trace.Header().println("Exiting TreeViewEmitter export...");
    }
}

