/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.odcb.jrender.emitters;

import com.ibm.odcb.jrender.emitters.BaseEmitter;
import com.ibm.odcb.jrender.emitters.ClientConverterHelper;
import com.ibm.odcb.jrender.mediators.ExportException;
import com.ibm.odcb.jrender.mediators.InvalidParameterException;
import com.ibm.odcb.jrender.mediators.PageContext;
import com.ibm.odcb.jrender.misc.Streamer;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class TimePickerEmitter
extends BaseEmitter {
    private Locale locale = Locale.US;
    private String pattern;
    private String timeStyle;
    private String inputTextId;
    private int hourIncrement;
    private int minuteIncrement;
    private int secondIncrement;

    public TimePickerEmitter() {
        super("ODCTimePicker");
    }

    public void Init(String string) throws InvalidParameterException {
        this.Init(string, 0, 0, 0);
    }

    public void Init(String string, int n, int n2, int n3) throws InvalidParameterException {
        this.Init(string, null, null, "short", n, n2, n3);
    }

    public void Init(String string, Locale locale, String string2, String string3, int n, int n2, int n3) throws InvalidParameterException {
        Streamer.trace.Header().println("Entering TimePickerEmitter.Init()");
        if (string == null || string.equals("")) {
            Streamer.error.Header().print("The id for inputtext field is either null or empty.");
            throw new InvalidParameterException("The id for inputtext field is either null or empty.");
        }
        this.inputTextId = string;
        if (locale != null) {
            this.locale = locale;
        }
        this.pattern = string2;
        this.timeStyle = string3;
        this.hourIncrement = n;
        this.minuteIncrement = n2;
        this.secondIncrement = n3;
        Streamer.trace.Header().println("Exiting TimePickerEmitter.Init()");
    }

    public void Export(Writer writer, PageContext pageContext) throws ExportException, IOException {
        Streamer.trace.Header().println("Entering TimePickerEmitter.Export()");
        writer.write("<script>\n");
        Writer writer2 = writer;
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.inputTextId;
        String string2 = ClientConverterHelper.getJsDateConverterString(this.pattern, "time", null, this.timeStyle, this.locale);
        stringBuffer.append("hX_2.addConverter(\"" + string + "\", " + string2 + ");");
        if (null != string) {
            writer2.write("\n");
            writer2.write(stringBuffer.toString());
            stringBuffer.setLength(0);
        }
        writer2.write("hX_2.addComponent(\"" + this.inputTextId + "\", new hX_2.JSFSpinner(\"type:datetime\"");
        if (null != string) {
            writer2.write(", \"converter:" + string + "\"");
        }
        if (this.hourIncrement == 0 && this.minuteIncrement == 0 && this.secondIncrement == 0) {
            writer2.write(", \"increment:3600\", \"increment1:60\", \"increment2:1\"");
        } else {
            if (this.hourIncrement != 0) {
                if (this.hourIncrement > 0) {
                    writer2.write(", \"increment:" + this.hourIncrement * 3600 + "\"");
                } else {
                    writer2.write(", \"increment:" + Math.abs(this.hourIncrement) * 3600 + "\"");
                }
            }
            if (this.minuteIncrement != 0) {
                if (this.minuteIncrement > 0) {
                    writer2.write(", \"increment1:" + this.minuteIncrement * 60 + "\"");
                } else {
                    writer2.write(", \"increment1:" + Math.abs(this.minuteIncrement) * 60 + "\"");
                }
            }
            if (this.secondIncrement != 0) {
                if (this.secondIncrement > 0) {
                    writer2.write(", \"increment2:" + this.secondIncrement + "\"");
                } else {
                    writer2.write(", \"increment2:" + Math.abs(this.secondIncrement) + "\"");
                }
            }
        }
        writer2.write("));\n");
        writer2.write("</script>\n");
        Streamer.trace.Header().println("Exiting TimePickerEmitter.Export()");
    }

    public String getInputTextId() {
        return this.inputTextId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getTimeStyle() {
        return this.timeStyle;
    }

    public void setInputTextId(String string) {
        this.inputTextId = string;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setTimeStyle(String string) {
        this.timeStyle = string;
    }
}

