/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.UTF16;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TextTrieMap {
    private CharacterNode root = new CharacterNode(0);
    boolean ignoreCase;

    public TextTrieMap(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public synchronized void put(String text, Object o) {
        CharacterNode node = this.root;
        for (int i = 0; i < text.length(); ++i) {
            int ch = UTF16.charAt(text, i);
            node = node.addChildNode(ch);
            if (UTF16.getCharCount(ch) != 2) continue;
            ++i;
        }
        node.addObject(o);
    }

    public Iterator get(String text) {
        return this.get(text, 0);
    }

    public Iterator get(String text, int start) {
        LongestMatchHandler handler = new LongestMatchHandler();
        this.find(text, start, handler);
        return handler.getMatches();
    }

    public void find(String text, ResultHandler handler) {
        this.find(text, 0, handler);
    }

    public void find(String text, int start, ResultHandler handler) {
        this.find(this.root, text, start, start, handler);
    }

    private synchronized void find(CharacterNode node, String text, int start, int index, ResultHandler handler) {
        Iterator itr = node.iterator();
        if (itr != null && !handler.handlePrefixMatch(index - start, itr)) {
            return;
        }
        if (index < text.length()) {
            List childNodes = node.getChildNodes();
            if (childNodes == null) {
                return;
            }
            int ch = UTF16.charAt(text, index);
            int chLen = UTF16.getCharCount(ch);
            for (int i = 0; i < childNodes.size(); ++i) {
                CharacterNode child = (CharacterNode)childNodes.get(i);
                if (!this.compare(ch, child.getCharacter())) continue;
                this.find(child, text, start, index + chLen, handler);
                break;
            }
        }
    }

    private boolean compare(int ch1, int ch2) {
        if (ch1 == ch2) {
            return true;
        }
        if (this.ignoreCase) {
            if (UCharacter.toLowerCase(ch1) == UCharacter.toLowerCase(ch2)) {
                return true;
            }
            if (UCharacter.toUpperCase(ch1) == UCharacter.toUpperCase(ch2)) {
                return true;
            }
        }
        return false;
    }

    private class CharacterNode {
        int character;
        List children;
        List objlist;

        public CharacterNode(int ch) {
            this.character = ch;
        }

        public int getCharacter() {
            return this.character;
        }

        public void addObject(Object obj) {
            if (this.objlist == null) {
                this.objlist = new LinkedList();
            }
            this.objlist.add(obj);
        }

        public Iterator iterator() {
            if (this.objlist == null) {
                return null;
            }
            return this.objlist.iterator();
        }

        public CharacterNode addChildNode(int ch) {
            if (this.children == null) {
                this.children = new ArrayList();
                CharacterNode newNode = new CharacterNode(ch);
                this.children.add(newNode);
                return newNode;
            }
            CharacterNode node = null;
            for (int i = 0; i < this.children.size(); ++i) {
                CharacterNode cur = (CharacterNode)this.children.get(i);
                if (!TextTrieMap.this.compare(ch, cur.getCharacter())) continue;
                node = cur;
                break;
            }
            if (node == null) {
                node = new CharacterNode(ch);
                this.children.add(node);
            }
            return node;
        }

        public List getChildNodes() {
            return this.children;
        }
    }

    private static class LongestMatchHandler
    implements ResultHandler {
        private Iterator matches = null;
        private int length = 0;

        private LongestMatchHandler() {
        }

        public boolean handlePrefixMatch(int matchLength, Iterator values) {
            if (matchLength > this.length) {
                this.length = matchLength;
                this.matches = values;
            }
            return true;
        }

        public Iterator getMatches() {
            return this.matches;
        }
    }

    public static interface ResultHandler {
        public boolean handlePrefixMatch(int var1, Iterator var2);
    }
}

