/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import edu.umd.cs.findbugs.anttask.AbstractFindBugsTask;
import org.apache.tools.ant.BuildException;

public class ConvertXmlToTextTask
extends AbstractFindBugsTask {
    private boolean longBugCodes;
    private boolean applySuppression;
    private String input;
    private String output;
    private String format = "html";

    public ConvertXmlToTextTask() {
        super("edu.umd.cs.findbugs.PrintingBugReporter");
        this.setFailOnError(true);
    }

    public void setLongBugCodes(boolean longBugCodes) {
        this.longBugCodes = longBugCodes;
    }

    public void setApplySuppression(boolean applySuppression) {
        this.applySuppression = applySuppression;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setInputFile(String input) {
        this.input = input;
    }

    public void setOutputFile(String output) {
        this.output = output;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    protected void checkParameters() {
        if (this.input == null) {
            throw new BuildException("input attribute is required", this.getLocation());
        }
        if (this.output == null) {
            throw new BuildException("output attribute is required", this.getLocation());
        }
        if (!(this.format.equals("text") || this.format.equals("html") || this.format.startsWith("html:"))) {
            throw new BuildException("invalid value " + this.format + " for format attribute", this.getLocation());
        }
    }

    protected void configureFindbugsEngine() {
        if (this.format.startsWith("html")) {
            this.addArg("-" + this.format);
        }
        if (this.longBugCodes) {
            this.addArg("-longBugCodes");
        }
        if (this.applySuppression) {
            this.addArg("-applySuppression");
        }
        this.addArg(this.input);
        this.addArg(this.output);
    }

    protected void beforeExecuteJavaProcess() {
        this.log("Converting " + this.input + " to " + this.output + " using format " + this.format);
    }

    protected void afterExecuteJavaProcess(int rc) {
        if (rc == 0) {
            this.log("Success");
        }
    }
}

