/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.rmi.PortableRemoteObject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionRolledbackException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.Current;
import org.objectweb.jotm.HeuristicMixed;
import org.objectweb.jotm.InternalTransactionContext;
import org.objectweb.jotm.JavaXidImpl;
import org.objectweb.jotm.RecoveryCoordinator;
import org.objectweb.jotm.SubCoordinator;
import org.objectweb.jotm.Terminator;
import org.objectweb.jotm.TimerEvent;
import org.objectweb.jotm.TimerEventListener;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.XAResourceHelper;
import org.objectweb.jotm.Xid;
import org.objectweb.jotm.XidImpl;

public class TransactionImpl
implements Transaction,
TimerEventListener {
    private SubCoordinator subcoord = null;
    private TransactionContext myCtx = null;
    private Xid myXid = null;
    private String txDate = null;
    private boolean interpose = false;
    private int ucount = 0;
    private TimerEvent timer = null;
    private RecoveryCoordinator recoveryCoord = null;
    private List enlistedXARes = Collections.synchronizedList(new ArrayList());
    private List delistedXARes = null;
    private boolean propagateCtx = true;
    private List enlistedJavaxXid = Collections.synchronizedList(new ArrayList());
    static /* synthetic */ Class class$org$objectweb$jotm$Coordinator;

    public TransactionImpl(Xid xid, int timeout) throws SystemException {
        TraceTm.jta.debug((Object)("xid= " + xid));
        TraceTm.jta.debug((Object)("timeout= " + timeout));
        this.myXid = xid;
        this.myCtx = new InternalTransactionContext(timeout, null, xid);
    }

    public TransactionImpl(TransactionContext pctx) {
        if (pctx == null) {
            TraceTm.jotm.error((Object)"TransactionImpl: null PropagationContext");
        }
        this.myCtx = pctx;
        this.myXid = pctx.getXid();
        this.interpose = true;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException {
        TraceTm.jta.debug((Object)("TransactionImpl.commit (tx= " + this + ")"));
        Terminator term = this.myCtx.getTerminator();
        if (term != null) {
            try {
                this.propagateCtx = false;
                term.commit(true);
                this.propagateCtx = true;
            }
            catch (TransactionRolledbackException e) {
                Current.getCurrent().forgetTx(this.getXid());
                TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!");
                throw new RollbackException();
            }
            catch (RemoteException e) {
                if (TraceTm.jta.isWarnEnabled()) {
                    TraceTm.jta.warn((Object)"got a RemoteException", (Throwable)e);
                }
                if (e.detail instanceof TransactionRolledbackException) {
                    Current.getCurrent().forgetTx(this.getXid());
                    TraceTm.jta.debug((Object)"Commit distributed transaction -> rolled back!");
                    throw new RollbackException();
                }
                if (e.detail instanceof HeuristicMixed) {
                    TraceTm.jotm.info((Object)"Commit distributed transaction -> Heuristic mixed!");
                    throw new HeuristicMixedException();
                }
                throw new SystemException("Unexpected RemoteException on commit:" + e.detail.getMessage());
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit:", (Throwable)e);
                throw new SystemException("Unexpected Exception on commit");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.commit_one_phase();
            }
            catch (TransactionRolledbackException e) {
                TraceTm.jta.debug((Object)"Commit local transaction -> rolled back!");
                Current.getCurrent().forgetTx(this.getXid());
                throw new RollbackException();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on commit_one_phase:", (Throwable)e);
                Current.getCurrent().forgetTx(this.getXid());
                throw new SystemException("Unexpected Exception on commit_one_phase");
            }
        } else {
            this.unsetTimer();
            Current.getCurrent().forgetTx(this.getXid());
        }
    }

    public boolean delistResource(XAResource xares, int flag) throws IllegalStateException, SystemException {
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.delistResource");
            TraceTm.jta.debug((Object)("xares= " + xares + ", flag= " + flag));
        }
        if (this.enlistedXARes == null) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)"No XA resources enlisted by JOTM");
            }
            return false;
        }
        if (!this.enlistedXARes.contains(xares)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)("XAResouce " + xares + " not enlisted by JOTM"));
            }
            return false;
        }
        XidImpl resXid = new XidImpl(this.getXid(), this.subcoord.getXaresIndex(xares));
        javax.transaction.xa.Xid javaxxid = this.subcoord.getJavaxXid(this.subcoord.getXaresIndex(xares));
        if (!this.enlistedJavaxXid.contains(javaxxid)) {
            if (TraceTm.jta.isDebugEnabled()) {
                TraceTm.jta.error((Object)("XAResouce " + xares + " not enlisted by JOTM"));
            }
            return false;
        }
        int javaxxidindex = this.enlistedJavaxXid.indexOf(javaxxid);
        javax.transaction.xa.Xid myjavaxxid = (javax.transaction.xa.Xid)this.enlistedJavaxXid.get(javaxxidindex);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("resXid= " + resXid));
            TraceTm.jta.debug((Object)("delisted with resource= " + xares));
            TraceTm.jta.debug((Object)("end myjavaxxid= " + myjavaxxid));
        }
        try {
            xares.end(myjavaxxid, flag);
        }
        catch (XAException e) {
            String error = "Cannot send XA end:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error((Object)error);
            TraceTm.jotm.debug((Object)("xares.end= " + xares));
            throw new SystemException(error);
        }
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("enlistedXAres.remove xares= " + xares));
        }
        this.enlistedXARes.remove(xares);
        this.enlistedJavaxXid.remove(javaxxid);
        return true;
    }

    public boolean enlistResource(XAResource xares) throws RollbackException, IllegalStateException, SystemException {
        int flag;
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)"TransactionImpl.enlistResource");
            TraceTm.jta.debug((Object)("xares= " + xares));
        }
        if (xares == null) {
            TraceTm.jotm.error((Object)"enlistResource: null argument");
            throw new SystemException("enlistResource: null argument");
        }
        if (this.myCtx == null) {
            throw new SystemException("enlistResource: no Transactional Context");
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
            if (this.subcoord == null) {
                TraceTm.jotm.error((Object)"enlistResource: could not create subcoordinator");
                throw new SystemException("enlistResource: could not create subcoordinator");
            }
        }
        boolean found = false;
        try {
            found = this.subcoord.addResource(xares);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException("enlistResource: could not addResource " + xares);
        }
        boolean rollbackOnly = false;
        int n = flag = found ? 0x200000 : 0;
        if (this.delistedXARes != null && this.delistedXARes.contains(xares)) {
            flag = 0x8000000;
        }
        XidImpl resXid = new XidImpl(this.getXid(), this.subcoord.getXaresIndex(xares));
        JavaXidImpl javaxxid = new JavaXidImpl(resXid);
        if (TraceTm.jta.isDebugEnabled()) {
            TraceTm.jta.debug((Object)("resXid= " + resXid));
            TraceTm.jta.debug((Object)("enlisted with resource= " + xares));
            TraceTm.jta.debug((Object)("start javaxxid= " + javaxxid));
        }
        if (!found) {
            this.subcoord.addJavaxXid(javaxxid);
        }
        try {
            xares.start(javaxxid, flag);
        }
        catch (XAException e) {
            String error = "Cannot send XA(" + xares + ") start:" + e + " (error code = " + e.errorCode + ") --" + e.getMessage();
            TraceTm.jotm.error((Object)error);
            throw new SystemException(error);
        }
        if (rollbackOnly) {
            throw new RollbackException();
        }
        if (!this.enlistedXARes.contains(xares)) {
            this.enlistedXARes.add(xares);
            this.enlistedJavaxXid.add(javaxxid);
        }
        int status = this.getStatus();
        switch (status) {
            case 0: 
            case 7: {
                break;
            }
            case 2: {
                throw new IllegalStateException("Transaction already prepared.");
            }
            case 8: {
                break;
            }
            case 3: {
                throw new IllegalStateException("Transaction already committed.");
            }
            case 1: {
                throw new RollbackException("Transaction already marked for rollback");
            }
            case 9: {
                throw new RollbackException("Transaction already started rolling back.");
            }
            case 4: {
                throw new RollbackException("Transaction already rolled back.");
            }
            case 6: {
                throw new IllegalStateException("No current transaction.");
            }
            case 5: {
                throw new IllegalStateException("Unknown transaction status");
            }
            default: {
                throw new IllegalStateException("Illegal transaction status: " + status);
            }
        }
        return true;
    }

    public void doDetach(int flag) throws SystemException {
        TraceTm.jta.debug((Object)("TransactionImpl.doDetach flag= " + XAResourceHelper.getFlagName(flag)));
        TraceTm.jta.debug((Object)("number of enlisted= " + this.enlistedXARes.size()));
        this.delistedXARes = new ArrayList(this.enlistedXARes);
        for (int i = 0; i < this.delistedXARes.size(); ++i) {
            this.delistResource((XAResource)this.delistedXARes.get(i), flag);
        }
    }

    public void doAttach(int flag) throws SystemException, RollbackException {
        TraceTm.jta.debug((Object)("TransactionImpl.doAttach flag= " + XAResourceHelper.getFlagName(flag)));
        TraceTm.jta.debug((Object)("number of enlisted= " + this.enlistedXARes.size()));
        if (flag == 0x8000000) {
            for (int i = 0; this.delistedXARes != null && i < this.delistedXARes.size(); ++i) {
                this.enlistResource((XAResource)this.delistedXARes.get(i));
            }
        }
        this.delistedXARes = null;
    }

    public List getEnlistedXAResource() {
        TraceTm.jta.debug((Object)("getEnlistedXAResource size= " + this.enlistedXARes.size()));
        return new ArrayList(this.enlistedXARes);
    }

    public int getStatus() throws SystemException {
        TraceTm.jta.debug((Object)"TransactionImpl.getStatus()");
        Coordinator coord = this.myCtx.getCoordinator();
        if (coord != null) {
            int ret;
            try {
                ret = coord.get_status();
            }
            catch (Exception e) {
                TraceTm.jotm.error((Object)"cannot reach JTM:", (Throwable)e);
                return 6;
            }
            return ret;
        }
        if (this.subcoord == null) {
            return 0;
        }
        return this.subcoord.getStatus();
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        TraceTm.jta.debug((Object)"TransactionImpl.registerSynchronization(Synchronization sync)");
        if (this.subcoord == null) {
            this.makeSubCoord();
        }
        this.subcoord.addSynchronization(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        TraceTm.jta.debug((Object)("TransactionImpl.rollback(tx= " + this + ")"));
        Terminator term = this.myCtx.getTerminator();
        if (term != null) {
            try {
                this.propagateCtx = false;
                term.rollback();
                this.propagateCtx = true;
            }
            catch (ServerException e) {
                throw new IllegalStateException("Exception on rollback:" + e.detail);
            }
            catch (Exception e) {
                throw new SystemException("Unexpected Exception on rollback");
            }
            if (this.subcoord == null) {
                this.unsetTimer();
            }
            Current.getCurrent().forgetTx(this.getXid());
            return;
        }
        if (this.subcoord != null) {
            try {
                this.subcoord.rollback();
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Exception on rollback:" + e);
            }
        } else {
            this.unsetTimer();
        }
    }

    public int prepare() throws IllegalStateException, SystemException {
        TraceTm.jta.debug((Object)("TransactionImpl.prepare(tx= " + this + ")"));
        int ret = 0;
        if (this.subcoord != null) {
            try {
                ret = this.subcoord.prepare();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Unexpected Exception on prepare:", (Throwable)e);
                throw new SystemException("Unexpected Exception on prepare");
            }
        }
        return ret;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        TraceTm.jta.debug((Object)("TransactionImpl.setRollbackOnly(tx= " + this + ")"));
        Coordinator coord = this.myCtx.getCoordinator();
        if (coord != null) {
            try {
                coord.rollback_only();
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Cannot perform coordinator rollback only", (Throwable)e);
            }
        }
        if (this.subcoord == null) {
            this.makeSubCoord();
        }
        this.subcoord.setRollbackOnly();
    }

    public void timeoutExpired(Object arg) {
        TraceTm.jta.debug((Object)"TransactionImpl.timeoutExpired");
        Current.getCurrent().incrementExpiredCounter();
        if (this.subcoord == null) {
            Terminator term = this.myCtx.getTerminator();
            if (term != null) {
                TraceTm.jotm.info((Object)("forget tx (tx=" + this + ")"));
                Current.getCurrent().forgetTx(this.getXid());
                return;
            }
            this.makeSubCoord();
        }
        TraceTm.jotm.info((Object)("set rollback only (tx=" + this + ")"));
        try {
            this.subcoord.setRollbackOnly();
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)("cannot rollbackonly:" + e));
            return;
        }
    }

    public boolean equals(Object obj2) {
        TransactionImpl tx2 = (TransactionImpl)obj2;
        if (tx2 == this) {
            return true;
        }
        if (tx2 == null) {
            return false;
        }
        return this.getXid().equals(tx2.getXid());
    }

    public int hashCode() {
        return this.getXid().hashCode();
    }

    public String toString() {
        return ((Object)this.getXid()).toString();
    }

    public synchronized TransactionContext getPropagationContext(boolean hold) {
        if (this.propagateCtx) {
            if (hold) {
                ++this.ucount;
            }
            return this.myCtx;
        }
        return null;
    }

    public void setTimer(TimerEvent timer) {
        TraceTm.jta.debug((Object)("set timer for tx (timer=" + timer + ", tx=" + this + ")"));
        this.timer = timer;
    }

    public void unsetTimer() {
        TraceTm.jta.debug((Object)("unset timer for tx (timer=" + this.timer + ", tx=" + this + ")"));
        if (this.timer != null) {
            this.timer.unset();
            this.timer = null;
        }
    }

    public void setTxDate(String date) {
        TraceTm.jta.debug((Object)("set date for tx (data=" + date + ", tx=" + this + ")"));
        this.txDate = date;
    }

    public String getTxDate() {
        TraceTm.jta.debug((Object)("get date for tx (date=" + this.txDate + ", tx=" + this + ")"));
        return this.txDate;
    }

    public synchronized void updatePropagationContext(TransactionContext pctx) {
        TraceTm.jta.debug((Object)"TransactionImpl.updatePropagationContext");
        Coordinator remoteCoord = pctx.getCoordinator();
        if (remoteCoord == null && this.myCtx.getCoordinator() != null) {
            TraceTm.jotm.error((Object)"setPropagationContext: Bad Coordinator");
            TraceTm.jotm.error((Object)("remoteCoord = " + remoteCoord));
            TraceTm.jotm.error((Object)("myCtx.getCoordinator()= " + this.myCtx.getCoordinator()));
            return;
        }
        --this.ucount;
        if (remoteCoord != null && this.myCtx.getCoordinator() == null) {
            this.myCtx.setCoordinator(pctx.getCoordinator());
            if (this.subcoord != null) {
                try {
                    this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
                }
                catch (RemoteException e) {
                    TraceTm.jotm.error((Object)"Cannot make interposition:", (Throwable)e);
                    return;
                }
            }
        }
        if (pctx.getTerminator() != null) {
            this.myCtx.setTerminator(pctx.getTerminator());
        }
    }

    public Xid getXid() {
        TraceTm.jta.debug((Object)("myXid=" + this.myXid));
        return this.myXid;
    }

    private void makeSubCoord() {
        TraceTm.jta.debug((Object)"make subcoordinator");
        try {
            this.subcoord = new SubCoordinator(this, this.getXid());
        }
        catch (RemoteException e) {
            TraceTm.jotm.error((Object)"new SubCoordinator raised exception: ", (Throwable)e);
            return;
        }
        Coordinator remoteCoord = this.myCtx.getCoordinator();
        if (this.interpose && remoteCoord == null) {
            try {
                TraceTm.jta.debug((Object)"Creating a remote Control on JTM for a distributed transaction");
                remoteCoord = (Coordinator)PortableRemoteObject.narrow((Object)Current.getJTM().create(this.myCtx.getTimeout()), (Class)(class$org$objectweb$jotm$Coordinator == null ? (class$org$objectweb$jotm$Coordinator = TransactionImpl.class$("org.objectweb.jotm.Coordinator")) : class$org$objectweb$jotm$Coordinator));
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Cannot create distributed transaction:", (Throwable)e);
                return;
            }
            this.myCtx.setCoordinator(remoteCoord);
            if (this.myCtx.getTerminator() == null) {
                this.myCtx.setTerminator((Terminator)((Object)remoteCoord));
            }
        }
        if (remoteCoord != null && this.recoveryCoord == null) {
            try {
                this.recoveryCoord = remoteCoord.register_resource(this.subcoord);
            }
            catch (RemoteException e) {
                TraceTm.jotm.error((Object)"Cannot make interposition:", (Throwable)e);
                return;
            }
        }
    }

    public boolean isRemovable() {
        return this.ucount == 0 && this.subcoord == null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

