/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.WeakHashMap;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeSource {
    private final Map<Class<? extends Attribute>, AttributeImpl> attributes;
    private final Map<Class<? extends AttributeImpl>, AttributeImpl> attributeImpls;
    private AttributeFactory factory;
    private static final WeakHashMap<Class<? extends AttributeImpl>, LinkedList<WeakReference<Class<? extends Attribute>>>> knownImplClasses = new WeakHashMap();
    private State currentState = null;

    public AttributeSource() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY);
    }

    public AttributeSource(AttributeSource input) {
        if (input == null) {
            throw new IllegalArgumentException("input AttributeSource must not be null");
        }
        this.attributes = input.attributes;
        this.attributeImpls = input.attributeImpls;
        this.factory = input.factory;
    }

    public AttributeSource(AttributeFactory factory) {
        this.attributes = new LinkedHashMap<Class<? extends Attribute>, AttributeImpl>();
        this.attributeImpls = new LinkedHashMap<Class<? extends AttributeImpl>, AttributeImpl>();
        this.factory = factory;
    }

    public AttributeFactory getAttributeFactory() {
        return this.factory;
    }

    public Iterator<Class<? extends Attribute>> getAttributeClassesIterator() {
        return Collections.unmodifiableSet(this.attributes.keySet()).iterator();
    }

    public Iterator<AttributeImpl> getAttributeImplsIterator() {
        if (this.hasAttributes()) {
            if (this.currentState == null) {
                this.computeCurrentState();
            }
            final State initState = this.currentState;
            return new Iterator<AttributeImpl>(){
                private State state;
                {
                    this.state = initState;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public AttributeImpl next() {
                    if (this.state == null) {
                        throw new NoSuchElementException();
                    }
                    AttributeImpl att = this.state.attribute;
                    this.state = this.state.next;
                    return att;
                }

                @Override
                public boolean hasNext() {
                    return this.state != null;
                }
            };
        }
        return Collections.emptySet().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addAttributeImpl(AttributeImpl att) {
        LinkedList<WeakReference<Class<Attribute>>> foundInterfaces;
        Class<?> clazz = att.getClass();
        if (this.attributeImpls.containsKey(clazz)) {
            return;
        }
        WeakHashMap<Class<? extends AttributeImpl>, LinkedList<WeakReference<Class<? extends Attribute>>>> weakHashMap = knownImplClasses;
        synchronized (weakHashMap) {
            foundInterfaces = knownImplClasses.get(clazz);
            if (foundInterfaces == null) {
                void var5_6;
                Class clazz2;
                foundInterfaces = new LinkedList();
                knownImplClasses.put(clazz, foundInterfaces);
                Class<?> clazz3 = clazz;
                do {
                    for (Class<?> curInterface : var5_6.getInterfaces()) {
                        if (curInterface == Attribute.class || !Attribute.class.isAssignableFrom(curInterface)) continue;
                        foundInterfaces.add(new WeakReference<Class<Attribute>>(curInterface.asSubclass(Attribute.class)));
                    }
                } while ((clazz2 = var5_6.getSuperclass()) != null);
            }
        }
        for (WeakReference weakReference : foundInterfaces) {
            Class curInterface = (Class)weakReference.get();
            assert (curInterface != null) : "We have a strong reference on the class holding the interfaces, so they should never get evicted";
            if (this.attributes.containsKey(curInterface)) continue;
            this.currentState = null;
            this.attributes.put(curInterface, att);
            this.attributeImpls.put(clazz, att);
        }
    }

    public <A extends Attribute> A addAttribute(Class<A> attClass) {
        AttributeImpl attImpl = this.attributes.get(attClass);
        if (attImpl == null) {
            if (!attClass.isInterface() || !Attribute.class.isAssignableFrom(attClass)) {
                throw new IllegalArgumentException("addAttribute() only accepts an interface that extends Attribute, but " + attClass.getName() + " does not fulfil this contract.");
            }
            attImpl = this.factory.createAttributeInstance(attClass);
            this.addAttributeImpl(attImpl);
        }
        return (A)((Attribute)attClass.cast(attImpl));
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasAttribute(Class<? extends Attribute> attClass) {
        return this.attributes.containsKey(attClass);
    }

    public <A extends Attribute> A getAttribute(Class<A> attClass) {
        AttributeImpl attImpl = this.attributes.get(attClass);
        if (attImpl == null) {
            throw new IllegalArgumentException("This AttributeSource does not have the attribute '" + attClass.getName() + "'.");
        }
        return (A)((Attribute)attClass.cast(attImpl));
    }

    private void computeCurrentState() {
        State c = this.currentState = new State();
        Iterator<AttributeImpl> it = this.attributeImpls.values().iterator();
        c.attribute = it.next();
        while (it.hasNext()) {
            c.next = new State();
            c = c.next;
            c.attribute = it.next();
        }
    }

    public void clearAttributes() {
        if (this.hasAttributes()) {
            if (this.currentState == null) {
                this.computeCurrentState();
            }
            State state = this.currentState;
            while (state != null) {
                state.attribute.clear();
                state = state.next;
            }
        }
    }

    public State captureState() {
        if (!this.hasAttributes()) {
            return null;
        }
        if (this.currentState == null) {
            this.computeCurrentState();
        }
        return (State)this.currentState.clone();
    }

    public void restoreState(State state) {
        if (state == null) {
            return;
        }
        do {
            AttributeImpl targetImpl;
            if ((targetImpl = this.attributeImpls.get(state.attribute.getClass())) == null) {
                throw new IllegalArgumentException("State contains an AttributeImpl that is not in this AttributeSource");
            }
            state.attribute.copyTo(targetImpl);
        } while ((state = state.next) != null);
    }

    public int hashCode() {
        int code = 0;
        if (this.hasAttributes()) {
            if (this.currentState == null) {
                this.computeCurrentState();
            }
            State state = this.currentState;
            while (state != null) {
                code = code * 31 + state.attribute.hashCode();
                state = state.next;
            }
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AttributeSource) {
            AttributeSource other = (AttributeSource)obj;
            if (this.hasAttributes()) {
                if (!other.hasAttributes()) {
                    return false;
                }
                if (this.attributeImpls.size() != other.attributeImpls.size()) {
                    return false;
                }
                if (this.currentState == null) {
                    this.computeCurrentState();
                }
                State thisState = this.currentState;
                if (other.currentState == null) {
                    other.computeCurrentState();
                }
                State otherState = other.currentState;
                while (thisState != null && otherState != null) {
                    if (otherState.attribute.getClass() != thisState.attribute.getClass() || !otherState.attribute.equals(thisState.attribute)) {
                        return false;
                    }
                    thisState = thisState.next;
                    otherState = otherState.next;
                }
                return true;
            }
            return !other.hasAttributes();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append('(');
        if (this.hasAttributes()) {
            if (this.currentState == null) {
                this.computeCurrentState();
            }
            State state = this.currentState;
            while (state != null) {
                if (state != this.currentState) {
                    sb.append(',');
                }
                sb.append(state.attribute.toString());
                state = state.next;
            }
        }
        return sb.append(')').toString();
    }

    public AttributeSource cloneAttributes() {
        AttributeSource clone = new AttributeSource(this.factory);
        if (this.hasAttributes()) {
            if (this.currentState == null) {
                this.computeCurrentState();
            }
            State state = this.currentState;
            while (state != null) {
                clone.attributeImpls.put(state.attribute.getClass(), (AttributeImpl)state.attribute.clone());
                state = state.next;
            }
        }
        for (Map.Entry<Class<? extends Attribute>, AttributeImpl> entry : this.attributes.entrySet()) {
            clone.attributes.put(entry.getKey(), clone.attributeImpls.get(entry.getValue().getClass()));
        }
        return clone;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AttributeFactory {
        public static final AttributeFactory DEFAULT_ATTRIBUTE_FACTORY = new DefaultAttributeFactory();

        public abstract AttributeImpl createAttributeInstance(Class<? extends Attribute> var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class DefaultAttributeFactory
        extends AttributeFactory {
            private static final WeakHashMap<Class<? extends Attribute>, WeakReference<Class<? extends AttributeImpl>>> attClassImplMap = new WeakHashMap();

            private DefaultAttributeFactory() {
            }

            @Override
            public AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
                try {
                    return DefaultAttributeFactory.getClassForInterface(attClass).newInstance();
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("Could not instantiate implementing class for " + attClass.getName());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Could not instantiate implementing class for " + attClass.getName());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static Class<? extends AttributeImpl> getClassForInterface(Class<? extends Attribute> attClass) {
                WeakHashMap<Class<? extends Attribute>, WeakReference<Class<? extends AttributeImpl>>> weakHashMap = attClassImplMap;
                synchronized (weakHashMap) {
                    Class<AttributeImpl> clazz;
                    WeakReference<Class<? extends AttributeImpl>> ref = attClassImplMap.get(attClass);
                    Class<AttributeImpl> clazz2 = clazz = ref == null ? null : (Class<AttributeImpl>)ref.get();
                    if (clazz == null) {
                        try {
                            clazz = Class.forName(attClass.getName() + "Impl", true, attClass.getClassLoader()).asSubclass(AttributeImpl.class);
                            attClassImplMap.put(attClass, new WeakReference<Class<AttributeImpl>>(clazz));
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException("Could not find implementing class for " + attClass.getName());
                        }
                    }
                    return clazz;
                }
            }
        }
    }

    public static final class State
    implements Cloneable {
        private AttributeImpl attribute;
        private State next;

        public Object clone() {
            State clone = new State();
            clone.attribute = (AttributeImpl)this.attribute.clone();
            if (this.next != null) {
                clone.next = (State)this.next.clone();
            }
            return clone;
        }
    }
}

