/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    ScoreDoc pqTop = (ScoreDoc)this.pq.top();
    int docBase = 0;
    Scorer scorer;

    public static TopScoreDocCollector create(int numHits, boolean docsScoredInOrder) {
        if (docsScoredInOrder) {
            return new InOrderTopScoreDocCollector(numHits);
        }
        return new OutOfOrderTopScoreDocCollector(numHits);
    }

    private TopScoreDocCollector(int numHits) {
        super(new HitQueue(numHits, true));
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            return EMPTY_TOPDOCS;
        }
        float maxScore = Float.NaN;
        if (start == 0) {
            maxScore = results[0].score;
        } else {
            for (int i = this.pq.size(); i > 1; --i) {
                this.pq.pop();
            }
            maxScore = ((ScoreDoc)this.pq.pop()).score;
        }
        return new TopDocs(this.totalHits, results, maxScore);
    }

    @Override
    public void setNextReader(IndexReader reader, int base) {
        this.docBase = base;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    private static class InOrderTopScoreDocCollector
    extends TopScoreDocCollector {
        private InOrderTopScoreDocCollector(int numHits) {
            super(numHits);
        }

        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            assert (score != Float.NEGATIVE_INFINITY);
            assert (!Float.isNaN(score));
            ++this.totalHits;
            if (score <= this.pqTop.score) {
                return;
            }
            this.pqTop.doc = doc + this.docBase;
            this.pqTop.score = score;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }
    }

    private static class OutOfOrderTopScoreDocCollector
    extends TopScoreDocCollector {
        private OutOfOrderTopScoreDocCollector(int numHits) {
            super(numHits);
        }

        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            assert (!Float.isNaN(score));
            ++this.totalHits;
            if (score < this.pqTop.score || score == this.pqTop.score && (doc += this.docBase) > this.pqTop.doc) {
                return;
            }
            this.pqTop.doc = doc;
            this.pqTop.score = score;
            this.pqTop = (ScoreDoc)this.pq.updateTop();
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

