/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryWrapperFilter;
import org.apache.lucene.search.TermQuery;

public abstract class MultiTermQuery
extends Query {
    protected RewriteMethod rewriteMethod = CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
    transient int numberOfTerms = 0;
    public static final RewriteMethod CONSTANT_SCORE_FILTER_REWRITE = new ConstantScoreFilterRewrite();
    public static final RewriteMethod SCORING_BOOLEAN_QUERY_REWRITE = new ScoringBooleanQueryRewrite();
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = new ConstantScoreBooleanQueryRewrite();
    public static final RewriteMethod CONSTANT_SCORE_AUTO_REWRITE_DEFAULT = new ConstantScoreAutoRewrite(){

        public void setTermCountCutoff(int count) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        public void setDocCountPercent(double percent) {
            throw new UnsupportedOperationException("Please create a private instance");
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_AUTO_REWRITE_DEFAULT;
        }
    };

    protected abstract FilteredTermEnum getEnum(IndexReader var1) throws IOException;

    public int getTotalNumberOfTerms() {
        return this.numberOfTerms;
    }

    public void clearTotalNumberOfTerms() {
        this.numberOfTerms = 0;
    }

    protected void incTotalNumberOfTerms(int inc) {
        this.numberOfTerms += inc;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this.rewriteMethod.rewrite(reader, this);
    }

    public RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    public void setRewriteMethod(RewriteMethod method) {
        this.rewriteMethod = method;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        result = 31 * result;
        return result += this.rewriteMethod.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTermQuery other = (MultiTermQuery)obj;
        if (Float.floatToIntBits(this.getBoost()) != Float.floatToIntBits(other.getBoost())) {
            return false;
        }
        return this.rewriteMethod.equals(other.rewriteMethod);
    }

    public static class ConstantScoreAutoRewrite
    extends RewriteMethod
    implements Serializable {
        public static int DEFAULT_TERM_COUNT_CUTOFF = 350;
        public static double DEFAULT_DOC_COUNT_PERCENT = 0.1;
        private int termCountCutoff = DEFAULT_TERM_COUNT_CUTOFF;
        private double docCountPercent = DEFAULT_DOC_COUNT_PERCENT;

        public void setTermCountCutoff(int count) {
            this.termCountCutoff = count;
        }

        public int getTermCountCutoff() {
            return this.termCountCutoff;
        }

        public void setDocCountPercent(double percent) {
            this.docCountPercent = percent;
        }

        public double getDocCountPercent() {
            return this.docCountPercent;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            ConstantScoreQuery constantScoreQuery;
            FilteredTermEnum enumerator;
            block6: {
                ConstantScoreQuery constantScoreQuery2;
                block5: {
                    ArrayList<Term> pendingTerms = new ArrayList<Term>();
                    int docCountCutoff = (int)(this.docCountPercent / 100.0 * (double)reader.maxDoc());
                    int termCountLimit = Math.min(BooleanQuery.getMaxClauseCount(), this.termCountCutoff);
                    int docVisitCount = 0;
                    enumerator = query.getEnum(reader);
                    try {
                        do {
                            Term t;
                            if ((t = enumerator.term()) != null) {
                                pendingTerms.add(t);
                                docVisitCount += reader.docFreq(t);
                            }
                            if (pendingTerms.size() < termCountLimit && docVisitCount < docCountCutoff) continue;
                            ConstantScoreQuery result = new ConstantScoreQuery(new MultiTermQueryWrapperFilter<MultiTermQuery>(query));
                            result.setBoost(query.getBoost());
                            constantScoreQuery2 = result;
                            Object var14_13 = null;
                            break block5;
                        } while (enumerator.next());
                        BooleanQuery bq = new BooleanQuery(true);
                        for (Term term : pendingTerms) {
                            TermQuery tq = new TermQuery(term);
                            bq.add(tq, BooleanClause.Occur.SHOULD);
                        }
                        ConstantScoreQuery result = new ConstantScoreQuery(new QueryWrapperFilter(bq));
                        result.setBoost(query.getBoost());
                        query.incTotalNumberOfTerms(pendingTerms.size());
                        constantScoreQuery = result;
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var14_15 = null;
                        enumerator.close();
                        throw throwable;
                    }
                }
                enumerator.close();
                return constantScoreQuery2;
            }
            Object var14_14 = null;
            enumerator.close();
            return constantScoreQuery;
        }

        public int hashCode() {
            int prime = 1279;
            return (int)((long)(1279 * this.termCountCutoff) + Double.doubleToLongBits(this.docCountPercent));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConstantScoreAutoRewrite other = (ConstantScoreAutoRewrite)obj;
            if (other.termCountCutoff != this.termCountCutoff) {
                return false;
            }
            return Double.doubleToLongBits(other.docCountPercent) == Double.doubleToLongBits(this.docCountPercent);
        }
    }

    private static class ConstantScoreBooleanQueryRewrite
    extends ScoringBooleanQueryRewrite
    implements Serializable {
        private ConstantScoreBooleanQueryRewrite() {
        }

        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            ConstantScoreQuery result = new ConstantScoreQuery(new QueryWrapperFilter(super.rewrite(reader, query)));
            result.setBoost(query.getBoost());
            return result;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;
        }
    }

    private static final class ConstantScoreFilterRewrite
    extends RewriteMethod
    implements Serializable {
        private ConstantScoreFilterRewrite() {
        }

        public Query rewrite(IndexReader reader, MultiTermQuery query) {
            ConstantScoreQuery result = new ConstantScoreQuery(new MultiTermQueryWrapperFilter<MultiTermQuery>(query));
            result.setBoost(query.getBoost());
            return result;
        }

        protected Object readResolve() {
            return CONSTANT_SCORE_FILTER_REWRITE;
        }
    }

    public static abstract class RewriteMethod
    implements Serializable {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;
    }

    private static class ScoringBooleanQueryRewrite
    extends RewriteMethod
    implements Serializable {
        private ScoringBooleanQueryRewrite() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Query rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            FilteredTermEnum enumerator = query.getEnum(reader);
            BooleanQuery result = new BooleanQuery(true);
            int count = 0;
            try {
                do {
                    Term t;
                    if ((t = enumerator.term()) == null) continue;
                    TermQuery tq = new TermQuery(t);
                    tq.setBoost(query.getBoost() * enumerator.difference());
                    result.add(tq, BooleanClause.Occur.SHOULD);
                    ++count;
                } while (enumerator.next());
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                enumerator.close();
                throw throwable;
            }
            enumerator.close();
            query.incTotalNumberOfTerms(count);
            return result;
        }

        protected Object readResolve() {
            return SCORING_BOOLEAN_QUERY_REWRITE;
        }
    }
}

