/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.utils;

import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SignatureUtils {
    public static boolean isInheritedMethod(JavaClass cls, String methodName, String signature) throws ClassNotFoundException {
        JavaClass[] infs = cls.getAllInterfaces();
        if (SignatureUtils.findInheritedMethod(infs, methodName, signature) != null) {
            return true;
        }
        JavaClass[] supers = cls.getSuperClasses();
        for (int i = 0; i < supers.length; ++i) {
            if (!"java.lang.Object".equals(supers[i].getClassName())) continue;
            supers[i] = null;
        }
        return SignatureUtils.findInheritedMethod(supers, methodName, signature) != null;
    }

    public static String getPackageName(String className) {
        int dotPos = className.lastIndexOf(46);
        if (dotPos < 0) {
            return "";
        }
        return className.substring(0, dotPos);
    }

    public static boolean similarPackages(String packName1, String packName2, int depth) {
        String s2;
        if (depth == 0) {
            return true;
        }
        packName1 = packName1.replace('/', '.');
        packName2 = packName2.replace('/', '.');
        int dot1 = packName1.indexOf(46);
        int dot2 = packName2.indexOf(46);
        if (dot1 < 0) {
            return dot2 < 0;
        }
        if (dot2 < 0) {
            return false;
        }
        String s1 = packName1.substring(0, dot1);
        if (!s1.equals(s2 = packName2.substring(0, dot2))) {
            return false;
        }
        return SignatureUtils.similarPackages(packName1.substring(dot1 + 1), packName2.substring(dot2 + 1), depth - 1);
    }

    public static String getTypeCodeSignature(int typeCode) {
        switch (typeCode) {
            case 4: {
                return "Z";
            }
            case 5: {
                return "C";
            }
            case 6: {
                return "F";
            }
            case 7: {
                return "D";
            }
            case 8: {
                return "B";
            }
            case 9: {
                return "S";
            }
            case 10: {
                return "I";
            }
            case 11: {
                return "L";
            }
        }
        return "Ljava/lang/Object;";
    }

    private static JavaClass findInheritedMethod(JavaClass[] classes, String methodName, String signature) {
        JavaClass[] arr$ = classes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method[] methods;
            JavaClass cls = arr$[i$];
            if (cls == null) continue;
            Method[] arr$2 = methods = cls.getMethods();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Method m = arr$2[i$2];
                if (m.isPrivate() || !m.getName().equals(methodName) || !m.getSignature().equals(signature)) continue;
                return cls;
            }
        }
        return null;
    }
}

