/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class WeakExceptionMessaging
extends BytecodeScanningDetector {
    private static JavaClass exceptionClass;
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public WeakExceptionMessaging(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            if (exceptionClass != null) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
            Object var3_2 = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            throw throwable;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(191);
    }

    public void visitCode(Code obj) {
        Method method = this.getMethod();
        if (!method.getSignature().startsWith("()") && this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        boolean sawConstant;
        boolean allConstantStrings;
        block14: {
            block15: {
                allConstantStrings = false;
                sawConstant = false;
                try {
                    try {
                        JavaClass exCls;
                        String clsName;
                        if (seen == 191) {
                            OpcodeStack.Item item;
                            if (this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).getUserValue() != null) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "WEM_WEAK_EXCEPTION_MESSAGING", 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                            break block14;
                        }
                        if (seen == 18 || seen == 19) {
                            if (this.getConstantRefOperand() instanceof ConstantString) {
                                sawConstant = true;
                            }
                            break block14;
                        }
                        if (seen != 183 || !"<init>".equals(this.getNameConstantOperand()) || (clsName = this.getClassConstantOperand()).indexOf("Exception") < 0 || !(exCls = Repository.lookupClass((String)clsName)).instanceOf(exceptionClass)) break block14;
                        String sig = this.getSigConstantOperand();
                        Type[] argTypes = Type.getArgumentTypes((String)sig);
                        int stringParms = 0;
                        for (int t = 0; t < argTypes.length; ++t) {
                            OpcodeStack.Item item;
                            if (!"Ljava/lang/String;".equals(argTypes[t].getSignature())) continue;
                            ++stringParms;
                            int stackOffset = argTypes.length - t - 1;
                            if (this.stack.getStackDepth() <= stackOffset || (item = this.stack.getStackItem(stackOffset)).getUserValue() != null) continue;
                            Object var13_14 = null;
                            break block15;
                        }
                        allConstantStrings = stringParms > 0;
                        break block14;
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                        Object var13_16 = null;
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        if (!sawConstant) {
                            if (!allConstantStrings) return;
                        }
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item item = this.stack.getStackItem(0);
                        item.setUserValue((Object)Boolean.TRUE);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    if (!sawConstant) {
                        if (!allConstantStrings) throw throwable;
                    }
                    if (this.stack.getStackDepth() <= 0) throw throwable;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue((Object)Boolean.TRUE);
                    throw throwable;
                }
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (!sawConstant) {
                if (!allConstantStrings) return;
            }
            if (this.stack.getStackDepth() <= 0) return;
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)Boolean.TRUE);
            return;
        }
        Object var13_15 = null;
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (!sawConstant) {
            if (!allConstantStrings) return;
        }
        if (this.stack.getStackDepth() <= 0) return;
        OpcodeStack.Item item = this.stack.getStackItem(0);
        item.setUserValue((Object)Boolean.TRUE);
    }

    static {
        try {
            exceptionClass = Repository.lookupClass((String)"java/lang/Exception");
        }
        catch (ClassNotFoundException cnfe) {
            exceptionClass = null;
        }
    }
}

