/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class UseCharacterParameterizedMethod
extends BytecodeScanningDetector {
    private static Map<String, Integer> characterMethods = new HashMap<String, Integer>();
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public UseCharacterParameterizedMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext context) {
        try {
            this.stack = new OpcodeStack();
            if (context.getJavaClass().getMajor() >= 49) {
                characterMethods.put("java/lang/StringBuffer:append:(Ljava/lang/String;)Ljava/lang/StringBuffer;", Integer14.valueOf(0));
            }
            super.visitClassContext(context);
            Object var3_2 = null;
            this.stack = null;
            characterMethods.remove("java/lang/StringBuffer:append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            characterMethods.remove("java/lang/StringBuffer:append:(Ljava/lang/String;)Ljava/lang/StringBuffer;");
            throw throwable;
        }
    }

    private boolean prescreen(Method obj) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(obj);
        return bytecodeSet != null && (bytecodeSet.get(18) || bytecodeSet.get(19));
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            String key;
            Integer parmPos;
            this.stack.mergeJumps((DismantleBytecode)this);
            if ((seen == 182 || seen == 185) && (parmPos = characterMethods.get(key = this.getClassConstantOperand() + ":" + this.getNameConstantOperand() + ":" + this.getSigConstantOperand())) != null) {
                OpcodeStack.Item itm;
                String con;
                int stackPos = parmPos;
                if (this.stack.getStackDepth() > stackPos && (con = (String)(itm = this.stack.getStackItem(stackPos)).getConstant()) != null && con.length() == 1) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "UCPM_USE_CHARACTER_PARAMETERIZED_METHOD", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    static {
        characterMethods.put("java/lang/String:indexOf:(Ljava/lang/String;)I", Integer14.valueOf(0));
        characterMethods.put("java/lang/String:indexOf:(Ljava/lang/String;I)I", Integer14.valueOf(1));
        characterMethods.put("java/lang/String:lastIndexOf:(Ljava/lang/String;)I", Integer14.valueOf(0));
        characterMethods.put("java/lang/String:lastIndexOf:(Ljava/lang/String;I)I", Integer14.valueOf(1));
        characterMethods.put("java/io/PrintStream:print:(Ljava/lang/String;)V", Integer14.valueOf(0));
        characterMethods.put("java/io/PrintStream:println:(Ljava/lang/String;)V", Integer14.valueOf(0));
        characterMethods.put("java/io/StringWriter:write:(Ljava/lang/String;)V", Integer14.valueOf(0));
    }
}

