/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnrelatedCollectionContents
extends BytecodeScanningDetector {
    private static final Set<String> COLLECTION_CLASSES = new HashSet<String>();
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<String, Set<String>> memberCollections;
    private Map<Integer, Set<String>> localCollections;
    private Map<Integer, Set<Integer>> localScopeEnds;
    private Map<String, Set<SourceLineAnnotation>> memberSourceLineAnnotations;
    private Map<Integer, Set<SourceLineAnnotation>> localSourceLineAnnotations;

    public UnrelatedCollectionContents(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.memberCollections = new HashMap<String, Set<String>>();
            this.memberSourceLineAnnotations = new HashMap<String, Set<SourceLineAnnotation>>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.stack = null;
            this.memberCollections = null;
            this.memberSourceLineAnnotations = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.stack = null;
            this.memberCollections = null;
            this.memberSourceLineAnnotations = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            this.localCollections = new HashMap<Integer, Set<String>>();
            this.localScopeEnds = new HashMap<Integer, Set<Integer>>();
            this.localSourceLineAnnotations = new HashMap<Integer, Set<SourceLineAnnotation>>();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
            Object var3_2 = null;
            this.localCollections = null;
            this.localScopeEnds = null;
            this.localSourceLineAnnotations = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.localCollections = null;
            this.localScopeEnds = null;
            this.localSourceLineAnnotations = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            block12: {
                try {
                    this.stack.mergeJumps((DismantleBytecode)this);
                    Set<Integer> regs = this.localScopeEnds.remove(Integer14.valueOf(this.getPC()));
                    if (regs != null) {
                        for (Integer i : regs) {
                            this.localCollections.remove(i);
                            this.localSourceLineAnnotations.remove(i);
                        }
                    }
                    if (seen == 185) {
                        String className = this.getClassConstantOperand();
                        if (!COLLECTION_CLASSES.contains(className)) break block12;
                        String methodName = this.getNameConstantOperand();
                        String methodSig = this.getSigConstantOperand();
                        if ("add".equals(methodName) && "(Ljava/lang/Object;)Z".equals(methodSig)) {
                            if (this.stack.getStackDepth() > 1) {
                                OpcodeStack.Item colItm = this.stack.getStackItem(1);
                                OpcodeStack.Item addItm = this.stack.getStackItem(0);
                                this.checkAdd(colItm, addItm);
                            }
                            break block12;
                        }
                        if ("put".equals(methodName) && "(Ljava/lang/Object;Ljava/lang/Object;)Z".equals(methodSig) && this.stack.getStackDepth() > 2) {
                            OpcodeStack.Item colItm = this.stack.getStackItem(2);
                            OpcodeStack.Item addItm = this.stack.getStackItem(1);
                            this.checkAdd(colItm, addItm);
                        }
                        break block12;
                    }
                    if (seen == 83) {
                        if (this.stack.getStackDepth() > 2) {
                            OpcodeStack.Item arrayItm = this.stack.getStackItem(2);
                            OpcodeStack.Item addItm = this.stack.getStackItem(0);
                            this.checkAdd(arrayItm, addItm);
                        }
                        break block12;
                    }
                    if (seen != 58) break block12;
                    Integer reg = Integer14.valueOf(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen));
                    this.localCollections.remove(reg);
                    this.localSourceLineAnnotations.remove(reg);
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var9_12 = null;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    return;
                }
            }
            Object var9_11 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
    }

    private void checkAdd(OpcodeStack.Item colItm, OpcodeStack.Item addItm) throws ClassNotFoundException {
        int reg = colItm.getRegisterNumber();
        if (reg != -1) {
            Set<SourceLineAnnotation> pcs = this.localSourceLineAnnotations.get(Integer14.valueOf(reg));
            if (pcs == null) {
                pcs = new HashSet<SourceLineAnnotation>();
                this.localSourceLineAnnotations.put(Integer14.valueOf(reg), pcs);
            }
            pcs.add(SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this, (int)this.getPC()));
            Set<String> commonSupers = this.localCollections.get(Integer14.valueOf(reg));
            if (commonSupers != null) {
                this.mergeItem(commonSupers, pcs, addItm);
            } else {
                commonSupers = new HashSet<String>();
                this.localCollections.put(Integer14.valueOf(reg), commonSupers);
                this.addNewItem(commonSupers, addItm);
                Integer scopeEnd = Integer14.valueOf(RegisterUtils.getLocalVariableEndRange(this.getMethod().getLocalVariableTable(), reg, this.getNextPC()));
                Set<Integer> regs = this.localScopeEnds.get(scopeEnd);
                if (regs == null) {
                    regs = new HashSet<Integer>();
                    this.localScopeEnds.put(scopeEnd, regs);
                }
                regs.add(Integer14.valueOf(reg));
            }
        } else {
            XField field = colItm.getXField();
            if (field == null) {
                return;
            }
            Set<SourceLineAnnotation> sla = this.memberSourceLineAnnotations.get(field.getName());
            if (sla == null) {
                sla = new HashSet<SourceLineAnnotation>();
                this.memberSourceLineAnnotations.put(field.getName(), sla);
            }
            sla.add(SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
            Set<String> commonSupers = this.memberCollections.get(field.getName());
            if (commonSupers != null) {
                this.mergeItem(commonSupers, sla, addItm);
            } else {
                commonSupers = new HashSet<String>();
                this.memberCollections.put(field.getName(), commonSupers);
                this.addNewItem(commonSupers, addItm);
            }
        }
    }

    private void mergeItem(Set<String> supers, Set<SourceLineAnnotation> sla, OpcodeStack.Item addItm) throws ClassNotFoundException {
        if (supers.isEmpty()) {
            return;
        }
        HashSet<String> s = new HashSet<String>();
        this.addNewItem(s, addItm);
        if (s.isEmpty()) {
            return;
        }
        UnrelatedCollectionContents.intersection(supers, s);
        if (supers.isEmpty()) {
            BugInstance bug = new BugInstance((Detector)this, "UCC_UNRELATED_COLLECTION_CONTENTS", 2).addClass((PreorderVisitor)this);
            if (addItm.getRegisterNumber() != -1) {
                bug.addMethod((PreorderVisitor)this);
            }
            for (SourceLineAnnotation a : sla) {
                bug.addSourceLine(a);
            }
            this.bugReporter.reportBug(bug);
        }
    }

    private void addNewItem(Set<String> supers, OpcodeStack.Item addItm) throws ClassNotFoundException {
        JavaClass[] sups;
        JavaClass[] infs;
        String itemSignature = addItm.getSignature();
        if (itemSignature.length() == 0) {
            return;
        }
        if (itemSignature.charAt(0) == '[') {
            supers.add(itemSignature);
            return;
        }
        JavaClass cls = addItm.getJavaClass();
        if (cls == null || "java.lang.Object".equals(cls.getClassName())) {
            return;
        }
        supers.add(cls.getClassName());
        for (JavaClass inf : infs = cls.getAllInterfaces()) {
            String infName = inf.getClassName();
            if ("java.io.Serializable".equals(infName) || "java.lang.Cloneable".equals(infName)) continue;
            supers.add(inf.getClassName());
        }
        for (JavaClass sup : sups = cls.getSuperClasses()) {
            String name = sup.getClassName();
            if ("java.lang.Object".equals(name)) continue;
            supers.add(name);
        }
    }

    private static void intersection(Set<String> orig, Set<String> add) {
        Iterator<String> it = orig.iterator();
        while (it.hasNext()) {
            if (add.contains(it.next())) continue;
            it.remove();
        }
    }

    static {
        COLLECTION_CLASSES.add("java/util/Collection");
        COLLECTION_CLASSES.add("java/util/List");
        COLLECTION_CLASSES.add("java/util/Map");
        COLLECTION_CLASSES.add("java/util/Set");
        COLLECTION_CLASSES.add("java/util/SortedMap");
        COLLECTION_CLASSES.add("java/util/SortedSet");
    }
}

