/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class UnnecessaryStoreBeforeReturn
extends BytecodeScanningDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_STORE = 1;
    private static final int SEEN_LOAD = 2;
    private static final Set<Integer> branchInstructions = new HashSet<Integer>();
    private final BugReporter bugReporter;
    private Set<Integer> branchTargets;
    private Set<Integer> catchTargets;
    private int state;
    private int storeReg;

    public UnnecessaryStoreBeforeReturn(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.branchTargets = new HashSet<Integer>();
            this.catchTargets = new HashSet<Integer>();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.branchTargets = null;
            this.catchTargets = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.branchTargets = null;
            this.catchTargets = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        String sig = m.getSignature();
        Type t = Type.getReturnType((String)sig);
        if (!t.equals((Object)Type.VOID)) {
            this.state = 0;
            this.branchTargets.clear();
            CodeException[] ces = obj.getExceptionTable();
            this.catchTargets.clear();
            CodeException[] arr$ = ces;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                CodeException ce = arr$[i$];
                if (ce.getCatchType() == 0) continue;
                this.catchTargets.add(Integer14.valueOf(ce.getHandlerPC()));
            }
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (this.catchTargets.contains(Integer14.valueOf(this.getPC())) || !this.lookForStore(seen)) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (this.branchTargets.contains(Integer14.valueOf(this.getPC()))) {
                    this.state = 0;
                    break;
                }
                this.state = this.lookForLoad(seen) ? 2 : 0;
                break;
            }
            case 2: {
                if (seen >= 172 && seen <= 176) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "USBR_UNNECESSARY_STORE_BEFORE_RETURN", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
            }
        }
        if (branchInstructions.contains(Integer14.valueOf(seen))) {
            this.branchTargets.add(Integer14.valueOf(this.getBranchTarget()));
        }
    }

    private boolean lookForStore(int seen) {
        if (seen >= 54 && seen <= 58) {
            this.storeReg = this.getRegisterOperand();
        } else if (seen >= 59 && seen <= 62) {
            this.storeReg = seen - 59;
        } else if (seen >= 63 && seen <= 66) {
            this.storeReg = seen - 63;
        } else if (seen >= 67 && seen <= 70) {
            this.storeReg = seen - 67;
        } else if (seen >= 71 && seen <= 74) {
            this.storeReg = seen - 71;
        } else if (seen >= 75 && seen <= 78) {
            this.storeReg = seen - 75;
        } else {
            return false;
        }
        return true;
    }

    private boolean lookForLoad(int seen) {
        int loadReg;
        if (seen >= 21 && seen <= 25) {
            loadReg = this.getRegisterOperand();
        } else if (seen >= 26 && seen <= 29) {
            loadReg = seen - 26;
        } else if (seen >= 30 && seen <= 33) {
            loadReg = seen - 30;
        } else if (seen >= 34 && seen <= 37) {
            loadReg = seen - 34;
        } else if (seen >= 38 && seen <= 41) {
            loadReg = seen - 38;
        } else if (seen >= 42 && seen <= 45) {
            loadReg = seen - 42;
        } else {
            return false;
        }
        return this.storeReg == loadReg;
    }

    static {
        branchInstructions.add(Integer14.valueOf(167));
        branchInstructions.add(Integer14.valueOf(200));
        branchInstructions.add(Integer14.valueOf(153));
        branchInstructions.add(Integer14.valueOf(154));
        branchInstructions.add(Integer14.valueOf(155));
        branchInstructions.add(Integer14.valueOf(156));
        branchInstructions.add(Integer14.valueOf(157));
        branchInstructions.add(Integer14.valueOf(158));
        branchInstructions.add(Integer14.valueOf(159));
        branchInstructions.add(Integer14.valueOf(160));
        branchInstructions.add(Integer14.valueOf(161));
        branchInstructions.add(Integer14.valueOf(162));
        branchInstructions.add(Integer14.valueOf(163));
        branchInstructions.add(Integer14.valueOf(164));
        branchInstructions.add(Integer14.valueOf(165));
        branchInstructions.add(Integer14.valueOf(166));
        branchInstructions.add(Integer14.valueOf(198));
        branchInstructions.add(Integer14.valueOf(199));
    }
}

