/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantNameAndType;

public class SyncCollectionIterators
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private static Set<String> synchCollectionNames = new HashSet<String>();
    private static Set<String> mapToSetMethods;
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_SYNC = 1;
    private static final int SEEN_LOAD = 2;
    private int state;
    private Set<String> memberCollections;
    private Set<Integer> localCollections;
    private List<Object> monitorObjects;
    private OpcodeStack stack;
    private Object collectionInfo = null;

    public SyncCollectionIterators(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.memberCollections = new HashSet<String>();
            this.localCollections = new HashSet<Integer>();
            this.monitorObjects = new ArrayList<Object>();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.memberCollections = null;
            this.localCollections = null;
            this.monitorObjects = null;
            this.stack = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.memberCollections = null;
            this.localCollections = null;
            this.monitorObjects = null;
            this.stack = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        if (obj.getCode() != null) {
            this.state = 0;
            this.localCollections.clear();
            this.monitorObjects.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            switch (this.state) {
                case 0: {
                    if (seen == 184 && "java/util/Collections".equals(this.getClassConstantOperand())) {
                        if (!synchCollectionNames.contains(this.getNameConstantOperand())) break;
                        this.state = 1;
                        break;
                    }
                    if (seen == 25) {
                        int reg = this.getRegisterOperand();
                        if (!this.localCollections.contains(Integer14.valueOf(reg))) break;
                        this.collectionInfo = Integer14.valueOf(reg);
                        this.state = 2;
                        break;
                    }
                    if (seen >= 42 && seen <= 45) {
                        int reg = seen - 42;
                        if (!this.localCollections.contains(Integer14.valueOf(reg))) break;
                        this.collectionInfo = Integer14.valueOf(reg);
                        this.state = 2;
                        break;
                    }
                    if (seen != 180) break;
                    ConstantFieldref ref = (ConstantFieldref)this.getConstantRefOperand();
                    ConstantNameAndType nandt = (ConstantNameAndType)this.getConstantPool().getConstant(ref.getNameAndTypeIndex());
                    String fieldName = nandt.getName(this.getConstantPool());
                    if (!this.memberCollections.contains(fieldName)) break;
                    this.collectionInfo = fieldName;
                    this.state = 2;
                    break;
                }
                case 1: {
                    ConstantNameAndType nandt;
                    if (seen == 58) {
                        int reg = this.getRegisterOperand();
                        this.localCollections.add(Integer14.valueOf(reg));
                    } else if (seen >= 75 && seen <= 78) {
                        int reg = seen - 75;
                        this.localCollections.add(Integer14.valueOf(reg));
                    } else if (seen == 181) {
                        ConstantFieldref ref = (ConstantFieldref)this.getConstantRefOperand();
                        nandt = (ConstantNameAndType)this.getConstantPool().getConstant(ref.getNameAndTypeIndex());
                        this.memberCollections.add(nandt.getName(this.getConstantPool()));
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (seen == 185) {
                        String calledClass = this.getClassConstantOperand();
                        if ("java/lang/Map".equals(calledClass)) {
                            if (mapToSetMethods.contains(this.getNameConstantOperand())) {
                                this.state = 2;
                                break;
                            }
                            this.state = 0;
                            break;
                        }
                        if (calledClass.startsWith("java/util/")) {
                            if (!"iterator".equals(this.getNameConstantOperand())) break;
                            if (this.monitorObjects.isEmpty()) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "SCI_SYNCHRONIZED_COLLECTION_ITERATORS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                                this.state = 0;
                                break;
                            }
                            Object syncObj = this.monitorObjects.get(this.monitorObjects.size() - 1);
                            if (!this.syncIsMap(syncObj, this.collectionInfo)) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "SCI_SYNCHRONIZED_COLLECTION_ITERATORS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                            this.state = 0;
                            break;
                        }
                        this.state = 0;
                        break;
                    }
                    this.state = 0;
                }
            }
            if (seen == 194) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    int reg = item.getRegisterNumber();
                    if (reg >= 0) {
                        this.monitorObjects.add(Integer14.valueOf(reg));
                    } else {
                        XField field = item.getXField();
                        if (field != null) {
                            this.monitorObjects.add(field.getName());
                        }
                    }
                }
            } else if (seen == 195 && this.monitorObjects.size() > 0) {
                this.monitorObjects.remove(this.monitorObjects.size() - 1);
            }
            Object var6_13 = null;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }

    private boolean syncIsMap(Object syncObject, Object collectionInfo) {
        if (syncObject != null && collectionInfo != null && syncObject.getClass().equals(collectionInfo.getClass())) {
            return syncObject.equals(collectionInfo);
        }
        return true;
    }

    static {
        synchCollectionNames.add("synchronizedSet");
        synchCollectionNames.add("synchronizedMap");
        synchCollectionNames.add("synchronizedList");
        synchCollectionNames.add("synchronizedSortedSet");
        synchCollectionNames.add("synchronizedSortedMap");
        mapToSetMethods = new HashSet<String>();
        mapToSetMethods.add("keySet");
        mapToSetMethods.add("entrySet");
        mapToSetMethods.add("values");
    }
}

