/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class StaticArrayCreatedInMethod
extends BytecodeScanningDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_ARRAY_SIZE = 1;
    private static final int SEEN_NEWARRAY = 2;
    private static final int SEEN_DUP = 3;
    private static final int SEEN_INDEX = 4;
    private static final int SEEN_LDC = 5;
    private static final int SEEN_INDEX_STORE = 6;
    private BugReporter bugReporter;
    private int arraySize;
    private int storeCount;
    private int state;

    public StaticArrayCreatedInMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            super.visitClassContext(classContext);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public void visitCode(Code obj) {
        if (!"<clinit>".equals(this.getMethodName())) {
            this.state = 0;
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen == 16) {
                    this.arraySize = this.getIntConstant();
                    if (this.arraySize <= 0) break;
                    this.state = 1;
                    break;
                }
                if (seen < 2 || seen > 8) break;
                this.arraySize = seen - 2 - 1;
                if (this.arraySize <= 0) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 189 || seen == 188) {
                    this.state = 2;
                    this.storeCount = 0;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if (seen == 89) {
                    this.state = 3;
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                int index;
                if (seen == 16) {
                    index = this.getIntConstant();
                } else if (seen >= 2 && seen <= 8) {
                    index = seen - 2 - 1;
                } else {
                    this.state = 0;
                    return;
                }
                if (index != this.storeCount) {
                    this.state = 0;
                    break;
                }
                this.state = 4;
                break;
            }
            case 4: {
                if (seen == 18 || seen == 19) {
                    this.state = 5;
                    break;
                }
                this.state = 0;
                break;
            }
            case 5: {
                if (seen < 79 || seen > 86) break;
                if (++this.storeCount == this.arraySize) {
                    this.state = 6;
                    break;
                }
                this.state = 2;
                break;
            }
            case 6: {
                if (seen == 58 || seen >= 75 && seen <= 78) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SACM_STATIC_ARRAY_CREATED_IN_METHOD", this.arraySize < 3 ? 3 : (this.arraySize < 10 ? 2 : 1)).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC()));
                }
                this.state = 0;
            }
        }
    }
}

