/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class SluggishGui
extends BytecodeScanningDetector {
    private static final Set<String> expensiveCalls = new HashSet<String>();
    private BugReporter bugReporter;
    private Set<String> expensiveThisCalls;
    private Set<JavaClass> guiInterfaces;
    private Map<Code, Method> listenerCode;
    private String methodName;
    private String methodSig;
    private boolean isListenerMethod = false;
    private boolean methodReported = false;

    public SluggishGui(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            block5: {
                try {
                    JavaClass[] infs;
                    this.guiInterfaces = new HashSet<JavaClass>();
                    JavaClass cls = classContext.getJavaClass();
                    JavaClass[] arr$ = infs = cls.getAllInterfaces();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        JavaClass inf = arr$[i$];
                        String name = inf.getClassName();
                        if (!name.startsWith("java.awt.") && !name.startsWith("javax.swing.") || !name.endsWith("Listener")) continue;
                        this.guiInterfaces.add(inf);
                    }
                    if (this.guiInterfaces.size() <= 0) break block5;
                    this.listenerCode = new LinkedHashMap<Code, Method>();
                    this.expensiveThisCalls = new HashSet<String>();
                    super.visitClassContext(classContext);
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    Object var10_11 = null;
                    this.guiInterfaces = null;
                    this.listenerCode = null;
                    this.expensiveThisCalls = null;
                }
            }
            Object var10_10 = null;
            this.guiInterfaces = null;
            this.listenerCode = null;
            this.expensiveThisCalls = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.guiInterfaces = null;
            this.listenerCode = null;
            this.expensiveThisCalls = null;
            throw throwable;
        }
    }

    public void visitAfter(JavaClass obj) {
        this.isListenerMethod = true;
        Iterator<Code> i$ = this.listenerCode.keySet().iterator();
        while (i$.hasNext()) {
            Code l = i$.next();
            this.methodReported = false;
            super.visitCode(l);
        }
        super.visitAfter(obj);
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
        this.methodSig = obj.getSignature();
    }

    public void visitCode(Code obj) {
        Iterator<JavaClass> i$ = this.guiInterfaces.iterator();
        while (i$.hasNext()) {
            Method[] methods;
            JavaClass inf = i$.next();
            Method[] arr$ = methods = inf.getMethods();
            int len$ = arr$.length;
            for (int i$2 = 0; i$2 < len$; ++i$2) {
                Method m = arr$[i$2];
                if (!m.getName().equals(this.methodName) || !m.getSignature().equals(this.methodSig)) continue;
                this.listenerCode.put(obj, this.getMethod());
                return;
            }
        }
        this.isListenerMethod = false;
        this.methodReported = false;
        super.visitCode(obj);
    }

    public void sawOpcode(int seen) {
        if (this.methodReported) {
            return;
        }
        if (seen == 185 || seen == 182 || seen == 183 || seen == 184) {
            String thisMethodInfo;
            String clsName = this.getClassConstantOperand();
            String methodName = this.getNameConstantOperand();
            String methodInfo = clsName + ":" + methodName;
            String string = thisMethodInfo = clsName.equals(this.getClassName()) ? methodName + ":" + this.methodSig : "0";
            if (expensiveCalls.contains(methodInfo) || this.expensiveThisCalls.contains(thisMethodInfo)) {
                if (this.isListenerMethod) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SG_SLUGGISH_GUI", 2).addClass((PreorderVisitor)this).addMethod(this.getClassContext().getJavaClass(), this.listenerCode.get(this.getCode())));
                } else {
                    this.expensiveThisCalls.add(this.getMethodName() + ":" + this.getMethodSig());
                }
                this.methodReported = true;
            }
        }
    }

    static {
        expensiveCalls.add("java/io/BufferedOutputStream:<init>");
        expensiveCalls.add("java/io/DataOutputStream:<init>");
        expensiveCalls.add("java/io/FileOutputStream:<init>");
        expensiveCalls.add("java/io/ObjectOutputStream:<init>");
        expensiveCalls.add("java/io/PipedOutputStream:<init>");
        expensiveCalls.add("java/io/BufferedInputStream:<init>");
        expensiveCalls.add("java/io/DataInputStream:<init>");
        expensiveCalls.add("java/io/FileInputStream:<init>");
        expensiveCalls.add("java/io/ObjectInputStream:<init>");
        expensiveCalls.add("java/io/PipedInputStream:<init>");
        expensiveCalls.add("java/io/BufferedWriter:<init>");
        expensiveCalls.add("java/io/FileWriter:<init>");
        expensiveCalls.add("java/io/OutpuStreamWriter:<init>");
        expensiveCalls.add("java/io/BufferedReader:<init>");
        expensiveCalls.add("java/io/FileReader:<init>");
        expensiveCalls.add("java/io/InputStreamReader:<init>");
        expensiveCalls.add("java/io/RandomAccessFile:<init>");
        expensiveCalls.add("java/lang/Class:getResourceAsStream");
        expensiveCalls.add("java/lang/ClassLoader:getResourceAsStream");
        expensiveCalls.add("java/lang/ClassLoader:loadClass");
        expensiveCalls.add("java/sql/DriverManager:getConnection");
        expensiveCalls.add("java/sql/Connection:createStatement");
        expensiveCalls.add("java/sql/Connection:prepareStatement");
        expensiveCalls.add("java/sql/Connection:prepareCall");
        expensiveCalls.add("javax/sql/DataSource:getConnection");
        expensiveCalls.add("javax/xml/parsers/DocumentBuilder:parse");
        expensiveCalls.add("javax/xml/parsers/DocumentBuilder:parse");
        expensiveCalls.add("javax/xml/parsers/SAXParser:parse");
        expensiveCalls.add("javax/xml/transform/Transformer:transform");
    }
}

