/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class SloppyClassReflection
extends BytecodeScanningDetector {
    private static final int COLLECT = -1;
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_LDC = 1;
    private final BugReporter bugReporter;
    private Set<String> refClasses;
    private int state;
    private String clsName;

    public SloppyClassReflection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.refClasses = new HashSet<String>();
            this.refClasses.add(classContext.getJavaClass().getClassName());
            this.state = -1;
            super.visitClassContext(classContext);
            this.state = 0;
            super.visitClassContext(classContext);
            Object var3_2 = null;
            this.refClasses = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.refClasses = null;
            throw throwable;
        }
    }

    public void visitMethod(Method obj) {
        if ("<clinit>".equals(obj.getName())) {
            return;
        }
        if (this.state == -1) {
            LocalVariable[] lvs;
            Type[] argTypes;
            Type[] arr$ = argTypes = obj.getArgumentTypes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Type t = arr$[i$];
                this.addType(t);
            }
            Type resultType = obj.getReturnType();
            this.addType(resultType);
            LocalVariableTable lvt = obj.getLocalVariableTable();
            if (lvt != null && (lvs = lvt.getLocalVariableTable()) != null) {
                LocalVariable[] arr$2 = lvs;
                int len$2 = arr$2.length;
                for (int i$ = 0; i$ < len$2; ++i$) {
                    LocalVariable lv = arr$2[i$];
                    if (lv == null) continue;
                    Type t = Type.getType((String)lv.getSignature());
                    this.addType(t);
                }
            }
        } else {
            this.state = 0;
        }
        super.visitMethod(obj);
    }

    public void visitField(Field obj) {
        if (this.state == -1) {
            Type t = obj.getType();
            this.addType(t);
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case -1: {
                Type[] argTypes;
                if (seen != 184 && seen != 182 && seen != 185 && seen != 183) break;
                this.refClasses.add(this.getClassConstantOperand());
                String signature = this.getSigConstantOperand();
                Type[] arr$ = argTypes = Type.getArgumentTypes((String)signature);
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Type t = arr$[i$];
                    this.addType(t);
                }
                Type resultType = Type.getReturnType((String)signature);
                this.addType(resultType);
                break;
            }
            case 0: {
                Constant c;
                if (seen != 18 && seen != 19 || !((c = this.getConstantRefOperand()) instanceof ConstantString)) break;
                this.clsName = ((ConstantString)c).getBytes(this.getConstantPool());
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 184 && "forName".equals(this.getNameConstantOperand()) && "java/lang/Class".equals(this.getClassConstantOperand()) && this.refClasses.contains(this.clsName)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SCR_SLOPPY_CLASS_REFLECTION", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = 0;
            }
        }
    }

    private void addType(Type t) {
        String signature = t.getSignature();
        if (signature.charAt(0) == 'L') {
            this.refClasses.add(signature.substring(1, signature.length() - 1));
        }
    }
}

