/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.CodeByteUtils;
import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.LVTHelper;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;

public class SillynessPotPourri
extends BytecodeScanningDetector {
    private static final Set<String> collectionInterfaces = new HashSet<String>();
    private static JavaClass calendarClass;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private int[] lastPCs;
    private int lastOpcode;
    private int lastReg;
    private boolean lastIfEqWasBoolean;
    private boolean lastLoadWasString;
    private Map<Integer, Set<Integer>> branchTargets;

    public SillynessPotPourri(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitField(Field field) {
        if ("serialVersionUID".equals(field.getName()) && (field.getAccessFlags() & 8) != 0 && (field.getAccessFlags() & 2) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_SERIALVER_SHOULD_BE_PRIVATE", 3).addClass((PreorderVisitor)this).addField((PreorderVisitor)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.lastPCs = new int[4];
            this.branchTargets = new HashMap<Integer, Set<Integer>>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.lastPCs = null;
            this.branchTargets = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.lastOpcode = -1;
        this.lastReg = -1;
        this.lastIfEqWasBoolean = false;
        this.lastLoadWasString = false;
        Arrays.fill(this.lastPCs, -1);
        this.branchTargets.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        int reg = -1;
        String userValue = null;
        try {
            String className;
            OpcodeStack.Item item;
            byte[] bytes;
            this.stack.mergeJumps((DismantleBytecode)this);
            if (seen >= 153 && seen <= 167 || seen == 198 || seen == 199 || seen == 200) {
                Integer branchTarget = Integer14.valueOf(this.getBranchTarget());
                Set<Integer> branchInsSet = this.branchTargets.get(branchTarget);
                if (branchInsSet == null) {
                    branchInsSet = new HashSet<Integer>();
                    this.branchTargets.put(branchTarget, branchInsSet);
                }
                branchInsSet.add(Integer14.valueOf(this.getPC()));
            }
            if ((seen == 153 || seen == 158 || seen == 154) && this.lastLoadWasString && this.lastPCs[0] != -1) {
                int mpoolIndex;
                ConstantMethodref cmr;
                int nandtIndex;
                ConstantPool pool;
                ConstantNameAndType cnt;
                int nextOp;
                int brOffset;
                bytes = this.getCode().getCode();
                int loadIns = CodeByteUtils.getbyte(bytes, this.lastPCs[2]);
                int n = brOffset = loadIns == 25 ? 11 : 10;
                if ((loadIns >= 42 && loadIns <= 45 || loadIns == 25) && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && CodeByteUtils.getbyte(bytes, this.lastPCs[2]) == loadIns && CodeByteUtils.getbyte(bytes, this.lastPCs[1]) == 198 && CodeByteUtils.getbyte(bytes, this.lastPCs[0]) == loadIns && (loadIns != 25 || CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1) == CodeByteUtils.getbyte(bytes, this.lastPCs[0] + 1)) && (seen == 154 ? CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1) > brOffset : CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1) == brOffset) && (nextOp = CodeByteUtils.getbyte(bytes, this.getNextPC())) != 167 && nextOp != 200 && "length".equals((cnt = (ConstantNameAndType)(pool = this.getConstantPool()).getConstant(nandtIndex = (cmr = (ConstantMethodref)pool.getConstant(mpoolIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_SUSPECT_STRING_TEST", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            if ((seen == 153 || seen == 154 || seen == 157) && this.stack.getStackDepth() == 1 && "size".equals((item = this.stack.getStackItem(0)).getUserValue())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_ISEMPTY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            if (seen == 154) {
                int lengthIndex;
                ConstantMethodref lengthMR;
                int nandtIndex;
                ConstantNameAndType cnt;
                int toStringIndex;
                ConstantPool pool;
                ConstantMethodref toStringMR;
                String toStringCls;
                bytes = this.getCode().getCode();
                if (this.lastPCs[2] != -1 && CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && CodeByteUtils.getbyte(bytes, this.lastPCs[2]) == 182 && (toStringCls = (toStringMR = (ConstantMethodref)(pool = this.getConstantPool()).getConstant(toStringIndex = CodeByteUtils.getshort(bytes, this.lastPCs[2] + 1))).getClass(pool)).startsWith("java.lang.StringBu") && "toString".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = toStringMR.getNameAndTypeIndex())).getName(pool)) && "length".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = (lengthMR = (ConstantMethodref)pool.getConstant(lengthIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_STRINGBUILDER_LENGTH", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            } else if (seen == 153) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    this.lastIfEqWasBoolean = "Z".equals(itm.getElementSignature());
                }
                bytes = this.getCode().getCode();
                if (this.lastPCs[1] != -1) {
                    int lengthIndex;
                    ConstantMethodref lengthMR;
                    int nandtIndex;
                    ConstantNameAndType cnt;
                    int consIndex;
                    Constant c;
                    int toStringIndex;
                    ConstantPool pool;
                    ConstantMethodref toStringMR;
                    String toStringCls;
                    int loadIns = CodeByteUtils.getbyte(bytes, this.lastPCs[2]);
                    if (CodeByteUtils.getbyte(bytes, this.lastPCs[3]) == 182 && (loadIns == 18 || loadIns == 19) && CodeByteUtils.getbyte(bytes, this.lastPCs[1]) == 182 && (toStringCls = (toStringMR = (ConstantMethodref)(pool = this.getConstantPool()).getConstant(toStringIndex = CodeByteUtils.getshort(bytes, this.lastPCs[1] + 1))).getClass(pool)).startsWith("java.lang.StringBu") && (c = pool.getConstant(consIndex = CodeByteUtils.getbyte(bytes, this.lastPCs[2] + 1))) instanceof ConstantString && "".equals(((ConstantString)c).getBytes(pool)) && "toString".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = toStringMR.getNameAndTypeIndex())).getName(pool)) && "equals".equals((cnt = (ConstantNameAndType)pool.getConstant(nandtIndex = (lengthMR = (ConstantMethodref)pool.getConstant(lengthIndex = CodeByteUtils.getshort(bytes, this.lastPCs[3] + 1))).getNameAndTypeIndex())).getName(pool))) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_STRINGBUILDER_LENGTH", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            } else if (seen == 172 && this.lastIfEqWasBoolean) {
                bytes = this.getCode().getCode();
                if (this.lastPCs[0] != -1 && (0xFF & bytes[this.lastPCs[3]]) == 3 && (0xFF & bytes[this.lastPCs[2]]) == 167 && (0xFF & bytes[this.lastPCs[1]]) == 4 && (0xFF & bytes[this.lastPCs[0]]) == 153 && this.getMethod().getSignature().endsWith("Z")) {
                    boolean bug = true;
                    Set<Integer> branchInsSet = this.branchTargets.get(Integer14.valueOf(this.lastPCs[1]));
                    if (branchInsSet != null) {
                        bug = false;
                    }
                    if ((branchInsSet = this.branchTargets.get(Integer14.valueOf(this.lastPCs[3]))) != null && branchInsSet.size() > 1) {
                        bug = false;
                    }
                    if (bug) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USELESS_TRINARY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            } else if (seen == 20) {
                Constant con = this.getConstantRefOperand();
                if (con instanceof ConstantDouble) {
                    double d = ((ConstantDouble)con).getBytes();
                    double piDelta = Math.abs(d - Math.PI);
                    double eDelta = Math.abs(d - Math.E);
                    if (piDelta > 0.0 && piDelta < 0.002 || eDelta > 0.0 && eDelta < 0.002) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_MATH_CONSTANT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            } else if (seen == 151) {
                if (this.stack.getStackDepth() > 1) {
                    item = this.stack.getStackItem(0);
                    Double d1 = (Double)item.getConstant();
                    item = this.stack.getStackItem(1);
                    Double d2 = (Double)item.getConstant();
                    if (d1 != null && d1.isNaN() || d2 != null && d2.isNaN()) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_ISNAN", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            } else if (seen == 149) {
                if (this.stack.getStackDepth() > 1) {
                    item = this.stack.getStackItem(0);
                    Float f1 = (Float)item.getConstant();
                    item = this.stack.getStackItem(1);
                    Float f2 = (Float)item.getConstant();
                    if (f1 != null && f1.isNaN() || f2 != null && f2.isNaN()) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_ISNAN", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            } else if (seen >= 75 && seen <= 78 || seen == 58) {
                reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                if (seen == this.lastOpcode && reg == this.lastReg) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_STUTTERED_ASSIGNMENT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            } else if (seen >= 42 && seen <= 78 || seen == 25) {
                LocalVariable lv;
                this.lastLoadWasString = false;
                LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
                if (lvt != null && (lv = LVTHelper.getLocalVariableAtPC((LocalVariableTable)lvt, (int)RegisterUtils.getALoadReg((DismantleBytecode)this, seen), (int)this.getPC())) != null) {
                    this.lastLoadWasString = "Ljava/lang/String;".equals(lv.getSignature());
                }
            } else if (seen >= 3 && seen <= 6) {
                String tca;
                if (this.stack.getStackDepth() > 0 && "toCharArray".equals(tca = (String)(item = this.stack.getStackItem(0)).getUserValue())) {
                    userValue = "iconst";
                }
            } else if (seen == 52) {
                String ic;
                if (this.stack.getStackDepth() > 0 && "iconst".equals(ic = (String)(item = this.stack.getStackItem(0)).getUserValue())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_CHARAT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            } else if (seen == 184) {
                className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                if ("java/lang/System".equals(className) && "getProperties".equals(methodName)) {
                    userValue = "getProperties";
                }
            } else if (seen == 182) {
                OpcodeStack.Item item2;
                className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                if ("java/util/BitSet".equals(className)) {
                    OpcodeStack.Item item3;
                    Object o;
                    if (("clear".equals(methodName) || "flip".equals(methodName) || "get".equals(methodName) || "set".equals(methodName)) && this.stack.getStackDepth() > 0 && (o = (item3 = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (Integer)o < 0) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_NEGATIVE_BITSET_ITEM", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("java/lang/String".equals(className)) {
                    OpcodeStack.Item item4;
                    if ("intern".equals(methodName)) {
                        OpcodeStack.Item item5;
                        String owningMethod = this.getMethod().getName();
                        if (!"<clinit>".equals(owningMethod) && this.stack.getStackDepth() > 0 && (item5 = this.stack.getStackItem(0)).getConstant() != null) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_INTERN_ON_CONSTANT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    } else if ("toCharArray".equals(methodName)) {
                        userValue = "toCharArray";
                    } else if ("toLowerCase".equals(methodName) || "toUpperCase".equals(methodName)) {
                        userValue = "IgnoreCase";
                    } else if (("equalsIgnoreCase".equals(methodName) || "compareToIgnoreCase".equals(methodName)) && this.stack.getStackDepth() > 1 && "IgnoreCase".equals((item4 = this.stack.getStackItem(1)).getUserValue())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USELESS_CASING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("equals(Ljava/lang/Object;)Z".equals(methodName + this.getSigConstantOperand())) {
                    try {
                        JavaClass cls = Repository.lookupClass((String)className);
                        if (cls.isEnum()) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_EQUALS_ON_ENUM", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                    }
                } else if ("java/lang/Boolean".equals(className) && "booleanValue".equals(methodName)) {
                    byte[] bytes2;
                    int ifeq;
                    int range1Size;
                    if (this.lastPCs[0] != -1 && (range1Size = this.lastPCs[2] - this.lastPCs[0]) == this.getNextPC() - this.lastPCs[3] && (ifeq = 0xFF & (bytes2 = this.getCode().getCode())[this.lastPCs[2]]) == 153) {
                        int start1 = this.lastPCs[0];
                        int start2 = this.lastPCs[3];
                        boolean found = true;
                        for (int i = 0; i < range1Size; ++i) {
                            if (bytes2[start1 + i] == bytes2[start2 + i]) continue;
                            found = false;
                            break;
                        }
                        if (found) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_INVALID_BOOLEAN_NULL_CHECK", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                } else if (("java/util/GregorianCalendar".equals(className) || "java/util/Calendar".equals(className)) && ("after".equals(methodName) || "before".equals(methodName))) {
                    OpcodeStack.Item item6;
                    String itemSig;
                    if (!(this.stack.getStackDepth() <= 1 || "Ljava/lang/Object;".equals(itemSig = (item6 = this.stack.getStackItem(0)).getSignature()) || "Ljava/util/Calendar;".equals(itemSig) || "Ljava/util/GregorianCalendar;".equals(itemSig))) {
                        try {
                            JavaClass cls = Repository.lookupClass((String)itemSig.substring(1, itemSig.length() - 1));
                            if (!cls.instanceOf(calendarClass)) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_INVALID_CALENDAR_COMPARE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.bugReporter.reportMissingClass(cnfe);
                        }
                    }
                } else if ("java/util/Properties".equals(className) && ("get".equals(methodName) || "getProperty".equals(methodName)) && this.stack.getStackDepth() > 1 && "getProperties".equals((item2 = this.stack.getStackItem(1)).getUserValue())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_GETPROPERTY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            } else if (seen == 183) {
                OpcodeStack.Item item7;
                Object constant;
                className = this.getClassConstantOperand();
                if ("java/lang/StringBuffer".equals(className) || "java/lang/StringBuilder".equals(className)) {
                    String methodName = this.getNameConstantOperand();
                    if ("<init>".equals(methodName)) {
                        OpcodeStack.Item item8;
                        String con;
                        String signature = this.getSigConstantOperand();
                        if ("(I)V".equals(signature)) {
                            int parm;
                            OpcodeStack.Item item9;
                            Object o;
                            if (this.lastOpcode == 16 && this.stack.getStackDepth() > 0 && (o = (item9 = this.stack.getStackItem(0)).getConstant()) instanceof Integer && (parm = ((Integer)o).intValue()) > 32 && parm < 127 && parm != 64 && parm % 10 != 0 && parm % 5 != 0) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_NO_CHAR_SB_CTOR", 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                        } else if ("(Ljava/lang/String;)V".equals(signature) && this.stack.getStackDepth() > 0 && "".equals(con = (String)(item8 = this.stack.getStackItem(0)).getConstant())) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_STRINGBUFFER_WITH_EMPTY_STRING", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                } else if ("java/math/BigDecimal".equals(className) && this.stack.getStackDepth() > 0 && (constant = (item7 = this.stack.getStackItem(0)).getConstant()) instanceof Double) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_BIGDECIMAL_STRING_CTOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            } else if (seen == 185) {
                OpcodeStack.Item item10;
                String method;
                className = this.getClassConstantOperand();
                if ("java/util/Map".equals(className)) {
                    String method2 = this.getNameConstantOperand();
                    if ("keySet".equals(method2)) {
                        userValue = "keySet";
                    }
                } else if ("java/util/Set".equals(className) && "contains".equals(method = this.getNameConstantOperand()) && this.stack.getStackDepth() >= 2 && "keySet".equals((item10 = this.stack.getStackItem(1)).getUserValue())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "SPP_USE_CONTAINSKEY", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                if (collectionInterfaces.contains(className) && "size".equals(method = this.getNameConstantOperand())) {
                    userValue = "size";
                }
            }
            Object var17_64 = null;
        }
        catch (Throwable throwable) {
            Object var17_65 = null;
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (userValue != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue(userValue);
            }
            this.lastOpcode = seen;
            this.lastReg = reg;
            System.arraycopy(this.lastPCs, 1, this.lastPCs, 0, 3);
            this.lastPCs[3] = this.getPC();
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (userValue != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue(userValue);
        }
        this.lastOpcode = seen;
        this.lastReg = reg;
        System.arraycopy(this.lastPCs, 1, this.lastPCs, 0, 3);
        this.lastPCs[3] = this.getPC();
    }

    static {
        collectionInterfaces.add("java/util/Collection");
        collectionInterfaces.add("java/util/List");
        collectionInterfaces.add("java/util/Set");
        collectionInterfaces.add("java/util/SortedSet");
        collectionInterfaces.add("java/util/Map");
        collectionInterfaces.add("java/util/SortedMap");
        try {
            calendarClass = Repository.lookupClass((String)"java/util/Calendar");
        }
        catch (ClassNotFoundException cnfe) {
            calendarClass = null;
        }
    }
}

