/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.generic.Type;

public class Section508Compliance
extends BytecodeScanningDetector {
    private static JavaClass windowClass;
    private static JavaClass componentClass;
    private static JavaClass jcomponentClass;
    private static JavaClass accessibleClass;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<XField> fieldLabels;
    private Map<Integer, SourceLineAnnotation> localLabels;

    public Section508Compliance(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass cls;
            if (jcomponentClass != null && accessibleClass != null && (cls = classContext.getJavaClass()).instanceOf(jcomponentClass) && !cls.implementationOf(accessibleClass)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NON_ACCESSIBLE_JCOMPONENT", 2).addClass(cls));
            }
            this.stack = new OpcodeStack();
            this.fieldLabels = new HashSet<XField>();
            this.localLabels = new HashMap<Integer, SourceLineAnnotation>();
            super.visitClassContext(classContext);
            Iterator<XField> i$ = this.fieldLabels.iterator();
            while (i$.hasNext()) {
                XField fa = i$.next();
                this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NO_SETLABELFOR", 2).addClass((PreorderVisitor)this).addField(fa));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack = null;
            this.fieldLabels = null;
            this.localLabels = null;
        }
    }

    public void visitField(Field obj) {
        String fieldSig = obj.getSignature();
        if ("Ljavax/swing/JLabel;".equals(fieldSig)) {
            FieldAnnotation fa = FieldAnnotation.fromVisitedField((PreorderVisitor)this);
            this.fieldLabels.add(XFactory.createXField((FieldAnnotation)fa));
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localLabels.clear();
        super.visitCode(obj);
        Iterator<SourceLineAnnotation> i$ = this.localLabels.values().iterator();
        while (i$.hasNext()) {
            SourceLineAnnotation sla = i$.next();
            BugInstance bug = new BugInstance((Detector)this, "S508C_NO_SETLABELFOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
            if (sla != null) {
                bug.addSourceLine(sla);
            }
            this.bugReporter.reportBug(bug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean sawTextLabel = false;
        try {
            String className;
            OpcodeStack.Item item;
            this.stack.mergeJumps((DismantleBytecode)this);
            if (seen == 58 || seen >= 75 && seen <= 78) {
                if (this.stack.getStackDepth() > 0 && "Ljavax/swing/JLabel;".equals((item = this.stack.getStackItem(0)).getSignature()) && item.getUserValue() != null) {
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    this.localLabels.put(Integer14.valueOf(reg), SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this));
                }
            } else if (seen == 181) {
                if (this.stack.getStackDepth() > 0 && (item = this.stack.getStackItem(0)).getUserValue() == null) {
                    FieldAnnotation fa = new FieldAnnotation(this.getDottedClassName(), this.getNameConstantOperand(), this.getSigConstantOperand(), false);
                    this.fieldLabels.remove(XFactory.createXField((FieldAnnotation)fa));
                }
            } else if (seen == 183) {
                String signature;
                className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                if ("javax/swing/JLabel".equals(className) && "<init>".equals(methodName) && (signature = this.getSigConstantOperand()).indexOf("Ljava/lang/String;") >= 0) {
                    sawTextLabel = true;
                }
            } else if (seen == 182) {
                OpcodeStack.Item item2;
                className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                if ("java/awt/Container".equals(className)) {
                    OpcodeStack.Item item3;
                    if ("setLayout".equals(methodName) && this.stack.getStackDepth() > 0 && (item3 = this.stack.getStackItem(0)).isNull()) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NULL_LAYOUT", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("javax/swing/JLabel".equals(className)) {
                    if ("setLabelFor".equals(methodName) && this.stack.getStackDepth() > 1) {
                        OpcodeStack.Item item4 = this.stack.getStackItem(1);
                        XField field = item4.getXField();
                        if (field != null) {
                            this.fieldLabels.remove(field);
                        } else {
                            int reg = item4.getRegisterNumber();
                            if (reg >= 0) {
                                this.localLabels.remove(Integer14.valueOf(reg));
                            }
                        }
                    }
                } else if ("setSize".equals(methodName)) {
                    JavaClass cls;
                    int argCount = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
                    if (windowClass != null && this.stack.getStackDepth() > argCount && (cls = (item2 = this.stack.getStackItem(argCount)).getJavaClass()).instanceOf(windowClass)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_NO_SETSIZE", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                if ("setBackground".equals(methodName) || "setForeground".equals(methodName)) {
                    int argCount = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
                    if (this.stack.getStackDepth() > argCount) {
                        item2 = this.stack.getStackItem(argCount);
                        JavaClass cls = item2.getJavaClass();
                        if (jcomponentClass != null && cls.instanceOf(jcomponentClass) || componentClass != null && cls.instanceOf(componentClass)) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "S508C_SET_COMP_COLOR", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (sawTextLabel && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    static {
        try {
            windowClass = Repository.lookupClass((String)"java/awt/Window");
        }
        catch (ClassNotFoundException cnfe) {
            windowClass = null;
        }
        try {
            componentClass = Repository.lookupClass((String)"javax/awt/Component");
        }
        catch (ClassNotFoundException cnfe) {
            componentClass = null;
        }
        try {
            jcomponentClass = Repository.lookupClass((String)"javax/swing/JComponent");
        }
        catch (ClassNotFoundException cnfe) {
            jcomponentClass = null;
        }
        try {
            accessibleClass = Repository.lookupClass((String)"javax.accessibility.Accessible");
        }
        catch (ClassNotFoundException cnfe) {
            accessibleClass = null;
        }
    }
}

