/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.bcel.classfile.Code;

public class SQLInLoop
extends BytecodeScanningDetector {
    private static final Set<String> queryClasses = new HashSet<String>();
    private static final Set<String> queryMethods;
    private BugReporter bugReporter;
    List<Integer> queryLocations;
    List<LoopLocation> loops;

    public SQLInLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.queryLocations = new ArrayList<Integer>();
            this.loops = new ArrayList<LoopLocation>();
            super.visitClassContext(classContext);
        }
        finally {
            this.queryLocations = null;
            this.loops = null;
        }
    }

    public void visitCode(Code obj) {
        this.queryLocations.clear();
        this.loops.clear();
        super.visitCode(obj);
        Iterator<Integer> i$ = this.queryLocations.iterator();
        block0: while (i$.hasNext()) {
            Integer qLoc = i$.next();
            Iterator<LoopLocation> i$2 = this.loops.iterator();
            while (i$2.hasNext()) {
                LoopLocation lLoc = i$2.next();
                if (!lLoc.isInLoop(qLoc)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SIL_SQL_IN_LOOP", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, qLoc.intValue()));
                continue block0;
            }
        }
    }

    public void sawOpcode(int seen) {
        int pc;
        int branchTarget;
        if (seen == 185) {
            String clsName = this.getClassConstantOperand();
            String methodName = this.getNameConstantOperand();
            if (queryClasses.contains(clsName) && queryMethods.contains(methodName)) {
                this.queryLocations.add(Integer14.valueOf(this.getPC()));
            }
        } else if ((seen == 167 || seen == 200) && (branchTarget = this.getBranchTarget()) < (pc = this.getPC())) {
            this.loops.add(new LoopLocation(branchTarget, pc));
        }
    }

    static {
        queryClasses.add("java/sql/Statement");
        queryClasses.add("java/sql/PreparedStatement");
        queryClasses.add("java/sql/CallableStatement");
        queryMethods = new HashSet<String>();
        queryMethods.add("execute");
        queryMethods.add("executeQuery");
    }

    private static class LoopLocation {
        private int startPC;
        private int endPC;

        public LoopLocation(int start, int end) {
            this.startPC = start;
            this.endPC = end;
        }

        public boolean isInLoop(int pc) {
            return pc >= this.startPC && pc <= this.endPC;
        }
    }
}

