/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.generic.Type;

public class PossiblyRedundantMethodCalls
extends BytecodeScanningDetector {
    public static final String PRMC_RISKY_FIELD_USER_KEY = "fbcontrib.PRMC.riskynames";
    public static final String PRMC_RISKY_CLASS_USER_KEY = "fbcontrib.PRMC.riskyclasses";
    public static final String PRMC_HIGH_BYTECOUNT = "fbcontrib.PRMC.highbytecount";
    public static final String PRMC_HIGH_METHODCALLS = "fbcontrib.PRMC.highmethodcalls";
    public static final String PRMC_NORMAL_BYTECOUNT = "fbcontrib.PRMC.normalbytecount";
    public static final String PRMC_NORMAL_METHODCALLS = "fbcontrib.PRMC.normalmethodcalls";
    private static Set<String> riskyMethodNameContents;
    private static int highByteCountLimit;
    private static int highMethodCallLimit;
    private static int normalByteCountLimit;
    private static int normalMethodCallLimit;
    private static Set<String> riskyClassNames;
    private BugReporter bugReporter;
    private OpcodeStack stack = null;
    private Map<Integer, MethodCall> localMethodCalls = null;
    private Map<String, MethodCall> fieldMethodCalls = null;
    private Set<Integer> branchTargets = null;

    public PossiblyRedundantMethodCalls(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.localMethodCalls = new HashMap<Integer, MethodCall>();
            this.fieldMethodCalls = new HashMap<String, MethodCall>();
            this.branchTargets = new HashSet<Integer>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.localMethodCalls = null;
            this.fieldMethodCalls = null;
            this.branchTargets = null;
        }
    }

    public void visitCode(Code obj) {
        CodeException[] codeExceptions;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localMethodCalls.clear();
        this.fieldMethodCalls.clear();
        this.branchTargets.clear();
        CodeException[] arr$ = codeExceptions = obj.getExceptionTable();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CodeException codeEx = arr$[i$];
            this.branchTargets.add(Integer14.valueOf(codeEx.getHandlerPC()));
        }
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            if (this.branchTargets.remove(Integer14.valueOf(this.getPC()))) {
                this.localMethodCalls.clear();
                this.fieldMethodCalls.clear();
            }
            if (seen >= 153 && seen <= 167 || seen >= 198 && seen <= 200) {
                this.branchTargets.add(Integer14.valueOf(this.getBranchTarget()));
            } else if (seen == 170 || seen == 171) {
                int[] offsets = this.getSwitchOffsets();
                int pc = this.getPC();
                int[] arr$ = offsets;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    int offset = arr$[i$];
                    this.branchTargets.add(Integer14.valueOf(offset + pc));
                }
            } else if (seen == 58 || seen >= 75 && seen <= 78) {
                this.localMethodCalls.remove(Integer14.valueOf(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen)));
            } else if (seen == 181) {
                this.fieldMethodCalls.remove(this.getNameConstantOperand());
            } else if (seen == 182 || seen == 185) {
                String className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                String signature = this.getSigConstantOperand();
                int parmCount = Type.getArgumentTypes((String)signature).length;
                if (this.stack.getStackDepth() > parmCount) {
                    MethodCall mc;
                    Object[] parmConstants = new Object[parmCount];
                    for (int i = 0; i < parmCount; ++i) {
                        OpcodeStack.Item parm = this.stack.getStackItem(i);
                        parmConstants[i] = parm.getConstant();
                        if (parmConstants[i] != null) continue;
                        return;
                    }
                    OpcodeStack.Item obj = this.stack.getStackItem(parmCount);
                    int reg = obj.getRegisterNumber();
                    XField field = obj.getXField();
                    if (reg >= 0) {
                        mc = this.localMethodCalls.get(Integer14.valueOf(reg));
                    } else if (field != null) {
                        mc = this.fieldMethodCalls.get(field.getName());
                    } else {
                        return;
                    }
                    if (mc != null) {
                        Object[] parms;
                        if (!signature.endsWith("V") && methodName.equals(mc.getName()) && signature.equals(mc.getSignature()) && !this.isRiskyName(className, methodName) && Arrays.equals(parms = mc.getParms(), parmConstants)) {
                            Statistics statistics = Statistics.getStatistics();
                            Statistics.MethodInfo mi = statistics.getMethodStatistics(this.getClassConstantOperand(), methodName, signature);
                            this.bugReporter.reportBug(new BugInstance((Detector)this, "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", mi.numBytes >= highByteCountLimit || mi.numMethodCalls >= highMethodCallLimit ? 1 : (mi.numBytes >= normalByteCountLimit || mi.numMethodCalls >= normalMethodCallLimit ? 2 : (mi.numBytes == 0 || mi.numMethodCalls == 0 ? 3 : 4))).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(methodName + signature));
                        }
                        if (reg >= 0) {
                            this.localMethodCalls.remove(Integer14.valueOf(reg));
                        } else {
                            this.fieldMethodCalls.remove(field.getName());
                        }
                    } else if (reg >= 0) {
                        this.localMethodCalls.put(Integer14.valueOf(reg), new MethodCall(methodName, signature, parmConstants));
                    } else if (field != null) {
                        this.fieldMethodCalls.put(field.getName(), new MethodCall(methodName, signature, parmConstants));
                    }
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean isRiskyName(String className, String methodName) {
        if (riskyClassNames.contains(className)) {
            return true;
        }
        methodName = methodName.toLowerCase(Locale.ENGLISH);
        Iterator<String> i$ = riskyMethodNameContents.iterator();
        while (i$.hasNext()) {
            String riskyName = i$.next();
            if (methodName.indexOf(riskyName) < 0) continue;
            return true;
        }
        return false;
    }

    static {
        Integer prop;
        String name;
        int i$;
        int len$;
        String[] arr$;
        String[] userNames;
        riskyMethodNameContents = new HashSet<String>();
        highByteCountLimit = 200;
        highMethodCallLimit = 10;
        normalByteCountLimit = 50;
        normalMethodCallLimit = 4;
        riskyMethodNameContents.add("next");
        riskyMethodNameContents.add("add");
        riskyMethodNameContents.add("create");
        riskyMethodNameContents.add("append");
        riskyMethodNameContents.add("put");
        riskyMethodNameContents.add("remove");
        riskyMethodNameContents.add("read");
        riskyMethodNameContents.add("write");
        riskyMethodNameContents.add("push");
        riskyMethodNameContents.add("pop");
        riskyMethodNameContents.add("scan");
        riskyMethodNameContents.add("skip");
        riskyMethodNameContents.add("clone");
        riskyMethodNameContents.add("close");
        riskyMethodNameContents.add("copy");
        String userNameProp = System.getProperty(PRMC_RISKY_FIELD_USER_KEY);
        if (userNameProp != null) {
            arr$ = userNames = userNameProp.split("\\s*,\\s*");
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                name = arr$[i$];
                riskyMethodNameContents.add(name.toLowerCase(Locale.getDefault()));
            }
        }
        if ((prop = Integer.getInteger(PRMC_HIGH_BYTECOUNT)) != null) {
            highByteCountLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_HIGH_METHODCALLS)) != null) {
            highMethodCallLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_NORMAL_BYTECOUNT)) != null) {
            normalByteCountLimit = prop;
        }
        if ((prop = Integer.getInteger(PRMC_NORMAL_METHODCALLS)) != null) {
            normalMethodCallLimit = prop;
        }
        riskyClassNames = new HashSet<String>();
        riskyClassNames.add("java/nio/ByteBuffer");
        riskyClassNames.add("java/io/DataInputStream");
        riskyClassNames.add("java/io/ObjectInputStream");
        userNameProp = System.getProperty(PRMC_RISKY_CLASS_USER_KEY);
        if (userNameProp != null) {
            arr$ = userNames = userNameProp.split("\\s*,\\s*");
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                name = arr$[i$];
                riskyClassNames.add(name);
            }
        }
    }

    static class MethodCall {
        private String methodName;
        private String methodSignature;
        private Object[] methodParms;

        public MethodCall(String name, String signature, Object[] parms) {
            this.methodName = name;
            this.methodSignature = signature;
            this.methodParms = parms;
        }

        public String getName() {
            return this.methodName;
        }

        public String getSignature() {
            return this.methodSignature;
        }

        public Object[] getParms() {
            return this.methodParms;
        }
    }
}

