/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class PossibleMemoryBloat
extends BytecodeScanningDetector {
    private static final Set<String> bloatableSigs = new HashSet<String>();
    private static final Set<String> decreasingMethods;
    private static final Set<String> increasingMethods;
    private final BugReporter bugReporter;
    private Map<XField, SourceLineAnnotation> bloatableFields;
    private OpcodeStack stack;
    private String methodName;

    public PossibleMemoryBloat(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            Field[] fields;
            this.bloatableFields = new HashMap<XField, SourceLineAnnotation>();
            JavaClass cls = classContext.getJavaClass();
            Field[] arr$ = fields = cls.getFields();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String sig;
                Field f = arr$[i$];
                if (!f.isStatic() || !bloatableSigs.contains(sig = f.getSignature())) continue;
                this.bloatableFields.put(XFactory.createXField((String)cls.getClassName(), (String)f.getName(), (String)f.getSignature(), (boolean)f.isStatic()), null);
            }
            if (this.bloatableFields.size() > 0) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
                Iterator<Map.Entry<XField, SourceLineAnnotation>> i$ = this.bloatableFields.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry<XField, SourceLineAnnotation> entry = i$.next();
                    SourceLineAnnotation sla = entry.getValue();
                    if (sla == null) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "PMB_POSSIBLE_MEMORY_BLOAT", 2).addClass((PreorderVisitor)this).addSourceLine(sla).addField(entry.getKey()));
                }
            }
        }
        finally {
            this.stack = null;
            this.bloatableFields = null;
        }
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        if ("<clinit>".equals(this.methodName) || "<init>".equals(this.methodName)) {
            return;
        }
        if (this.bloatableFields.size() > 0) {
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            if (this.bloatableFields.isEmpty()) {
                return;
            }
            if (seen == 182 || seen == 185) {
                OpcodeStack.Item itm;
                XField field;
                String sig = this.getSigConstantOperand();
                int argCount = Type.getArgumentTypes((String)sig).length;
                if (this.stack.getStackDepth() > argCount && (field = (itm = this.stack.getStackItem(argCount)).getXField()) != null && this.bloatableFields.containsKey(field)) {
                    String methodName = this.getNameConstantOperand();
                    if (decreasingMethods.contains(methodName)) {
                        this.bloatableFields.remove(field);
                    } else if (increasingMethods.contains(methodName) && this.bloatableFields.get(field) == null) {
                        SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
                        this.bloatableFields.put(field, sla);
                    }
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    static {
        bloatableSigs.add("Ljava/util/ArrayList;");
        bloatableSigs.add("Ljava/util/Collection;");
        bloatableSigs.add("Ljava/util/HashMap;");
        bloatableSigs.add("Ljava/util/HashSet;");
        bloatableSigs.add("Ljava/util/Hashtable;");
        bloatableSigs.add("Ljava/util/IdentityHashMap;");
        bloatableSigs.add("Ljava/util/LinkedHashMap;");
        bloatableSigs.add("Ljava/util/LinkedList;");
        bloatableSigs.add("Ljava/util/List;");
        bloatableSigs.add("Ljava/util/Map;");
        bloatableSigs.add("Ljava/util/Set;");
        bloatableSigs.add("Ljava/util/SortedSet;");
        bloatableSigs.add("Ljava/util/SortedMap;");
        bloatableSigs.add("Ljava/util/Stack;");
        bloatableSigs.add("Ljava/lang/StringBuffer;");
        bloatableSigs.add("Ljava/lang/StringBuilder;");
        bloatableSigs.add("Ljava/util/TreeMap;");
        bloatableSigs.add("Ljava/util/TreeSet;");
        bloatableSigs.add("Ljava/util/Vector;");
        decreasingMethods = new HashSet<String>();
        decreasingMethods.add("clear");
        decreasingMethods.add("delete");
        decreasingMethods.add("deleteCharAt");
        decreasingMethods.add("pop");
        decreasingMethods.add("remove");
        decreasingMethods.add("removeAll");
        decreasingMethods.add("removeAllElements");
        decreasingMethods.add("removeElementAt");
        decreasingMethods.add("removeRange");
        decreasingMethods.add("setLength");
        increasingMethods = new HashSet<String>();
        increasingMethods.add("add");
        increasingMethods.add("addAll");
        increasingMethods.add("addElement");
        increasingMethods.add("addFirst");
        increasingMethods.add("addLast");
        increasingMethods.add("append");
        increasingMethods.add("insertElementAt");
        increasingMethods.add("put");
    }
}

