/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class PossibleIncompleteSerialization
implements Detector {
    private BugReporter bugReporter;

    public PossibleIncompleteSerialization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass superCls;
            JavaClass cls = classContext.getJavaClass();
            if (this.isSerializable(cls) && !this.isSerializable(superCls = cls.getSuperClass()) && this.hasSerializableFields(superCls) && !this.hasSerializingMethods(cls)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "PIS_POSSIBLE_INCOMPLETE_SERIALIZATION", 2).addClass(cls));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    private boolean isSerializable(JavaClass cls) throws ClassNotFoundException {
        JavaClass[] infs;
        JavaClass[] arr$ = infs = cls.getAllInterfaces();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JavaClass inf = arr$[i$];
            String clsName = inf.getClassName();
            if (!"java.io.Serializable".equals(clsName) && !"java.io.Externalizable".equals(clsName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerializableFields(JavaClass cls) {
        Field[] fields;
        Field[] arr$ = fields = cls.getFields();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field f = arr$[i$];
            if (f.isStatic() || f.isTransient() || f.isSynthetic()) continue;
            return true;
        }
        return false;
    }

    private boolean hasSerializingMethods(JavaClass cls) {
        Method[] methods;
        Method[] arr$ = methods = cls.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            if (m.isStatic()) continue;
            String methodName = m.getName();
            String methodSig = m.getSignature();
            if ("writeObject".equals(methodName) && "(Ljava/io/ObjectOutputStream;)V".equals(methodSig)) {
                return true;
            }
            if (!"writeExternal".equals(methodName) || !"(Ljava/io/ObjectOutput;)V".equals(methodSig)) continue;
            return true;
        }
        return false;
    }

    public void report() {
    }
}

