/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class ParallelLists
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private Set<String> listFields;
    private Map<Integer, String> indexToFieldMap;

    public ParallelLists(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            Field[] flds;
            JavaClass cls = classContext.getJavaClass();
            this.listFields = new HashSet<String>();
            Field[] arr$ = flds = cls.getFields();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Field f = arr$[i$];
                String sig = f.getSignature();
                if (sig.charAt(0) == 'L') {
                    if (!(sig = sig.substring(1, sig.length() - 1)).startsWith("java/util/") || !sig.endsWith("List")) continue;
                    this.listFields.add(f.getName());
                    continue;
                }
                if (sig.charAt(0) != '[' || sig.charAt(1) == '[') continue;
                this.listFields.add(f.getName());
            }
            if (this.listFields.size() > 0) {
                this.stack = new OpcodeStack();
                this.indexToFieldMap = new HashMap<Integer, String>();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
            this.indexToFieldMap = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.indexToFieldMap.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            if (seen == 185) {
                String className = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                String methodSig = this.getSigConstantOperand();
                if ("java/util/List".equals(className) && "get".equals(methodName) && "(I)Ljava/lang/Object;".equals(methodSig)) {
                    this.checkParms();
                }
            } else if (seen >= 153 && seen <= 177) {
                this.indexToFieldMap.clear();
            } else if (seen == 54 || seen == 132 || seen >= 59 && seen <= 62) {
                int reg = this.getIntOpRegister(seen);
                this.indexToFieldMap.remove(Integer14.valueOf(reg));
            } else if (seen >= 46 && seen <= 53) {
                this.checkParms();
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private int getIntOpRegister(int seen) {
        if (seen == 54 || seen == 132) {
            return this.getRegisterOperand();
        }
        return seen - 59;
    }

    private void checkParms() {
        if (this.stack.getStackDepth() >= 2) {
            OpcodeStack.Item index = this.stack.getStackItem(0);
            OpcodeStack.Item list = this.stack.getStackItem(1);
            int indexReg = index.getRegisterNumber();
            XField field = list.getXField();
            if (indexReg >= 0 && field != null && this.listFields.contains(field.getName())) {
                String f = this.indexToFieldMap.get(Integer14.valueOf(indexReg));
                if (f != null && !f.equals(field.getName())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "PL_PARALLEL_LISTS", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.getPC()));
                    this.listFields.remove(field.getName());
                    this.indexToFieldMap.clear();
                } else {
                    this.indexToFieldMap.put(Integer14.valueOf(indexReg), field.getName());
                }
            }
        }
    }
}

