/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.Integer14;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlyConcreteParameter
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private JavaClass[] constrainingClasses;
    private Map<Integer, Map<JavaClass, List<MethodInfo>>> parameterDefiners;
    private Set<Integer> usedParameters;
    private JavaClass objectClass;
    private OpcodeStack stack;
    private int parmCount;
    private boolean methodSignatureIsConstrained;
    private boolean methodIsStatic;

    public OverlyConcreteParameter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.objectClass = Repository.lookupClass((String)"java/lang/Object");
        }
        catch (ClassNotFoundException cnfe) {
            bugReporter.reportMissingClass(cnfe);
            this.objectClass = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass[] infs = classContext.getJavaClass().getAllInterfaces();
            JavaClass[] sups = classContext.getJavaClass().getSuperClasses();
            this.constrainingClasses = new JavaClass[infs.length + sups.length];
            System.arraycopy(infs, 0, this.constrainingClasses, 0, infs.length);
            System.arraycopy(sups, 0, this.constrainingClasses, infs.length, sups.length);
            this.parameterDefiners = new HashMap<Integer, Map<JavaClass, List<MethodInfo>>>();
            this.usedParameters = new HashSet<Integer>();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.constrainingClasses = null;
            this.parameterDefiners = null;
            this.usedParameters = null;
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.methodSignatureIsConstrained = false;
        String methodName = obj.getName();
        if (!"<init>".equals(methodName) && !"<clinit>".equals(methodName)) {
            String parms;
            String methodSig = obj.getSignature();
            this.methodSignatureIsConstrained = this.methodIsSpecial(methodName, methodSig);
            if (!this.methodSignatureIsConstrained && (parms = methodSig.split("\\(|\\)")[1]).indexOf(59) >= 0) {
                block0: for (JavaClass cls : this.constrainingClasses) {
                    Method[] methods;
                    for (Method m : methods = cls.getMethods()) {
                        if (!methodName.equals(m.getName()) || !methodSig.equals(m.getSignature())) continue;
                        this.methodSignatureIsConstrained = true;
                        break block0;
                    }
                }
            }
        }
    }

    public void visitCode(Code obj) {
        try {
            if (this.methodSignatureIsConstrained) {
                return;
            }
            this.parameterDefiners.clear();
            this.usedParameters.clear();
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            if (obj.getCode() == null) {
                return;
            }
            Method m = this.getMethod();
            if (m.getName().startsWith("access$")) {
                return;
            }
            this.methodIsStatic = m.isStatic();
            this.parmCount = m.getArgumentTypes().length;
            if (this.parmCount == 0) {
                return;
            }
            if (this.buildParameterDefiners()) {
                super.visitCode(obj);
                this.reportBugs();
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        if (this.parameterDefiners.isEmpty()) {
            return;
        }
        try {
            this.stack.mergeJumps((DismantleBytecode)this);
            if (seen == 182 || seen == 184 || seen == 183 || seen == 185) {
                String methodSig = this.getSigConstantOperand();
                Type[] parmTypes = Type.getArgumentTypes((String)methodSig);
                int stackDepth = this.stack.getStackDepth();
                if (stackDepth >= parmTypes.length) {
                    for (int i = 0; i < parmTypes.length; ++i) {
                        OpcodeStack.Item itm = this.stack.getStackItem(i);
                        int reg = itm.getRegisterNumber();
                        this.removeUselessDefiners(parmTypes[parmTypes.length - i - 1].getSignature(), reg);
                    }
                }
                if (seen != 183 && seen != 184) {
                    if (stackDepth > parmTypes.length) {
                        int reg;
                        OpcodeStack.Item itm = this.stack.getStackItem(parmTypes.length);
                        int parm = reg = itm.getRegisterNumber();
                        if (!this.methodIsStatic) {
                            --parm;
                        }
                        if (parm >= 0 && parm < this.parmCount) {
                            this.removeUselessDefiners(reg);
                        }
                    } else {
                        this.parameterDefiners.clear();
                    }
                }
            } else if (seen == 58 || seen >= 75 && seen <= 78 || seen == 181 || seen == 180 || seen == 179 || seen == 178) {
                int parm;
                int reg;
                OpcodeStack.Item itm;
                if (this.stack.getStackDepth() > 0) {
                    itm = this.stack.getStackItem(0);
                    parm = reg = itm.getRegisterNumber();
                    if (!this.methodIsStatic) {
                        --parm;
                    }
                    if (parm >= 0 && parm < this.parmCount) {
                        this.parameterDefiners.remove(Integer14.valueOf(reg));
                    }
                } else {
                    this.parameterDefiners.clear();
                }
                if (seen == 180 || seen == 181) {
                    if (this.stack.getStackDepth() > 1) {
                        itm = this.stack.getStackItem(1);
                        parm = reg = itm.getRegisterNumber();
                        if (!this.methodIsStatic) {
                            --parm;
                        }
                        if (parm >= 0 && parm < this.parmCount) {
                            this.parameterDefiners.remove(Integer14.valueOf(reg));
                        }
                    } else {
                        this.parameterDefiners.clear();
                    }
                }
            } else if (seen == 25 || seen >= 42 && seen <= 45) {
                int reg;
                int parm = reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                if (!this.methodIsStatic) {
                    --parm;
                }
                if (parm >= 0 && parm < this.parmCount) {
                    this.usedParameters.add(Integer14.valueOf(reg));
                }
            } else if (seen == 83) {
                if (this.stack.getStackDepth() >= 3) {
                    int reg;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    int parm = reg = itm.getRegisterNumber();
                    if (!this.methodIsStatic) {
                        --parm;
                    }
                    if (parm >= 0 && parm < this.parmCount) {
                        this.parameterDefiners.remove(Integer14.valueOf(reg));
                    }
                } else {
                    this.parameterDefiners.clear();
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean methodIsSpecial(String methodName, String methodSig) {
        return "readObject".equals(methodName) && "(Ljava/io/ObjectInputStream;)V".equals(methodSig);
    }

    private void reportBugs() {
        Iterator<Map.Entry<Integer, Map<JavaClass, List<MethodInfo>>>> it = this.parameterDefiners.entrySet().iterator();
        while (it.hasNext()) {
            LocalVariable lv;
            Map.Entry<Integer, Map<JavaClass, List<MethodInfo>>> entry = it.next();
            Integer reg = entry.getKey();
            if (!this.usedParameters.contains(reg)) {
                it.remove();
                continue;
            }
            Map<JavaClass, List<MethodInfo>> definers = entry.getValue();
            definers.remove(this.objectClass);
            if (definers.size() <= 0) continue;
            String name = "";
            LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
            if (lvt != null && (lv = lvt.getLocalVariable(reg.intValue(), 0)) != null) {
                name = lv.getName();
            }
            int parm = reg;
            if (!this.methodIsStatic) {
                --parm;
            }
            String infName = definers.keySet().iterator().next().getClassName();
            this.bugReporter.reportBug(new BugInstance((Detector)this, "OCP_OVERLY_CONCRETE_PARAMETER", 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 0).addString(new StringBuffer().append("Parameter [").append(++parm).append("] ").append(name).append(" implements ").append(infName).toString()));
        }
    }

    private boolean buildParameterDefiners() throws ClassNotFoundException {
        Type[] parms = this.getMethod().getArgumentTypes();
        if (parms.length == 0) {
            return false;
        }
        boolean hasPossiblyOverlyConcreteParm = false;
        for (int i = 0; i < parms.length; ++i) {
            Map<JavaClass, List<MethodInfo>> definers;
            JavaClass cls;
            String clsName;
            String parm = parms[i].getSignature();
            if (!parm.startsWith("L") || (clsName = parm.substring(1, parm.length() - 1).replace('/', '.')).startsWith("java.lang.") || !(cls = Repository.lookupClass((String)clsName)).isClass() || (definers = this.getClassDefiners(cls)).size() <= 0) continue;
            this.parameterDefiners.put(Integer14.valueOf(i + (this.methodIsStatic ? 0 : 1)), definers);
            hasPossiblyOverlyConcreteParm = true;
        }
        return hasPossiblyOverlyConcreteParm;
    }

    private Map<JavaClass, List<MethodInfo>> getClassDefiners(JavaClass cls) throws ClassNotFoundException {
        HashMap<JavaClass, List<MethodInfo>> definers = new HashMap<JavaClass, List<MethodInfo>>();
        for (JavaClass ci : cls.getAllInterfaces()) {
            List<MethodInfo> methodInfos;
            if ("java.lang.Comparable".equals(ci.getClassName()) || (methodInfos = this.getPublicMethodInfos(ci)).size() <= 0) continue;
            definers.put(ci, methodInfos);
        }
        return definers;
    }

    private List<MethodInfo> getPublicMethodInfos(JavaClass cls) {
        Method[] methods;
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        for (Method m : methods = cls.getMethods()) {
            if ((m.getAccessFlags() & 5) == 0) continue;
            ExceptionTable et = m.getExceptionTable();
            methodInfos.add(new MethodInfo(m.getName(), m.getSignature(), et == null ? null : et.getExceptionNames()));
        }
        return methodInfos;
    }

    private void removeUselessDefiners(int reg) {
        Map<JavaClass, List<MethodInfo>> definers = this.parameterDefiners.get(Integer14.valueOf(reg));
        if (definers != null && definers.size() > 0) {
            String methodSig = this.getSigConstantOperand();
            String methodName = this.getNameConstantOperand();
            MethodInfo methodInfo = new MethodInfo(methodName, methodSig, null);
            Iterator<List<MethodInfo>> it = definers.values().iterator();
            while (it.hasNext()) {
                boolean methodDefined = false;
                List<MethodInfo> methodSigs = it.next();
                block1: for (MethodInfo mi : methodSigs) {
                    if (!methodInfo.equals(mi)) continue;
                    methodDefined = true;
                    String[] exceptions = mi.getMethodExceptions();
                    if (exceptions == null) break;
                    for (String ex : exceptions) {
                        if (this.isExceptionHandled(ex)) continue;
                        methodDefined = false;
                        break block1;
                    }
                }
                if (methodDefined) continue;
                it.remove();
            }
            if (definers.isEmpty()) {
                this.parameterDefiners.remove(Integer14.valueOf(reg));
            }
        }
    }

    private boolean isExceptionHandled(String ex) {
        try {
            CodeException[] catchExs;
            JavaClass thrownEx = Repository.lookupClass((String)ex);
            ExceptionTable et = this.getMethod().getExceptionTable();
            if (et != null) {
                String[] throwClauseExNames;
                for (String throwClauseExName : throwClauseExNames = et.getExceptionNames()) {
                    JavaClass throwClauseEx = Repository.lookupClass((String)throwClauseExName);
                    if (!thrownEx.instanceOf(throwClauseEx)) continue;
                    return true;
                }
            }
            if ((catchExs = this.getCode().getExceptionTable()) != null) {
                int pc = this.getPC();
                for (CodeException catchEx : catchExs) {
                    String catchExName;
                    JavaClass catchException;
                    int type;
                    if (pc < catchEx.getStartPC() || pc > catchEx.getEndPC() || (type = catchEx.getCatchType()) == 0 || !thrownEx.instanceOf(catchException = Repository.lookupClass((String)(catchExName = this.getConstantPool().getConstantString(type, (byte)7))))) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        return false;
    }

    private void removeUselessDefiners(String parmSig, int reg) {
        if (parmSig.startsWith("L")) {
            if ("java.lang.Object".equals(parmSig = parmSig.substring(1, parmSig.length() - 1).replace('/', '.'))) {
                this.parameterDefiners.remove(Integer14.valueOf(reg));
                return;
            }
            Map<JavaClass, List<MethodInfo>> definers = this.parameterDefiners.get(Integer14.valueOf(reg));
            if (definers != null && definers.size() > 0) {
                Iterator<JavaClass> it = definers.keySet().iterator();
                while (it.hasNext()) {
                    JavaClass definer = it.next();
                    if (definer.getClassName().equals(parmSig)) continue;
                    it.remove();
                }
                if (definers.isEmpty()) {
                    this.parameterDefiners.remove(Integer14.valueOf(reg));
                }
            }
        }
    }

    public static class MethodInfo {
        private final String methodName;
        private final String methodSig;
        private final String[] methodExceptions;

        public MethodInfo(String name, String sig, String[] excs) {
            this.methodName = name;
            this.methodSig = sig;
            this.methodExceptions = excs;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodSignature() {
            return this.methodSig;
        }

        public String[] getMethodExceptions() {
            return this.methodExceptions;
        }

        public int hashCode() {
            return this.methodName.hashCode() ^ this.methodSig.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MethodInfo)) {
                return false;
            }
            MethodInfo that = (MethodInfo)o;
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            return this.methodSig.equals(that.methodSig);
        }

        public String toString() {
            return this.methodName + this.methodSig;
        }
    }
}

